package ags.rougedc.base;

import ags.rougedc.robots.*;
import ags.rougedc.waves.EnemyWaveManager;
import ags.rougedc.movement.EnemyTargetingWatcher;
import java.util.List;

import robocode.Event;

/**
 * A base bot that deals with all necessary intelligence gathering by handling
 * the event list.
 *   
 * @author Alexander Schultz
 */
abstract public class InformedBotBase extends BotBase {
    private StatusRobot status;
    private EnemyList enemies;
    private EnemyWaveManager ewm;
    private EnemyTargetingWatcher etw;
    
    @Override
    public void init() {
        status = new StatusRobot(getRules());
        enemies = new EnemyList(getRules(), getStatus());
        ewm = new EnemyWaveManager(getRules(), getStatus(), getEnemies());
        etw = new EnemyTargetingWatcher(getEnemyWaveManager());
    }
    
    public StatusRobot getStatus() {
        return status;
    }
    
    public EnemyList getEnemies() {
        return enemies;
    }
    
    public EnemyWaveManager getEnemyWaveManager() {
        return ewm;
    }
    
    public EnemyTargetingWatcher getEnemyTargetingWatcher() {
        return etw;
    }

    /* (non-Javadoc)
     * @see ags.rougedc.base.BotBase#runTick(java.util.List)
     */
    @Override
    public void runTick(List<Event> events) {
        status.handleEvents(events);
        enemies.handleEvents(events);
        ewm.run();
        etw.handleEvents(events);
    }

    // Keep StatusBot informed of our intentions
    @Override
    public void setAhead(double arg0) {
        super.setAhead(arg0);
        status.setMove(arg0);
    }
    @Override
    public void setBack(double arg0) {
        setAhead(-arg0);
    }
    @Override
    public void setTurnRightRadians(double arg0) {
        super.setTurnRightRadians(arg0);
        status.setTurnBody(arg0);
    }
    @Override
    public void setTurnLeftRadians(double arg0) {
        setTurnRightRadians(-arg0);
    }
}
