/*
 * Written by Kinsen Choy
 */

package kinsen.melee.Guns;
import kinsen.melee.Details;

/*
 * Linear - A gun class that fires linearly predicted bullets.
 */
public class Linear extends Gun
{
	// Last enemy details
	private Details enemy = null;
	// Last my details
	private Details me = null;

	public void calculateGun(double initialFirePower)
	{
		// If there is no data then it can not fire
		if (enemy != null)
		{
			firePower = initialFirePower;
			fireAt = super.predictPosition(enemy.getX(), enemy.getY(), me.getX(), me.getY(), enemy.getHeading(), enemy.getVelocity(), 0, firePower);
		}
	}

	public void calculateGun(double initialFirePower, boolean canChangePower)
	{
		calculateGun(initialFirePower);
	}

	public void recordData(Details enemyDetails, Details myDetails, long time)
	{
		enemy = enemyDetails;
		me = myDetails;
	}
}