
package sgp;

public class EnemyBattleState
{
	protected Coordinate enemyPosition = new Coordinate(Environment.battleFieldWidth / 2, Environment.battleFieldHeight / 2); //position of this enemy
	protected double heading = 0;
	protected double velocity = 0;
	protected Coordinate closestRobotPosition = new Coordinate(Environment.battleFieldWidth / 2, Environment.battleFieldHeight / 2);
	
	protected Coordinate robotPosition = new Coordinate(); //position of jollyninja
	
	protected RobotBulletList robotBulletList = null; //list of bullets shot at this enemy by jollyninja

	/**
	 * Constructor for EnemyBattleState.
	 */
	public EnemyBattleState(RobotBulletList theRobotBulletList)
	{
		super();
		robotBulletList = theRobotBulletList;
	}
	
	public void step(Coordinate nextRobotPosition, double nextHeading, double nextVelocity)
	{
		enemyPosition.set(nextRobotPosition);
		heading = nextHeading;
		velocity = nextVelocity;
		
	}
	
	public double getGoodness()
	{
		double goodness = Strategy.evaluateWallGoodness(enemyPosition);
		
		if (Environment.getRobot().getOthers() == 1)
		{
			goodness += robotBulletList.getTotalDistance(enemyPosition);
		}
		else
		{
			double distanceToClosestOtherRobot = enemyPosition.distanceFrom(closestRobotPosition);
			goodness += distanceToClosestOtherRobot;
		}
		return goodness;
	}
	
	

}
