/*
 * Class.java
 *
 * Created on April 7, 2002, 12:54 AM
 */

package tobe.util;

/**
 *
 * @author  tobe
 * @version 
 */
public class RobotStats {
            
            private java.util.Vector fired = new java.util.Vector();
            private java.util.Vector deltas = new java.util.Vector();
            private int current = 0;
            private final int MAX_DELTAS = 8000;
            private BearingVector previousPosition = new BearingVector();
            private BearingVector previousMovement = new BearingVector();
            private double previousTime;
			private double previousLife;
            private boolean seenFoe;
			public final String name;
			public double shotTravelTime;
			
			private BearingVector m = new BearingVector();
			private BearingVector p = new BearingVector();

			public RobotStats() { name = null; shotTravelTime = 20;};
			public RobotStats(String name) { this.name = name; shotTravelTime = 20;};
			public RobotStats(String name, double time) { this.name = name; shotTravelTime = time;};
            
            public void init() {
                seenFoe = false;
            }
            
            public void died() {
                seenFoe = false;
            }
            
            public boolean canBeAimedAt() {return seenFoe && deltas.size() > 4;}
	
			public void markFired() {
				fired.add(new Integer(current));
			}
			
			private void increment() {
				current++;
            	if(current >= MAX_DELTAS) current = 0;
				if( fired.size() > 0 && ((Integer) fired.get(0)).intValue() == current) fired.remove(0);
            }
	
			public void updateDeltas(BearingVector position, BearingVector movement, double time, double life) {
				updateDeltas(position.getToX(), position.getToY(), movement.getBearing(), movement.getDistance(), time, life);
				/*int num = (int) Math.rint(time - previousTime);
				for( int i = 0; i < num; i++) {
                	if(deltas.size() > current) {
                    	((Delta) deltas.get(current)).setDelta(previousPosition, previousMovement,
                    	position, movement, time - previousTime);
						increment();
                	} else if(seenFoe) {
                    	deltas.add(new Delta(previousPosition, previousMovement,
                    		position, movement, time - previousTime));
                    	increment();
                	}
				}
                seenFoe = true;
                previousPosition.setVector(position);
                previousMovement.setVector(movement);
                previousTime = time;
				previousLife = life;*/
            }
            
            public void updateDeltas(double x, double y, double heading, double velocity, double time, double life) {
				int num = (int) Math.rint(time - previousTime);
				for( int i = 0; i < num; i++) {
                	if(deltas.size() > current) {
                    	((Delta) deltas.get(current)).setDelta(previousPosition, previousMovement,
                    	x, y, heading, velocity, time - previousTime);
                    	increment();
                	} else if(seenFoe) {
                    	deltas.add(new Delta(previousPosition, previousMovement,
                    		x, y, heading, velocity, time - previousTime));
                    	increment();
                	}
				}
                previousPosition.pointTo(x,y);
                previousMovement.setPolar(heading, velocity);
                previousTime = time;
				previousLife = life;
                seenFoe = true;
            }
            
            public void applyLatestDeltas(int num, BearingVector position, BearingVector movement) {
				if(previousLife == 0) return;
                int i = current - num;
				while( i < 0 ) i += deltas.size();
				applyDeltas(i, num, position, movement);
            }
            
            public void applyRandomDeltas(int num, BearingVector position, BearingVector movement) {
				if(previousLife == 0) return;
                double k = deltas.size()*Math.random();
				applyDeltas((int)k, num, position, movement);
            }
            
            public void applyRandomFiredDeltas(int num, BearingVector position, BearingVector movement) {
				if(previousLife == 0) return;
                int k;
				if(fired.size() > 0) {
					double r = fired.size()*Math.random();
					k = ((Integer) fired.get((int)r)).intValue();
					applyDeltas(k, num, position, movement);
				} else {
					applyRandomDeltas(num, position, movement);
				}
            }
            
            private void applyDeltas(int k, int num, BearingVector position, BearingVector movement) {
				if(previousLife == 0) return;
                for(int i=0, j=k; i < num; i++, j++){
					if(j>=deltas.size()) j=0;
                	((Delta) deltas.get(j)).applyTo(position, movement);
					if(position.getDistance() < 80) break;
				}
            }
            
            /*public void applyRandomDelta(BearingVector position, BearingVector movement) {
				if(previousLife == 0) return;
                double k = deltas.size()*Math.random();
                ((Delta) deltas.get((int) k)).applyTo(position, movement);
            }
            
            public void applyLatestDelta(BearingVector position, BearingVector movement) {
				if(previousLife == 0) return;
                int k = current-1;
				if(k<0)k=deltas.size()-1;
                ((Delta) deltas.get(k)).applyTo(position, movement);
            }
            
            public void applyRandomDeltaToOrigin(BearingVector position, BearingVector movement) {
				if(previousLife == 0) return;
                double k = deltas.size()*Math.random();
                ((Delta) deltas.get((int) k)).applyToOrigin(position, movement);
            }
            
            public void applyLatestDeltaToOrigin(BearingVector position, BearingVector movement) {
				if(previousLife == 0) return;
                int k = current - 1;
				if( k<0 ) k=deltas.size()-1;
                ((Delta) deltas.get((int) k)).applyToOrigin(position, movement);
            }*/
            
            public double latestBearing() {return previousPosition.getBearing();}
            public double latestDistance() {return previousPosition.getDistance();}
            public double latestTime() {return previousTime;}
			public double getLife() {return previousLife;}
            public BearingVector latestPosition() {return previousPosition;}
            public BearingVector latestMovement() {return previousMovement;}
}
