package paulk;
import robocode.*;
import robocode.util.*;
import java.awt.geom.*;
import java.util.*;

public class GF extends Targeting{
	static final int nbBins=199;
	static final int nbSegment=9*4*10*3;
	Map gfs,nbAmeliore[];
	String ancCible="p";
	int ancSegment=0;

	GF(Map s,Map l,PaulV3 r){
		super(s,l,r);
		gfs=new Hashtable();
		nbAmeliore=new Hashtable[nbSegment];
		for (int idSeg=0;idSeg<nbSegment;idSeg++)
			nbAmeliore[idSeg]=new Hashtable();
	}
	
	double maxEscapeAngle(double puissance){
		return Math.asin(8./Rules.getBulletSpeed(puissance));
	}

	int angle2bin(double angle,double puissance){
		double escape=maxEscapeAngle(puissance);
		double gf=angle/escape;
		int bin=(int)((gf+1.)/2.*(nbBins-1));
		return Math.max(0,Math.min(nbBins-1,bin));
	}

	double bin2angle(int bin,double puissance){
		double escape=maxEscapeAngle(puissance);
		return (((double)bin*2)/(nbBins-1)-1)*escape;
	}

	double angle(String nom){
	// GuessFactor Targeting
		if (!lastScanned.containsKey(nom))
			return -10000;
		List scanned=(List)scannedEvents.get(nom);
		if (scanned.size()<2)
			return -10000;
		ancCible=nom;
		ScannedRobotEvent e=(ScannedRobotEvent)lastScanned.get(nom);
		double angle=e.getBearingRadians()+bot.getHeadingRadians();
		double bins[][];
		if (!gfs.containsKey(nom)){
			bins=new double[nbSegment][nbBins];
			for (int idSeg=0;idSeg<nbSegment;idSeg++){
				bins[idSeg][nbBins/2]=0.1;
				nbAmeliore[idSeg].put(nom,0.1);
			}
			gfs.put(nom,bins);
		}
		else {
			bins=(double[][])gfs.get(nom);
		}
		int idMaxi=0;
		ScannedRobotEvent eLast=(ScannedRobotEvent)scanned.get(1);
		int segment=GF.getSegment(e,bot,eLast);
		ancSegment=segment;
//		System.out.println("segment="+segment);
		double acc=0,maxi=-1;
		double puiss=bot.puissance(e.getDistance());
		int taille=angle2bin(Math.asin(36./e.getDistance()),puiss)-nbBins/2;
		for (int idBin=0;idBin<nbBins;idBin++){
			acc+=bins[segment][idBin];
			if (idBin>=taille) acc-=bins[segment][idBin-taille];
			if (maxi<acc){
				idMaxi=idBin-Math.min(idBin,taille)/2;
				maxi=acc;
			}
		}
//		System.out.println(180/3.14*bin2angle(idMaxi,bot.puissance(e.getDistance())));
		return angle+bin2angle(idMaxi,puiss);
	}
	
	void ameliore(double anglePredit,MonOnde onde,Point2D.Double vraiePos,String nom){
		double dist=Math.max(20,onde.getPos().distance(onde.getAncPos()));
		double x=vraiePos.getX()-onde.getX();
		double y=vraiePos.getY()-onde.getY();
		double angle=Math.atan2(x,y);
		x=onde.getAncPos().getX()-onde.getX();
		y=onde.getAncPos().getY()-onde.getY();
		angle-=Math.atan2(x,y);
		angle=Utils.normalRelativeAngle(angle);
		double bins[][]=(double[][])gfs.get(nom);
		double energie=onde.getEnergie();
		int segment=onde.getSegment();
		int taille=angle2bin(Math.asin(18./dist),energie)-nbBins/2;
		int milieu=angle2bin(angle,energie);
//		System.out.println((milieu-taille/2)+" "+(milieu+taille/2)+" "+angle*180/3.14);
		double add=1;
		if (!onde.estVraie()) add=0.2;
		int debut=Math.max(0,milieu-taille);
		for (int idBin=debut;idBin<=Math.min(nbBins-1,debut+2*taille);idBin++){
			bins[segment][idBin]+=add;
		}
		double nb=(Double)nbAmeliore[segment].get(nom);
		nbAmeliore[segment].put(nom,nb+add);
		/*if (onde.estVraie()){
			for (int i=0;i<nbSegment;i++){
				System.out.println(nom+" "+i+" "+(Double)nbAmeliore[i].get(nom));
			}
		}*/
	}

	double getProba(String nom){
		if (gfs.containsKey(nom)){
			if (((List)scannedEvents.get(nom)).size()<2) return 1.;
			double somme=0;
			double bins[][]=(double[][])gfs.get(nom);
			int idMaxi=0;
			boolean ok=Math.random()<0.0001;
			ScannedRobotEvent e=(ScannedRobotEvent)lastScanned.get(nom);
			ScannedRobotEvent eLast=(ScannedRobotEvent)((List)scannedEvents.get(nom)).get(1);
			int segment=GF.getSegment(e,bot,eLast);
			double maxi=-1,acc=0;
			double puiss=bot.puissance(e.getDistance());
			int taille=angle2bin(Math.asin(36/e.getDistance()),puiss)-nbBins/2;
			for (int idBin=0;idBin<nbBins;idBin++){
				acc+=bins[segment][idBin];
				if (idBin>=taille) acc-=bins[segment][idBin-taille];
				if (maxi<acc){
					maxi=acc;
				}
//				if (ok)
//					System.out.println(idBin+" "+bins[segment][idBin]);
			}
			double p=maxi/(Double)nbAmeliore[segment].get(nom);
	//		System.out.println("proba="+p);
			return p;
		}
		return 1.;
	}
	public void onPaint(java.awt.Graphics2D g) {
		if (!gfs.containsKey(ancCible)) return;
		g.setColor(java.awt.Color.red);
		double bins[][]=(double[][])gfs.get(ancCible);
		double nb=(Double)nbAmeliore[ancSegment].get(ancCible);
		for (int i=1;i<nbBins;i++){
			int x1=(int)(200./nbBins*(i-1)),x2=(int)(200./nbBins*i);
			int y1=(int)(800.*bins[ancSegment][i-1]/nb),y2=(int)(800.*bins[ancSegment][i]/nb);
			g.drawLine(x1,y1,x2,y2);
		}

	}
	static int getSegment(ScannedRobotEvent e,PaulV3 bot,ScannedRobotEvent eLast){
		double angle=e.getBearingRadians()+bot.getHeadingRadians();
		int vitesse=(int)(4+e.getVelocity()/2.); // [0;9[
		double temps=e.getDistance()/(20-3.*bot.puissance(e.getDistance()));
		int t=0;
		if (temps>15) t=1;
		if (temps>30) t=2;
		if (temps>50) t=3; // [0;4[
		int lateral=(int)(4.99*(1+Math.sin(e.getHeadingRadians()-angle))); // [0;10[
		int accel=(int)Math.abs(e.getVelocity()-eLast.getVelocity()); // [0;3[
		accel=Math.max(0,Math.min(3,accel));
		return ((vitesse*4+t)*10+lateral)*3+accel;
	}
}
