package suh.nano;

import robocode.*;
import robocode.util.Utils;

public class MirrorH extends AdvancedRobot {
    @Override
    public void run() {
	setAdjustGunForRobotTurn(true);
	setAdjustRadarForGunTurn(true);
	setAdjustRadarForRobotTurn(true);
	setTurnRadarRightRadians(Double.POSITIVE_INFINITY);
	while(true) {
	    execute();
	}
    }
    
    @Override
    public void onScannedRobot(ScannedRobotEvent e) {
	double bearing;
	
	// Radar
	setTurnRadarRightRadians(2.0 * Utils.normalRelativeAngle((bearing = getHeadingRadians() + e.getBearingRadians()) - getRadarHeadingRadians()));
	
	// Targeting
	setTurnGunRightRadians(Utils.normalRelativeAngle(bearing - getGunHeadingRadians()));
	setFire(Math.min(600.0 / e.getDistance(), e.getEnergy() / 4.0));
	
	// Movement
	goTo(getBattleFieldWidth() - (getX() + e.getDistance() * Math.sin(bearing)),  
		getBattleFieldHeight() - (getY() + e.getDistance() * Math.cos(bearing)));
    }
    
    private void goTo(double x, double y) {
	double angle, turnAngle;
	setTurnRightRadians(turnAngle = Math.atan(Math.tan(angle = Utils.normalRelativeAngle(Math.atan2(x = x - getX(), y = y - getY()) - getHeadingRadians()))));
	setAhead((angle == turnAngle) ? Math.hypot(x, y) : -Math.hypot(x, y));
    }
}
