package bvh.fnr;

/**********************************************************************
** Constanten zijn apart vastgelegd in interface
**********************************************************************/
interface Constanten {
// goniometrische constanten:
   static final double TWEEPI               = 2D*Math.PI;   // 360 graden draaien
   static final double PI                   = Math.PI;      // 180 graden draaien
   static final double DRIEKWARTPI          = 3D*Math.PI/4D;// 135 graden draaien
   static final double HALFPI               = Math.PI/2D;   //  90 graden draaien
   static final double DRIEACHTSTEPI        = 3D*Math.PI/8D;//  67.5 graden draaien
   static final double KWARTPI              = Math.PI/4D;   //  45 graden draaien
   static final double EENACHTSTEPI         = 1D*Math.PI/8D;//  67.5 graden draaien

// Bot-specifieke constanten:
   static final double MAXIMUM_SNELHEID     = 8D;
   static final double STANDAARDLOOPAFSTAND = 36D;      // kleine stapjes (draaihoek is belangrijker)
   static final double WANDAFSTAND          = 54D;      // minimale afstand tot wand: anders bewegingsrichting omkeren
   static final double RONDING              = 75D;      // ronding van slagveld
   static final double MAXVUURKRACHT        = 3.0D;     // maximale vuurkracht
   static final double MINVUURKRACHT        = 0.1D;     // minimale vuurkracht: doel is constante overbruggingstijd
                                                        // van kogels in bepaald afstand bereik.
// constanten voor patroonherkenning:
   static final int    PATROONLENGTE        = 100000;
   static final int    ZOEK_DIEPTE          = 50;        // lengte in patroon dat moet worden ge-matched (niet groter dan 25 a 30 maken!)

// constanten voor opslaan doel-data:
   static final int    FILE_LENGTE          = 10000;
   static final int    MAX_DATA_DIRECTORY   = 200000;    // nog controleren!
// Debug-modus:
   static final int    DEBUGMODE            = 0;         // 0: geen debug meldingen, 1: doel/schiet-info, 2: incl. bewegingsinfo, 3: alle info
}
