package cw.megas;
import robocode.*;
import java.awt.geom.*;
import java.awt.Color;
import java.awt.Graphics;
import java.util.ArrayList;

public class Blade extends AdvancedRobot {	

	//melee battle variables
	boolean gunLock;
	static double bulletPower;
	boolean inCorner;
	int moveDirectionM = -1;
	double previousEnergy = 100;
	
	//melee detection boolean
	static boolean melee;
	
	//melee gun variables
	static String	lastTarget;
	static double	lastDistance;
	double gunTurn;
	
	//melee movement variables
	double distanceToTravel = 0;
	boolean hasMoved = false;

	//single battle variables
	double the;
	ArrayList<MovementWave> moveWaves=new ArrayList<MovementWave>();
	static double learningAngle[] = new double[12];	//arraylist for learning angles
	//grid surfing enemy gun variables
	double counter = 0;

	int moveDirection = 1;
	double enemyEnergy = 100;
	//public double wallStick = 120;

	//gun variables
	static double bPow = 2; // Bullet Power - change it to whatever you like.
	static final double bVel = 20-3*bPow;
	static final int patDep = 30;
	static String eLog = "00000000000000000000000000888888";
	static double absB;


	public void run() {
		
		setAdjustGunForRobotTurn(true);
		setAdjustRadarForGunTurn(true);
		
		while(true){
			
			turnRadarRight(360);
			execute();
		}
	}

	public void onScannedRobot(ScannedRobotEvent e) {
		//melee scanning
		if (getOthers() > 1) {
			setColors(Color.darkGray,Color.black,Color.orange,Color.blue,Color.red);
			melee = true;
		} else {
			melee = false;
			setBodyColor(new Color(20,0,0));
			setGunColor(Color.lightGray);
			setRadarColor(Color.white);
			setScanColor(Color.lightGray);
			setBulletColor(Color.white);
		}
		
		
		if (melee == false) {
			//setMaxVelocity(Math.random() * 5 + 2);
			setAhead(100 * moveDirection);
			double absoluteBearing = e.getBearingRadians() + getHeadingRadians();
			double goalDirection = e.getBearing() - 90 - (moveDirection * 10);
			setTurnRightRadians(getWallSmoothedTurn(Math.toRadians(goalDirection)));
	
			setTurnRadarRightRadians(robocode.util.Utils.normalRelativeAngle(absoluteBearing - getRadarHeadingRadians()) * 3);
			double energyChange=(enemyEnergy-(enemyEnergy=e.getEnergy()));
			if( energyChange > 0 && energyChange <= 3) {
				logMovementWave(e,energyChange);
			}
			enemyEnergy = e.getEnergy();
			//painting too much inbetween actions :(
			paint(e);
			Movement(e);
			//chooseDirection(e);
			gun(e);
		} 
		if (melee == true) {
			doMelee(e);
		}
	}
	
	public void doMelee(ScannedRobotEvent e) {
		// Replace the next line with any behavior you would like
		double absoluteBearing = e.getBearingRadians() + getHeadingRadians();
		fire(e.getEnergy() / 4);
		//experimental gun infinity combination
		double  distance = e.getDistance();
		if(getGunHeat() == 0) {
			lastDistance = Double.POSITIVE_INFINITY;
		}
		if(lastDistance >= distance)	{
			lastDistance = distance;
			lastTarget = e.getName();
		}
		
		cornerMovement(e);
		if(lastTarget == e.getName()) {
			
			setTurnGunRightRadians(robocode.util.Utils.normalRelativeAngle(absoluteBearing-getGunHeadingRadians()));
			
		}
		
	}				
	
	public void cornerMovement(ScannedRobotEvent e) {
		if (getTime() % 31 == 0) {
			moveDirectionM *= -1;
			inCorner = false;
		}
		double Direction = e.getBearing() - 90 + 30 * moveDirectionM;
		setTurnRightRadians(getWallSmoothedTurn(Math.toRadians(Direction)));
		setAhead(100 * moveDirection);
		Graphics g = getGraphics();
		g.setColor(Color.yellow);
		g.drawRect((int)retrieveX(e) - 9,(int)retrieveY(e) - 9,18,18);
		g.setColor(Color.yellow);
		g.drawOval((int)getX() - 100,(int)getY() - 100,200,200);
		if (getOthers() >= 4) {
			//g.setColor(new Color(250,0,0,200));
			//g.fillOval((int)retrieveX(e) - 100,(int)retrieveY(e) - 100,200,200);
			g.setColor(Color.red);
			g.drawOval((int)retrieveX(e) - 100,(int)retrieveY(e) - 100,200,200);
		} else 	if (e.getDistance() <= 200) {
			double goalDirection = e.getBearing() - 90 * moveDirection;
			setTurnRightRadians(getWallSmoothedTurn(Math.toRadians(goalDirection)));
			g.setColor(Color.red);
			g.drawRect((int)retrieveX(e) - 18,(int)retrieveY(e) - 18,36,36);
		} 
			
		double changeInEnergy = previousEnergy - e.getEnergy();
		if (changeInEnergy > 0 && changeInEnergy <= 3) {
			setAhead(10 * moveDirection);
			inCorner = false;
		}
		setAhead(Math.round(Math.random() * 100 * moveDirection));
		double goalDirection = e.getBearing() - 90 - 30 * moveDirection;
		setTurnRightRadians(getWallSmoothedTurn(Math.toRadians(goalDirection)));
	}
	public void onHitByBullet(HitByBulletEvent e) {
		//returning gun angle
		counter++;
		for (int i = 0; i < moveWaves.size(); i++) {
			MovementWave w = moveWaves.get(i);
			double enemyFireX = w.enemyX;
			double enemyFireY = w.enemyY;
			double myFireX = w.firePlaceX;
			double myFireY = w.firePlaceY;
			double currentX = getX();
			double currentY = getY();
			double vector1X = enemyFireX - myFireX;
			double vector1Y = enemyFireY - myFireY;
			double vector2X = enemyFireX - currentX;
			double vector2Y = enemyFireY - currentY;
			double vector1AngleFromNorth = Math.atan2(vector1Y,vector1X);
			double vector2AngleFromNorth = Math.atan2(vector2Y,vector2X);
			double enemyGunAngle = vector2AngleFromNorth - vector1AngleFromNorth;
			if (counter == 1) {
				if (learningAngle[1] == 0) {
					learningAngle[1] = (enemyGunAngle);
				}
			}
			if (counter == 2) {
				if (learningAngle[1] != 0 && learningAngle[2] == 0 ){
					learningAngle[2] = (enemyGunAngle);
				}
			}
			if (counter == 3) {
				if (learningAngle[1] != 0 && learningAngle[2] != 0 && learningAngle[3] == 0) {
					learningAngle[3] = (enemyGunAngle);
				}
			}
			if (counter > 3) {
				counter = 0;
			}
		}
	}

	public void gun(ScannedRobotEvent e) {
		int i;
		if (getGunTurnRemaining() == 0) {
			if (getEnergy() < 10 || e.getEnergy() < 6) {
				fire(1);
			} else {
				setFire(bPow);
				if (e.getDistance() < 40) {
					bPow = 3;
				}
			}
		}
		absB = e.getBearingRadians();

		int mLen = patDep;
		int indX;
		eLog = String.valueOf( (char)Math.round(e.getVelocity() * Math.sin(e.getHeadingRadians() - ( absB+=getHeadingRadians() )))).concat(eLog);
		while((indX = eLog.indexOf(eLog.substring(0, mLen--), (i = (int)((e.getDistance())/bVel)))) < 0);
		while (--i > 0) {
			absB += Math.asin(((byte)eLog.charAt(indX--))/e.getDistance());
		}
		setTurnGunRightRadians(robocode.util.Utils.normalRelativeAngle(absB-getGunHeadingRadians()));
	}

	public double getWallSmoothedTurn(double t) {
		double wSD = 20; //wall smooth distance
		double turn = t;
		double predictiveDistance = 200;

		double ourHeading = getHeadingRadians();
		if (moveDirection == -1) {
			ourHeading += Math.PI;
		}
		Rectangle2D.Double bounds = new Rectangle2D.Double(wSD, wSD, getBattleFieldWidth() - 2 * wSD, getBattleFieldHeight() - 2 * wSD);

		while (true) {
			double totalTurn = turn + ourHeading;
			double dXTravel = Math.sin(totalTurn) * predictiveDistance;
			double dYTravel = Math.cos(totalTurn) * predictiveDistance;
			double finishX = getX() + dXTravel;
			double finishY = getY() + dYTravel;

			if (bounds.contains(finishX, finishY)) {
				return (turn);
			} else {
				turn += 0.1 * moveDirection;
			}
		}
	}	

	public void logMovementWave(ScannedRobotEvent e,double energyChange){
		double absBearing=e.getBearingRadians()+getHeadingRadians();
		MovementWave w=new MovementWave();
		//This is the spot that the enemy was in when they fired.
		w.origin=project(new Point2D.Double(getX(),getY()),e.getDistance(),absBearing);
		//20-3*bulletPower is the formula to find a bullet's speed.
		w.speed=20-3*energyChange;
		w.distanceFromOrigin = w.speed;
		//The time at which the bullet was fired.
		w.startTime=getTime();
		//The absolute bearing from the enemy to us can be found by adding Pi to our absolute bearing.
		w.angle=robocode.util.Utils.normalRelativeAngle(absBearing+Math.PI);
		/*
		 * Our lateral velocity, used to calculate where a bullet fired with linear targeting would be.
		 * Note that the speed has already been factored into the calculation.
		 */
		w.latVel=(getVelocity()*Math.sin(getHeadingRadians()-w.angle))/w.speed;

		w.enemyX = retrieveX(e);
		w.enemyY = retrieveY(e);
		w.firePlace = getX() + getY();
		w.firePlaceX = getX();
		w.firePlaceY = getY();
		//This actually adds the wave to the list.
		moveWaves.add(w);
	}
	public Point2D.Double project(Point2D.Double origin,double dist,double angle){
		return new Point2D.Double(origin.x+dist*Math.sin(angle),origin.y+dist*Math.cos(angle));
	}

	public double distanceFromTwoPoints(double x, double y, double a, double b) {
		for (int i = 0; i < moveWaves.size(); i++) {
			double radius;
			MovementWave w = moveWaves.get(i);
			radius=(getTime()-w.startTime)*w.speed+w.speed;
			Point2D.Double hotBullet=project(w.origin,radius,w.angle);

			double targetPlaceX = hotBullet.x;
			double targetPlaceY = hotBullet.y;
			targetPlaceX-=getX();
			targetPlaceY-=getY();

			double a2 = targetPlaceX;
			double b2 = targetPlaceY;
			double asquared = a2 * a2;
			double bsquared = b2 * b2;
			double difference = asquared + bsquared;
			double c2 = Math.sqrt(difference);			
			the = c2;
		}
		return(the);
	}
	public double retrieveX(ScannedRobotEvent e) {
		double edir = getHeadingRadians() + e.getBearingRadians();
		double X = getX() + Math.sin(edir) * e.getDistance();
		return(X);
	}

	public double retrieveY(ScannedRobotEvent e) {
		double edir = getHeadingRadians() + e.getBearingRadians();
		double Y = getY() + Math.cos(edir) * e.getDistance();
		return(Y);
	}
	public Point2D.Double bulletPredictDistanceDouble(double x, double y, double a, double b,double bulletAngle) {
		double xValue = 0;
		double yValue = distanceFromTwoPoints(x,y,a,b); // length of line
		double rotAngle = bulletAngle;//enter your own value(ratation angle) here later
		double rotateAngle = -(rotAngle);

		double hotXValue = xValue * Math.cos(rotateAngle) - Math.sin(rotateAngle) * (yValue);
		double hotYValue = xValue * Math.sin(rotateAngle) + Math.cos(rotateAngle) * (yValue);

		return new Point2D.Double(a + hotXValue,b + hotYValue);
	}

	public void chooseDirection(ScannedRobotEvent e){
		//drawing where he is moving
		double xValue = 0;
		double yValue = 100; // length of line
		double rotAngle = getHeadingRadians();//enter your own value(ratation angle) here later
		double rotateAngle = -(rotAngle);

		double hotXValue = xValue * Math.cos(rotateAngle) - Math.sin(rotateAngle) * (yValue);
		double hotYValue = xValue * Math.sin(rotateAngle) + Math.cos(rotateAngle) * (yValue);		
		
		Graphics g = getGraphics();
		g.setColor(Color.black);
		g.drawLine((int)getX() + (int)moveDirection * (int)hotXValue,(int)getY() + (int)moveDirection * (int)hotYValue,(int)getX(),(int)getY());
		g.setColor(Color.red);
		g.drawLine((int)getX() + (int)-moveDirection * (int)hotXValue,(int)getY() + (int)-moveDirection * (int)hotYValue,(int)getX(),(int)getY());
		g.drawRect((int)getX() - (36/2),(int)getY() - (36/2),36,36);
		
		//This for loop rates each angle individually
		double bestRating=Double.POSITIVE_INFINITY;
		for(double moveAngle=0;moveAngle<Math.PI*2;moveAngle+=Math.PI/16D){
			double rating=0;
 
			//Movepoint is position we would be at if we were to move one robot-length in the given direction. 
			Point2D.Double movePoint=project(new Point2D.Double(getX(),getY()),36,moveAngle);
 
			/*
			 * This loop will iterate through each wave and add a risk for the simulated bullets on each one
			 * to the total risk for this angle.
			 */
			for(int i=0;i<moveWaves.size();i++){
				MovementWave w=moveWaves.get(i);
 
				//This part will remove waves that have passed our robot, so we no longer keep taking into account old ones
				if(new Point2D.Double(getX(),getY()).distance(w.origin)<(getTime()-w.startTime)*w.speed+w.speed){
					moveWaves.remove(w);
				}
				else{
					/*
					 * This adds two risks for each wave: one based on the distance from where a head-on targeting
					 * bullet would be, and one for where a linear targeting bullet would be.
					 */
					out.println(rating);
					rating+=1D/Math.pow(movePoint.distance(project(w.origin,movePoint.distance(w.origin),w.angle)),2);
					rating+=1D/Math.pow(movePoint.distance(project(w.origin,movePoint.distance(w.origin),w.angle+w.latVel)),2);
					rating+=1D/Math.pow(movePoint.distance(project(w.origin,movePoint.distance(w.origin),w.learning1)),2);
					rating+=1D/Math.pow(movePoint.distance(project(w.origin,movePoint.distance(w.origin),w.angle+learningAngle[2])),2);
					rating+=1D/Math.pow(movePoint.distance(project(w.origin,movePoint.distance(w.origin),w.angle+learningAngle[3])),2);
				}
			}
			//This part tells us to go in the direction if it is better than the previous best option and is reachable.
			if(rating<bestRating&&new Rectangle2D.Double(50,50,getBattleFieldWidth()-100,getBattleFieldHeight()-100).contains(movePoint)){
				bestRating=rating;
				/*
				 * These next three lines are a very codesize-efficient way to 
				 * choose the best direction for moving to a point.
				 */
				int pointDir;
				setAhead(1000*(pointDir=(Math.abs(moveAngle-getHeadingRadians())<Math.PI/2?1:-1)));
				//anti-gravity code
				//setTurnRightRadians(robocode.util.Utils.normalRelativeAngle(moveAngle+(pointDir==-1?Math.PI:0)-getHeadingRadians()));
				
				//surfing code
				double goalDirection = e.getBearing() - 90 - (moveDirection * 10);
				setTurnRightRadians(getWallSmoothedTurn(Math.toRadians(goalDirection)));
			}
		}
	}

	public void Movement(ScannedRobotEvent e) {
		//move the waves
		moveWaves();
		Graphics g = getGraphics();
		double xValue = 0;
		double yValue = 100; // length of line
		double rotAngle = getHeadingRadians();//enter your own value(ratation angle) here later
		double rotateAngle = -(rotAngle);

		double hotXValue = xValue * Math.cos(rotateAngle) - Math.sin(rotateAngle) * (yValue);
		double hotYValue = xValue * Math.sin(rotateAngle) + Math.cos(rotateAngle) * (yValue);

		g.setColor(Color.black);
		g.drawLine((int)getX() + (int)moveDirection * (int)hotXValue,(int)getY() + (int)moveDirection * (int)hotYValue,(int)getX(),(int)getY());
		g.setColor(Color.red);
		g.drawLine((int)getX() + (int)-moveDirection * (int)hotXValue,(int)getY() + (int)-moveDirection * (int)hotYValue,(int)getX(),(int)getY());
		g.drawRect((int)getX() - (36/2),(int)getY() - (36/2),36,36);
		Line2D.Double frontMoveLine = new Line2D.Double((int)getX() + (int)hotXValue,(int)getY() + (int)hotYValue,(int)getX(),(int)getY());
		Line2D.Double backMoveLine = new Line2D.Double((int)getX() + (int)-hotXValue,(int)getY() + (int)-hotYValue,(int)getX(),(int)getY());
		double radius;
		for(int i=0;i<moveWaves.size();i++){
			MovementWave w=moveWaves.get(i);
			radius=(getTime()-w.startTime)*w.speed+w.speed;
			Point2D.Double hotBullet=project(w.origin,radius,w.angle);
			Point2D.Double hotBulletValue= bulletPredictDistanceDouble(getX(),getY(),hotBullet.x,hotBullet.y,w.angle);
			Point2D.Double latBullet=project(w.origin,radius,w.angle+w.latVel);

			Point2D.Double latBulletValue= bulletPredictDistanceDouble(getX(),getY(),latBullet.x,latBullet.y,w.latVel + w.angle);
			Line2D.Double hotLine = new Line2D.Double(retrieveX(e),retrieveY(e),hotBulletValue.x,hotBulletValue.y);
			Line2D.Double latLine = new Line2D.Double(retrieveX(e),retrieveY(e),latBulletValue.x,latBulletValue.y);

			Point2D.Double learnBullet = project(w.origin,radius,w.learning1);
			Point2D.Double learnBullet2 = project(w.origin,radius,w.angle + learningAngle[2]);
			Point2D.Double learnBullet3 = project(w.origin,radius,w.angle + learningAngle[3]);

			Point2D.Double learnBulletValue= bulletPredictDistanceDouble(getX(),getY(),learnBullet.x,learnBullet.y,w.angle);
			Point2D.Double learnBullet2Value= bulletPredictDistanceDouble(getX(),getY(),learnBullet2.x,learnBullet.y,w.angle);
			Point2D.Double learnBullet3Value= bulletPredictDistanceDouble(getX(),getY(),learnBullet3.x,learnBullet.y,w.angle);	

			Line2D.Double learnBulletLine = new Line2D.Double(retrieveX(e),retrieveY(e),learnBulletValue.x,learnBulletValue.y);
			Line2D.Double learnBullet2Line = new Line2D.Double(retrieveX(e),retrieveY(e),learnBullet2Value.x,learnBullet2Value.y);
			Line2D.Double learnBullet3Line = new Line2D.Double(retrieveX(e),retrieveY(e),learnBullet3Value.x,learnBullet3Value.y);
			
			if (w.isClose(e) == true) {
				moveDirection *= -1;
				if (e.getDistance() < 200) {
					out.println("AAHL = " + distanceFromTwoPoints(hotBullet.x,hotBullet.y,latBullet.x,latBullet.y));
					out.println("---------");
					out.println("AALNGH = " + distanceFromTwoPoints(hotBullet.x,hotBullet.y,learnBullet.x,learnBullet.y));
				}
			}
			
			if (moveDirection == 1) {
				/*
				if (frontMoveLine.intersectsLine(latLine) || frontMoveLine.intersectsLine(hotLine)) {
				 */
				if (frontMoveLine.intersectsLine(latLine) || 
						frontMoveLine.intersectsLine(hotLine) ||
						frontMoveLine.intersectsLine(learnBulletLine) ||
						frontMoveLine.intersectsLine(learnBullet2Line) ||
						frontMoveLine.intersectsLine(learnBullet3Line)) {
					/*
					out.println("intersection predicted - back");
					out.println(getVelocity());
					out.println(8 - getVelocity());
					*/
					moveDirection *= -1;
					setMaxVelocity(8);
					setAhead(100 * moveDirection);
				}
			}
			if (moveDirection == -1) {
				//if (backMoveLine.intersectsLine(latLine) || backMoveLine.intersectsLine(hotLine)) {
				if (backMoveLine.intersectsLine(latLine) || 
						backMoveLine.intersectsLine(hotLine) ||
						backMoveLine.intersectsLine(learnBulletLine) ||
						backMoveLine.intersectsLine(learnBullet2Line) ||
						backMoveLine.intersectsLine(learnBullet3Line)) {
					/*
					out.println("intersection predicted - front");
					out.println(getVelocity());
					out.println(8 - getVelocity());
					out.println(getVelocity());
					*/
					moveDirection *= -1;
					setMaxVelocity(8);
					setAhead(100 * moveDirection);
				}
			}
		}
	}
	public void moveWaves() {
		for(int i=0;i<moveWaves.size();i++){
			MovementWave w=moveWaves.get(i);
			w.move();	
		}
	}
	public void paint(ScannedRobotEvent e){
		Graphics g=getGraphics();
		double radius;


		for(int i=0;i<moveWaves.size();i++){
			MovementWave w=moveWaves.get(i);
			g.setColor(Color.blue);
			radius=(getTime()-w.startTime)*w.speed+w.speed;
			g.drawOval((int)(w.origin.x-radius),(int)(w.origin.y-radius),(int)radius*2,(int)radius*2);
			Point2D.Double hotBullet=project(w.origin,radius,w.angle);
			Point2D.Double latBullet=project(w.origin,radius,w.angle+w.latVel);
			g.setColor(Color.yellow);
			g.fillOval((int)hotBullet.x-3,(int)hotBullet.y-3,6,6);
			g.fillOval((int)latBullet.x-3,(int)latBullet.y-3,6,6);

			
			Point2D.Double learnBullet = project(w.origin,radius,w.angle + learningAngle[1]);
			Point2D.Double learnBullet2 = project(w.origin,radius,w.angle + learningAngle[2]);
			Point2D.Double learnBullet3 = project(w.origin,radius,w.angle + learningAngle[3]);

			if (learningAngle[1] != 0) {
				g.setColor(Color.black);
				g.fillOval((int)learnBullet.x - 6,(int)learnBullet.y-6,6,6);
			} 
			if (learningAngle[2] != 0) {
				g.setColor(Color.black);
				g.fillOval((int)learnBullet2.x - 6,(int)learnBullet2.y-6,6,6);
			}
			if (learningAngle[3] != 0) {
				g.setColor(Color.black);
				g.fillOval((int)learnBullet3.x - 6,(int)learnBullet3.y-6,6,6);
			}	
			 
			//remove waves
			if(new Point2D.Double(getX(),getY()).distance(w.origin)<(getTime()-w.startTime)*w.speed+w.speed){
				moveWaves.remove(w);
			}

		}
	}

	public static class MovementWave{
		Point2D.Double origin;
		//wave data
		double distanceFromOrigin;  //how fast the wave is travelling
		double startTime;
		double speed;
		double angle;
		double latVel;
		double firePlace;  //where I am when he fires
		double firePlaceX;  //my X when he fires
		double firePlaceY;  //my Y when he fires
		double enemyX;  //his X when he shot
		double enemyY;  //his Y when he shot
		double learning1;
		
		public boolean isClose(ScannedRobotEvent e) {
			if (distanceFromOrigin > e.getDistance() - 40) {
				return (true);
			} else {
				return (false);
			}
		}
	
		public void move() {
			distanceFromOrigin += speed;
		}
	}
}			