package tobe.util;

/**
 * @author Torbjrn Gannholm
 */
public class Shrapnel extends BearingVector
{
		
		private Shrapnel() {
			super();
		}
		
		public Shrapnel(double power, double headStart, BearingVector opp, double myX, double myY, double fieldHeight, double fieldWidth) {
			super();
			p = power;
			setPoints(myX,myY,opp.getToX(),opp.getToY());
			setDistance(20-3*p);
			setOrigin(getExtendedX(headStart), getExtendedY(headStart));
			h = fieldHeight;
			w = fieldWidth;
		}
		
		public Shrapnel(double power, double headStart, BearingVector shooter, BearingVector target, double fieldHeight, double fieldWidth) {
			this(power, headStart, shooter, target.getToX(), target.getToY(), fieldHeight, fieldWidth);
		}
		
		public boolean passed(double botX, double botY) {
			setOrigin(getToX(),getToY());
			boolean passedOut = (getFromX() < 0 || getFromX() > w
			|| getFromY() < 0 || getFromY() > h);
			double oldX = getToX();
			double oldY = getToY();
			pointTo(botX,botY);
			double tail = getDistance();
			pointTo(oldX,oldY);
			oldX = getFromX();
			oldY = getFromY();
			changeOrigin(botX,botY);
			double head = getDistance();
			changeOrigin(oldX,oldY);
			return passedOut || (head > tail);
		}
		
		public double getPower() { return p; }
		
		double h;
		double w;
		double p;
}
