package kawigi.spare.parts;
import robocode.*;
import kawigi.spare.util.*;
/**
 * SpiralMovement - a class describing a movement strategy similar to that of CircleBot
 */
public class SpiralMovement extends MovementStrategy implements java.io.Serializable
{
	private transient int currentDirection;
	private transient long lastHitTime;
	private double goaldistance, movedistance, sideangle;
	private transient boolean back, justhit;
	private int quickhits;
	
	public SpiralMovement(AdvancedRobot robot, TargetSelector targetter)
	{
		super(robot, targetter);
		currentDirection = 1;
		goaldistance = 150;
		movedistance = 100;
		sideangle = Math.PI/3;
		justhit = false;
		back = false;
		quickhits = 0;
	}
	
	public void onEvent(Event e)
	{
		if (e instanceof HitWallEvent)
		{
			currentDirection = -currentDirection;
			justhit = true;
		}
		else if (e instanceof HitRobotEvent)
		{
			if (((HitRobotEvent)e).isMyFault())
				currentDirection = -currentDirection;
		}
		else if (e instanceof HitByBulletEvent)
		{
			if (e.getTime() - lastHitTime < 35)
				currentDirection = -currentDirection;
			else
				quickhits = 0;
			quickhits++;
			lastHitTime = e.getTime();
		}
	}
	
	public void setAction()
	{
		EnemyState closest = getClosestEnemy();
		if (closest == null)
			return;
		double distance = closest.getDistance(robot.getX(), robot.getY());
		double absoluteangle = closest.getAbsoluteBearing(robot.getX(), robot.getY());
		if (Math.abs(distance-goaldistance) < 50)	//move orthogonal to the target robot
			turn(currentDirection*Math.PI/2 - absoluteangle+robot.getHeadingRadians());
		else if (distance > goaldistance)		//spiral slightly inward
			turn(currentDirection*sideangle - absoluteangle+robot.getHeadingRadians());
		else		//spiral slightly away
			turn(currentDirection*(Math.PI-sideangle) - absoluteangle + robot.getHeadingRadians());
		if (!justhit)
			if (back)
				robot.setBack(movedistance);
			else
				robot.setAhead(movedistance);
		back = false;
		justhit = false;
	}
	
	public void turn(double angle)
	{
		while (angle < -Math.PI)
			angle += Math.PI*2;
		while (angle > Math.PI)
			angle -= Math.PI*2;
		if (angle < -Math.PI/2)
		{
			back = true;
			angle += Math.PI;
		}
		else if (angle > Math.PI/2)
		{
			back = true;
			angle -= Math.PI;
		}
		if (angle > 0)
			robot.setTurnLeftRadians(angle);
		else
			robot.setTurnRightRadians(-angle);
	}
}
