/*
 * Created on 11/11/2003
 *
 * To change the template for this generated file go to
 * Window>Preferences>Java>Code Generation>Code and Comments
 */
package axeBots.gunner;

import java.awt.geom.*;

//import java.text.DecimalFormat;
import java.util.*;

import axeBots.data.*;

import axeBots.AxeBot;
import axeBots.AxeException;
import axeBots.SilverSurfer;
import axeBots.silversurfer.AxeTarget;
import axeBots.silversurfer.AxeVector;
import axeBots.util.RoboMath;
//import java.awt.geom.*;

/**
 * @author Marcos
 * 
 * To change the template for this generated type comment go to
 * Window>Preferences>Java>Code Generation>Code and Comments
 */
public class VectorPMGun extends AxeGunner {

	private double lastRate;
	/**
	 * @param target
	 * @param me
	 * @param id
	 */
	private Point2D.Double targetPos = null;
	private Point2D.Double myPos = null;
	// private double diffHeads;
	private double head;
	private double maxDim;
	private double bvel;
	private Rectangle2D.Double field = null;
	private final static boolean HOT = false;

	//public static final int MAX_SAMPLES= 30000;

	//private BotData botData= null;
	//private ArrayList interpol= null;

	private AxeVector walkVec = new AxeVector(); //.clone();
	private AxeVector targetVec = new AxeVector(); //.clone();

	
	private static PMShootingData pmData= null;
	private double refAng;

	public VectorPMGun(AxeTarget target, AxeBot me, int id) {
		super(target, me, id);
		double h = getMe().getBattleFieldHeight();
		double w = getMe().getBattleFieldWidth();
		maxDim = Math.sqrt(h * h + w * w);
		 
	}

	protected Point2D.Double guess() {

pmData = null;
		//double diffHeads = 0;

		myPos = super.getMe().getFuturePos().getEndPoint();//pos();
		targetPos = super.getTarget().pos();
		//targetDistance = myPos.distance(targetPos);

		if (HOT || super.getTarget().getDistance() < 60) {
			return targetPos;
		}

		//botRecs= super.getTarget().getInterpolated();
		ArrayList interpols = getBotData().getInterpolated();
		ArrayList interpol = (ArrayList) interpols.get(interpols.size() - 1);

		field = AxeBot.getIt().getField();
		field = new Rectangle2D.Double(field.x + 18, field.y + 18,
				field.width - 36, field.height - 36);

		bvel = RoboMath.getBulletVelocity(super.getFirePower());

		int lim = (int) Math.ceil(maxDim / bvel);

		int time = (int) getMe().getTime();
		int tsa = time - (int) getTarget().getLastAccTime();
		int tsd = time - (int) getTarget().getLastDeaccTime();
		int tsf = time - (int) getMe().getLastFireTime();

		PatternSample now = null;
		try {
			now = new PatternSample(interpol, time, myPos.distance(targetPos),
					getTarget().getAttackAngle() /* getHeadToMe() */, tsa,
					tsd, tsf, getTarget().getMyAttackAngle());
		} catch (AxeException e) {
			e.printStackTrace();
		}
		//(PatternSample)samplesList.get(samplesList.size() - 1);

		PatternSample.setOrderParams(now, getMe().getRoundNum(), (int) getMe()
				.getTime()
				- lim);

		head = now.getOriginalAngle();

		

		Point2D.Double ret = newFindBestMatch();
		return ret;
	}

	private Point2D.Double intercept(PatternSample smp) {

		if (smp == null) {
			return null;
		}

		Point2D.Double ret = null;

		double bulDS, targetDS;
		double bulToTargetS;
		double diffHeads = RoboMath.normalRelativeAngle(head
				- smp.getOriginalAngle());
		int c = smp.getPos();

		ArrayList interpols = getBotData().getInterpolated();
		ArrayList interpol = (ArrayList) interpols.get(smp.getRound());

		targetVec.set(new Point2D.Double(0, 0), targetPos);
		walkVec.set(new Point2D.Double(0, 0), ((AxeVector) interpol.get(c))
				.getEndPoint());

		//1 passo
		if (!this.walk(((AxeVector) interpol.get(++c)).getEndPoint(),
				diffHeads, walkVec, targetVec)) {
			return null;
		}

		bulToTargetS = 1;
		int times = 0;
		while ((bulToTargetS > 0) && (c < (interpol.size() - 2))) {
			if (!this.walk(((AxeVector) interpol.get(++c)).getEndPoint(),
					diffHeads, walkVec, targetVec)) {
				return null;
			}

			bulDS = bvel * (++times);

			targetDS = myPos.distance(targetVec.getEndPoint());

			bulToTargetS = targetDS - bulDS;
		}

		ret = targetVec.getEndPoint();
		return ret;

	}

	protected boolean walk(Point2D.Double to, double diffHeads,
			AxeVector walkVec, AxeVector targetVec) {
		walkVec.set(walkVec.getEndPoint(), to);
		double ang = walkVec.getTheta() + diffHeads;
		targetVec.set(targetVec.getEndPoint(), ang, walkVec.getModule());
		return field.contains(targetVec.getEndPoint());
	}

	protected Point2D.Double newFindBestMatch() {
		
		ArrayList universes = getBotData().getSamplesList();

		int rnds = universes.size();
		int maxWid = PatternSample.getMaxWideness();

		int bestsQtd = (int) Math
				.ceil(this.getBotData().getSamplesSize() * 0.1); //100;//50;
		bestsQtd = (bestsQtd > 100) ? 100 : bestsQtd;
		if (bestsQtd == 0) {
			return null;
		}
		Bests bests = new Bests(bestsQtd);
		//        int age= getBotData().getSamplesSize();
		for (int i = 0; i < rnds; i++) {

			ArrayList universe = (ArrayList) universes.get(i);
			for (int j = 0; ((j < universe.size()) && ((universe.size() - j) > maxWid)); j++) {

				PatternSample s = (PatternSample) universe.get(j);
				s.setRound(i);
				//                s.setAge(age--);
				bests.add(s);
			}
		}

		PatternSample ps[] = bests.getArray();
		//		ps = PatternSample.orderByRate(ps);
		bestsQtd = ps.length;

		Point2D.Double points[] = new Point2D.Double[bestsQtd];
		double angs[] = new double[bestsQtd];
		//        double min= 400;
		//        double max= -400;

		refAng = RoboMath.getNRDegrees(myPos, ((SilverSurfer) getMe())
				.getMyTarget().pos());

		for (int i = 0; i < bestsQtd; i++) {
//						if (ps[i] != null) {
//							System.out.println("samp:" + i + " date:" + ps[i].getDate()
//									+ " rate:" + ps[i].getItsRate());
//						}
			points[i] = this.intercept(ps[i]);
			angs[i] = (points[i] == null) ? Double.NaN : RoboMath
					.normalRelativeAngle(RoboMath
							.getNRDegrees(myPos, points[i])
							- refAng);

		}

pmData=new PMShootingData();
		int bestInd =pmData.rateAngs(ps, angs,refAng , ((SilverSurfer) getMe()).getMyTarget()
				.getDistance(), 20);
		
//		if(points[bestInd]!=null){
//		System.out.println("shhoting:" + RoboMath.getNRDegrees(myPos,points[bestInd]));
////		System.out.println(" using future pt:" + RoboMath.getNRDegrees(getMe().getFuturePos().getEndPoint(),points[bestInd]));
////		System.out.println(" future pt:" + getMe().getFuturePos());
//		  
//		}
//				+ " rate:" + ps[i].getItsRate());
//		int bestInd = rateAngs(ps, angs, ((SilverSurfer) getMe()).getMyTarget()
//				.getDistance(), 20);

		return points[bestInd];
	}

	public boolean ready() {
		//getMe().out.println("not ready..");
		return getBotData().getSamplesListSize() > 0;
		//getMe().getTime() > PatternSample.getMaxWideness();
	}

	/**
	 * @return
	 */
	public double getLastRate() {
		return lastRate;
	}

	public static PMShootingData popPmData() {
		//zera pmData! so pode pegar uma vez!
		PMShootingData ret = pmData;
		pmData = null;
		return ret;
	}
}