/*
 * Decompiled with CFR 0.152.
 */
package tcf;

import robocode.Robot;
import tcf.Vec2d;

class Utils {
    Utils() {
    }

    public static double heading(double dx, double dy) {
        return Math.toDegrees(Math.atan2(dx, dy));
    }

    public static double normAngle180(double angle) {
        while (angle < -180.0) {
            angle += 360.0;
        }
        while (angle > 180.0) {
            angle -= 360.0;
        }
        return angle;
    }

    public static double distToEdge(Robot r, double x, double y) {
        double edge = Math.min(Math.min(x, r.getBattleFieldWidth() - x), Math.min(y, r.getBattleFieldHeight() - y));
        return edge;
    }

    public static Vec2d project(Vec2d p, double angle, double distance) {
        angle = Math.toRadians(angle);
        double x = p.x + distance * Math.sin(angle);
        double y = p.y + distance * Math.cos(angle);
        return new Vec2d(x, y);
    }

    public static int rand(int limit) {
        return (int)Math.floor(Math.random() * (double)limit);
    }
}

