/*
 * Decompiled with CFR 0.152.
 */
package Polkwane;

import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Enumeration;
import java.util.Hashtable;
import robocode.AdvancedRobot;
import robocode.HitRobotEvent;
import robocode.RobotDeathEvent;
import robocode.ScannedRobotEvent;
import robocode.util.Utils;

public class SmashMelee
extends AdvancedRobot {
    static Hashtable enemies = new Hashtable();
    static Enemy target;
    static Point2D.Double nextDestination;
    static Point2D.Double lastPosition;
    static Rectangle2D.Double field;
    static double myEnergy;
    static double myX;
    static double myY;
    static double timeSinceLastScan;

    static {
        timeSinceLastScan = 0.0;
    }

    public void run() {
        field = new Rectangle2D.Double(36.0, 36.0, this.getBattleFieldWidth() - 72.0, this.getBattleFieldHeight() - 72.0);
        nextDestination = lastPosition = new Point2D.Double(this.getX(), this.getY());
        target = new Enemy();
        this.setAdjustGunForRobotTurn(true);
        this.setAdjustRadarForGunTurn(true);
        while (true) {
            this.doMovement();
            this.doGunning();
            this.doRadar();
            myEnergy = this.getEnergy();
            myX = this.getX();
            myY = this.getY();
            timeSinceLastScan += 1.0;
            this.execute();
        }
    }

    public void onScannedRobot(ScannedRobotEvent e) {
        Enemy en = (Enemy)enemies.get(e.getName());
        if (en == null) {
            en = new Enemy();
            enemies.put(e.getName(), en);
        }
        en.energy = e.getEnergy();
        en.live = true;
        double x = myX + Math.sin(e.getBearingRadians() + this.getHeadingRadians()) * e.getDistance();
        double y = myY + Math.cos(e.getBearingRadians() + this.getHeadingRadians()) * e.getDistance();
        en.location = new Point2D.Double(x, y);
        en.distance = e.getDistance();
        en.velocity = e.getVelocity();
        en.heading = e.getHeadingRadians();
        en.bearing = e.getBearingRadians();
        en.name = e.getName();
        if (!SmashMelee.target.live || en.distance < SmashMelee.target.distance * 0.8 && en.energy <= SmashMelee.target.energy * 1.1 || en.energy < SmashMelee.target.energy * 0.8 && en.distance <= SmashMelee.target.distance * 1.15) {
            target = en;
        }
        if (SmashMelee.target.name.equals(e.getName())) {
            timeSinceLastScan = 0.0;
        }
    }

    public void onRobotDeath(RobotDeathEvent e) {
        Enemy en = (Enemy)enemies.get(e.getName());
        if (en != null) {
            en.live = false;
        }
    }

    public void onHitRobot(HitRobotEvent e) {
        Enemy en = (Enemy)enemies.get(e.getName());
        if (en == null) {
            en = new Enemy();
            enemies.put(e.getName(), en);
        }
        en.energy = e.getEnergy();
        en.live = true;
        en.bearing = e.getBearingRadians();
        en.name = e.getName();
        target = en;
        this.setTurnGunRightRadians(en.bearing + this.getHeadingRadians() - this.getGunHeadingRadians());
        this.setFire(3.0);
    }

    void doMovement() {
        int i = 0;
        while (i < 250) {
            if (target != null) {
                double testY;
                double ang = Math.PI * 2 * Math.random();
                double dist = 150.0 + 250.0 * Math.random();
                double testX = myX + Math.sin(ang) * dist;
                if (field.contains(testX, testY = myY + Math.cos(ang) * dist)) {
                    Point2D.Double double_ = new Point2D.Double(testX, testY);
                    if (this.evaluate(double_) < this.evaluate(nextDestination)) {
                        nextDestination.setLocation(testX, testY);
                    }
                }
            }
            ++i;
        }
        double ang = this.calcAngle(new Point2D.Double(myX, myY), nextDestination) - this.getHeadingRadians();
        double dist = nextDestination.distance(myX, myY);
        this.setTurnRightRadians(Utils.normalRelativeAngle((double)ang));
        this.setAhead(dist);
        this.setMaxVelocity(Math.abs(Utils.normalRelativeAngle((double)ang)) > 1.0 ? 2.25 : 8.0);
    }

    void doGunning() {
        if (this.getGunTurnRemainingRadians() < 0.01) {
            this.setTurnGunRightRadians(Utils.normalRelativeAngle((double)(SmashMelee.target.bearing + this.getHeadingRadians() - this.getGunHeadingRadians())));
        }
        if (this.getGunHeat() == 0.0 && this.getEnergy() > 5.0) {
            double firePower = Math.min(Math.min(myEnergy / 10.0, 1300.0 / SmashMelee.target.distance), SmashMelee.target.energy / 4.0);
            this.setFire(firePower);
        }
    }

    void doRadar() {
        if (timeSinceLastScan < 10.0 && this.getOthers() == 1) {
            this.setTurnRadarRightRadians(Utils.normalRelativeAngle((double)(SmashMelee.target.bearing + this.getHeadingRadians() - this.getRadarHeadingRadians())) * 2.0);
        } else {
            this.setTurnRadarRightRadians(Double.POSITIVE_INFINITY);
        }
    }

    double evaluate(Point2D.Double destination) {
        double risk = 0.0;
        Enumeration e = enemies.elements();
        while (e.hasMoreElements()) {
            Enemy en = (Enemy)e.nextElement();
            if (!en.live) continue;
            double eratio = Math.min(en.energy * 2.0 / myEnergy, 2.5);
            double perp = Math.abs(Math.cos(this.calcAngle(destination, new Point2D.Double(myX, myY)) - this.calcAngle(destination, en.location)));
            risk += eratio * (1.0 + perp) / destination.distance(en.location);
        }
        return risk;
    }

    double calcAngle(Point2D.Double s, Point2D.Double t) {
        return Math.atan2(t.getX() - s.getX(), t.getY() - s.getY());
    }

    class Enemy {
        boolean live;
        Point2D.Double location;
        double energy;
        double distance;
        double velocity;
        double heading;
        double bearing;
        String name;

        Enemy() {
        }
    }
}

