/*
 * Decompiled with CFR 0.152.
 */
package xander.gfws.data;

import edu.wlu.cs.levy.CG.KDTree;
import edu.wlu.cs.levy.CG.KeyDuplicateException;
import edu.wlu.cs.levy.CG.KeySizeException;
import edu.wlu.cs.levy.CG.SearchResult;
import java.util.Arrays;
import java.util.List;
import xander.core.log.Log;
import xander.core.log.Logger;
import xander.core.track.Wave;
import xander.gfws.data.AbstractWaveLogger;
import xander.gfws.data.DataPoint;
import xander.gfws.data.KNNParms;
import xander.gfws.segment.Segmenter;

public class KDTreeWaveLogger
extends AbstractWaveLogger<KNNParms> {
    private static final Log log = Logger.getLog(KDTreeWaveLogger.class);
    private KDTree<DataPoint> hitTree;
    private KDTree<DataPoint> visitTree;
    private double[] lowRange;
    private double[] highRange;
    private int maxHits = Integer.MAX_VALUE;
    private int maxVisits = Integer.MAX_VALUE;
    private double[] segmentWeights;

    public KDTreeWaveLogger(boolean offensive, Segmenter ... segmenters) {
        super(offensive, segmenters);
        this.hitTree = new KDTree(segmenters.length);
        this.visitTree = new KDTree(segmenters.length);
        this.lowRange = new double[segmenters.length];
        this.highRange = new double[segmenters.length];
        this.segmentWeights = new double[segmenters.length];
        Arrays.fill(this.segmentWeights, 1.0);
    }

    public void setSegmentWeight(int segmentIndex, double weight) {
        this.segmentWeights[segmentIndex] = weight;
    }

    public int getMaxHits() {
        return this.maxHits;
    }

    public void setMaxHits(int maxHits) {
        this.maxHits = maxHits;
    }

    public int getMaxVisits() {
        return this.maxVisits;
    }

    public void setMaxVisits(int maxVisits) {
        this.maxVisits = maxVisits;
    }

    public void setMaxSize(int maxSize) {
        this.setMaxHits(maxSize);
        this.setMaxVisits(maxSize);
    }

    private double[] createKey(Wave wave, Segmenter[] segmenters) {
        double[] key = new double[segmenters.length];
        int i = 0;
        while (i < segmenters.length) {
            key[i] = segmenters[i].getSegmentValuePercent(wave) * this.segmentWeights[i];
            ++i;
        }
        return key;
    }

    private void setRanges(double[] key, double[] rangeSpan) {
        int i = 0;
        while (i < rangeSpan.length) {
            double halfSpan = rangeSpan[i] / 2.0;
            this.lowRange[i] = key[i] - halfSpan;
            this.highRange[i] = key[i] + halfSpan;
            ++i;
        }
    }

    @Override
    public SearchResult<DataPoint> getHitData(Wave wave, Segmenter[] segmenters, KNNParms parms) {
        double[] key = this.createKey(wave, segmenters);
        SearchResult<DataPoint> searchResult = null;
        try {
            if (parms.isSelectByKNN()) {
                int n = Math.min(this.hitTree.size(), parms.getK(this.totalHits));
                if (n > 0) {
                    searchResult = this.hitTree.nearest(key, n);
                }
            } else if (parms.isSelectByHitsWithinKNNVisits()) {
                if (this.hitTree.size() > 0) {
                    List<DataPoint> hitData = this.hitTree.nearestEuclidean(key, parms.visitDistance);
                    log.debug(String.valueOf(hitData.size()) + " hits pulled.");
                    searchResult = new SearchResult<DataPoint>(hitData, parms.visitDistance);
                }
            } else {
                this.setRanges(key, parms.getRangeSpan());
                List<DataPoint> hitData = this.hitTree.range(this.lowRange, this.highRange);
                log.debug(String.valueOf(hitData.size()) + " hits pulled.");
                searchResult = new SearchResult<DataPoint>(hitData, -1.0);
            }
            if ((searchResult == null || searchResult.getResultList().size() == 0) && this.hitTree.size() > 0 && parms.getKnnWhenSelectionEmpty() > 0) {
                searchResult = this.hitTree.nearest(key, parms.getKnnWhenSelectionEmpty());
            }
        }
        catch (KeySizeException e) {
            log.error("Key size error on getData: " + e.getMessage());
        }
        return searchResult == null ? new SearchResult() : searchResult;
    }

    @Override
    protected SearchResult<DataPoint> getVisitData(Wave wave, Segmenter[] segmenters, KNNParms parms) {
        double[] key = this.createKey(wave, segmenters);
        SearchResult<Object> searchResult = null;
        try {
            if (parms.isSelectByKNN()) {
                int n = Math.min(this.visitTree.size(), parms.getVisitKAsPercentOfHitK(this.totalHits));
                if (n > 0) {
                    searchResult = this.visitTree.nearest(key, n);
                }
            } else if (parms.isSelectByHitsWithinKNNVisits()) {
                int n = Math.min(this.visitTree.size(), parms.getK(this.totalVisits));
                if (n > 0) {
                    searchResult = this.visitTree.nearest(key, n);
                    log.debug(String.valueOf(searchResult.getResultList().size()) + " visits pulled.");
                }
            } else {
                this.setRanges(key, parms.getRangeSpan());
                List<DataPoint> visitData = this.hitTree.range(this.lowRange, this.highRange);
                searchResult = new SearchResult<DataPoint>(visitData, -1.0);
            }
            if ((searchResult == null || searchResult.getResultList().size() == 0) && this.visitTree.size() > 0 && parms.getKnnWhenSelectionEmpty() > 0) {
                searchResult = this.visitTree.nearest(key, parms.getKnnWhenSelectionEmpty());
            }
        }
        catch (KeySizeException e) {
            log.error("Key size error on getData: " + e.getMessage());
        }
        return searchResult == null ? new SearchResult() : searchResult;
    }

    @Override
    protected void addHit(Wave bulletWave, Segmenter[] segmenters, DataPoint dataPoint) {
        if (this.hitTree.size() < this.maxHits) {
            double[] key = this.createKey(bulletWave, segmenters);
            try {
                this.hitTree.insert(key, dataPoint);
            }
            catch (KeySizeException e) {
                log.error("Hit key size incorrect: " + e.getMessage());
            }
            catch (KeyDuplicateException e) {
                log.error("Hit duplicate key! point will be ignored: " + e.getMessage());
            }
        }
    }

    @Override
    protected void addVisit(Wave bulletWave, Segmenter[] segmenters, DataPoint dataPoint) {
        if (this.visitTree.size() < this.maxVisits) {
            double[] key = this.createKey(bulletWave, segmenters);
            try {
                this.visitTree.insert(key, dataPoint);
            }
            catch (KeySizeException e) {
                log.error("Visit key size incorrect: " + e.getMessage());
            }
            catch (KeyDuplicateException e) {
                log.error("Visit duplicate key! point will be ignored: " + e.getMessage());
            }
        }
    }
}

