/*
 * Decompiled with CFR 0.152.
 */
package rampancy.util.wave;

import java.awt.Color;
import java.awt.geom.Point2D;
import rampancy.util.REnemyRobot;
import rampancy.util.RPoint;
import rampancy.util.RRobotState;
import rampancy.util.RUtil;
import rampancy.util.wave.RWave;
import rampancy_old.util.Util;
import robocode.util.Utils;

public class REnemyWave
extends RWave {
    public static final Color DEFAULT_COLOR = Color.red;
    protected REnemyRobot creator;
    protected RRobotState creatorState;
    protected RRobotState targetState;
    protected double directionAngle;
    protected int direction;
    protected long estimatedFlightTime;

    public REnemyWave(REnemyRobot creator) {
        this(creator, creator.getCurrentState().location.getCopy(), creator.getReference().getTime(), creator.getShotPower() > 0.0 ? creator.getShotPower() : 3.0);
    }

    public REnemyWave(REnemyRobot creator, RPoint origin, long timeFired, double power) {
        super(origin, timeFired - 1L, power, DEFAULT_COLOR);
        this.creator = creator;
        this.creatorState = creator.getCurrentState().getCopy();
        this.targetState = creator.getReference().getLastUsableState();
        this.directionAngle = creator.getLastUsableBearing();
        this.direction = creator.getLastUsableSurfDirection();
        this.estimatedFlightTime = (long)(this.creatorState.distance / this.velocity);
    }

    public boolean didBreak(RPoint point) {
        return this.distanceTraveled > point.distance(this.origin) + 50.0;
    }

    public boolean intercepted(RPoint point, int time) {
        return point.distance(this.getOrigin()) < this.getDistanceTraveled() + (double)time * this.getVelocity() + this.getVelocity();
    }

    public double computeOffsetAngle(Point2D.Double target) {
        return Util.computeAbsoluteBearing(this.getOrigin(), target) - this.getDirectionAngle();
    }

    public double computeRawFactor(RPoint hitLocation) {
        double offset = this.computeOffsetAngle(hitLocation);
        return Utils.normalRelativeAngle((double)offset) / RUtil.computeMaxEscapeAngle(this.getVelocity()) * (double)this.getDirection();
    }

    public double getDirectionAngle() {
        return this.directionAngle;
    }

    public int getDirection() {
        return this.direction;
    }

    public double getEstimatedFlightTime() {
        return this.estimatedFlightTime;
    }

    public REnemyRobot getCreator() {
        return this.creator;
    }

    public RRobotState getCreatorState() {
        return this.creatorState;
    }

    public RRobotState getTargetState() {
        return this.targetState;
    }
}

