/*
 * Decompiled with CFR 0.152.
 */
package shrub;

import shrub.Bearing;
import shrub.Location;
import shrub.QuadrantAdjust;

public class Heading {
    private double mHeading = 0.0;

    public void Initialise() {
        this.mHeading = 0.0;
    }

    public void Set(double newValue) {
        this.mHeading = newValue;
        this.Normalise();
    }

    public void Set(Heading newValue) {
        this.mHeading = newValue.Get();
        this.Normalise();
    }

    public void Adjust(double delta) {
        this.mHeading += delta;
        this.Normalise();
    }

    public void Adjust(Bearing delta) {
        this.mHeading += delta.Get();
        this.Normalise();
    }

    public void Flip() {
        this.mHeading += 180.0;
        this.Normalise();
    }

    public double Get() {
        return this.mHeading;
    }

    public boolean IsNormalised() {
        boolean answer = false;
        if (this.mHeading >= 0.0 && this.mHeading < 360.0) {
            answer = true;
        }
        return answer;
    }

    public void Normalise() {
        boolean done = false;
        while (!done) {
            if (this.mHeading >= 360.0) {
                this.mHeading -= 360.0;
                continue;
            }
            if (this.mHeading < 0.0) {
                this.mHeading += 360.0;
                continue;
            }
            done = true;
        }
    }

    public void SetFromTo(Location fromLocn, Location toLocn) {
        double radAngle = 0.0;
        double degAngle = 0.0;
        double deltaX = 0.0;
        double deltaY = 0.0;
        double absDeltaX = 0.0;
        double absDeltaY = 0.0;
        double answer = 0.0;
        deltaX = toLocn.GetX() - fromLocn.GetX();
        deltaY = toLocn.GetY() - fromLocn.GetY();
        absDeltaX = Math.abs(deltaX);
        absDeltaY = Math.abs(deltaY);
        if (absDeltaX <= 0.5 && absDeltaY <= 0.5) {
            answer = 0.0;
        } else if (absDeltaX <= 0.5 && deltaY <= -0.5) {
            answer = 180.0;
        } else if (absDeltaX <= 0.5 && deltaY >= 0.5) {
            answer = 0.0;
        } else if (absDeltaY <= 0.5 && deltaX <= -0.5) {
            answer = 270.0;
        } else if (absDeltaY <= 0.5 && deltaX >= 0.5) {
            answer = 90.0;
        } else {
            radAngle = Math.atan(absDeltaX / absDeltaY);
            degAngle = Math.toDegrees(radAngle);
            if (deltaX >= 0.5 && deltaY >= 0.5) {
                answer = degAngle;
            } else if (deltaX >= 0.5 && deltaY <= -0.5) {
                answer = 180.0 - degAngle;
            } else if (deltaX <= -0.5 && deltaY <= -0.5) {
                answer = 180.0 + degAngle;
            } else if (deltaX <= -0.5 && deltaY >= 0.5) {
                answer = 360.0 - degAngle;
            }
        }
        this.mHeading = answer;
        this.Normalise();
    }

    public double InlineComponent(Heading objHdng, double objValue) {
        double answer = 0.0;
        Bearing objRelBrng = new Bearing();
        objRelBrng.SetFromTo(this, objHdng);
        QuadrantAdjust qAdj = new QuadrantAdjust(objRelBrng.Get());
        double adjThetaDegY = qAdj.GetAdjThetaDegY();
        int adjSenseY = qAdj.GetAdjSenseY();
        double adjThetaRadY = Math.toRadians(adjThetaDegY);
        answer = (double)adjSenseY * Math.cos(adjThetaRadY) * objValue;
        return answer;
    }

    public double CrossComponent(Heading objHdng, double objValue) {
        double answer = 0.0;
        Bearing objRelBrng = new Bearing();
        objRelBrng.SetFromTo(this, objHdng);
        QuadrantAdjust qAdj = new QuadrantAdjust(objRelBrng.Get());
        double adjThetaDegY = qAdj.GetAdjThetaDegY();
        int adjSenseX = qAdj.GetAdjSenseX();
        double adjThetaRadY = Math.toRadians(adjThetaDegY);
        answer = (double)adjSenseX * Math.sin(adjThetaRadY) * objValue;
        return answer;
    }

    public Heading() {
        this.Initialise();
    }
}

