/*
 * Decompiled with CFR 0.152.
 */
package coop;

import coop.MsgColor;
import coop.MsgCoop;
import coop.MsgScan;
import coop.MsgSelf;
import java.awt.Color;
import java.io.IOException;
import java.util.Vector;
import robocode.Bullet;
import robocode.BulletHitBulletEvent;
import robocode.BulletHitEvent;
import robocode.BulletMissedEvent;
import robocode.Condition;
import robocode.CustomEvent;
import robocode.DeathEvent;
import robocode.Droid;
import robocode.Event;
import robocode.HitByBulletEvent;
import robocode.HitRobotEvent;
import robocode.HitWallEvent;
import robocode.MessageEvent;
import robocode.RobotDeathEvent;
import robocode.ScannedRobotEvent;
import robocode.SkippedTurnEvent;
import robocode.TeamRobot;
import robocode.WinEvent;

public class CoopRobot
extends TeamRobot {
    private boolean isInit;
    private boolean isTeam;
    private boolean colorsSet;
    private boolean endRound;
    private boolean allowTeamScans;
    private Color robotColor;
    private Color gunColor;
    private Color radarColor;
    private String target;
    private double destinationX;
    private double destinationY;
    private Vector events;
    private Vector fakes;
    private String[] teammates;
    private boolean[] teammateAlive;
    private double[] teammateX;
    private double[] teammateY;
    private double[] teammateHeading;
    private double[] teammateGunHeading;
    private double[] teammateRadarHeading;
    private double[] teammateVelocity;
    private double[] teammateEnergy;
    private double[] teammateGunHeat;
    private String[] teammateTarget;
    private double[] teammateDestinationX;
    private double[] teammateDestinationY;

    private void init() {
        if (this.isInit) {
            return;
        }
        this.isInit = true;
        super.addCustomEvent(new Condition("CoopRobot", 99){

            public boolean test() {
                CoopRobot.this.events();
                return false;
            }
        });
        this.fakes = new Vector();
        this.teammates = this.getTeammates();
        if (this.teammates != null) {
            this.isTeam = true;
            this.teammateAlive = new boolean[this.teammates.length];
            this.teammateX = new double[this.teammates.length];
            this.teammateY = new double[this.teammates.length];
            this.teammateHeading = new double[this.teammates.length];
            this.teammateGunHeading = new double[this.teammates.length];
            this.teammateRadarHeading = new double[this.teammates.length];
            this.teammateVelocity = new double[this.teammates.length];
            this.teammateEnergy = new double[this.teammates.length];
            this.teammateGunHeat = new double[this.teammates.length];
            this.teammateTarget = new String[this.teammates.length];
            this.teammateDestinationX = new double[this.teammates.length];
            this.teammateDestinationY = new double[this.teammates.length];
            this.clearTeammateData();
            if (this.getEnergy() >= 200.0) {
                this.radarColor = this.gunColor = new Color((int)((Math.sin(Math.random() * Math.PI * 2.0) / 2.0 + 0.5) * 256.0 - 1.0), (int)((Math.sin(Math.random() * Math.PI * 2.0) / 2.0 + 0.5) * 256.0 - 1.0), (int)((Math.sin(Math.random() * Math.PI * 2.0) / 2.0 + 0.5) * 256.0 - 1.0));
                this.colorsSet = true;
                MsgColor msgColor = new MsgColor(this.gunColor);
                try {
                    this.broadcastMessage(msgColor);
                }
                catch (IOException e) {
                    this.printError("Unable to broadcast team color!");
                }
            }
            if (this instanceof Droid) {
                this.setAllowTeamScans(true);
            }
        }
    }

    private void events() {
        if (!this.isInit) {
            return;
        }
        if (this.events != null) {
            this.events.clear();
        }
        this.events = super.getAllEvents();
        this.fakes.clear();
        super.clearAllEvents();
        for (int i = 0; i < this.events.size(); ++i) {
            int index;
            Event event = (Event)this.events.get(i);
            if (event instanceof MessageEvent) {
                if (!(((MessageEvent)event).getMessage() instanceof MsgCoop)) continue;
                this.handleMessage((MessageEvent)event);
                this.events.remove(i--);
                continue;
            }
            if (event instanceof ScannedRobotEvent && this.isTeam) {
                if (this.isTeammate(((ScannedRobotEvent)this.events.get(i)).getName())) {
                    this.events.remove(i--);
                    continue;
                }
                this.sendScan((ScannedRobotEvent)event);
                continue;
            }
            if (event instanceof DeathEvent || event instanceof WinEvent) {
                this.endRound = true;
                continue;
            }
            if (!(event instanceof RobotDeathEvent) || !this.isTeam || (index = this.getNameIndex(((RobotDeathEvent)event).getName())) <= 0) continue;
            this.killTeammate(index);
            this.events.remove(i--);
        }
        this.events.addAll(this.fakes);
    }

    private void dump() {
        if (this.events == null) {
            return;
        }
        for (int i = 0; i < this.events.size(); ++i) {
            if (this.events.get(i) instanceof ScannedRobotEvent) {
                this.onScannedRobot((ScannedRobotEvent)this.events.get(i));
                continue;
            }
            if (this.events.get(i) instanceof RobotDeathEvent) {
                this.onRobotDeath((RobotDeathEvent)this.events.get(i));
                continue;
            }
            if (this.events.get(i) instanceof HitRobotEvent) {
                this.onHitRobot((HitRobotEvent)this.events.get(i));
                continue;
            }
            if (this.events.get(i) instanceof HitWallEvent) {
                this.onHitWall((HitWallEvent)this.events.get(i));
                continue;
            }
            if (this.events.get(i) instanceof HitByBulletEvent) {
                this.onHitByBullet((HitByBulletEvent)this.events.get(i));
                continue;
            }
            if (this.events.get(i) instanceof BulletHitEvent) {
                this.onBulletHit((BulletHitEvent)this.events.get(i));
                continue;
            }
            if (this.events.get(i) instanceof BulletMissedEvent) {
                this.onBulletMissed((BulletMissedEvent)this.events.get(i));
                continue;
            }
            if (this.events.get(i) instanceof BulletHitBulletEvent) {
                this.onBulletHitBullet((BulletHitBulletEvent)this.events.get(i));
                continue;
            }
            if (this.events.get(i) instanceof CustomEvent) {
                this.onCustomEvent((CustomEvent)this.events.get(i));
                continue;
            }
            if (this.events.get(i) instanceof SkippedTurnEvent) {
                this.onSkippedTurn((SkippedTurnEvent)this.events.get(i));
                continue;
            }
            if (this.events.get(i) instanceof WinEvent) {
                this.onWin((WinEvent)this.events.get(i));
                continue;
            }
            if (this.events.get(i) instanceof DeathEvent) {
                this.onDeath((DeathEvent)this.events.get(i));
                continue;
            }
            this.printError("Unknown Event!! This event is unhandled by CoopRobot: " + ((Object)((Object)this)).getClass().getName());
        }
        this.events = null;
    }

    private void handleMessage(MessageEvent e) {
        MsgCoop msg = (MsgCoop)((Object)e.getMessage());
        if (msg instanceof MsgColor) {
            MsgColor msgColor = (MsgColor)msg;
            this.colorsSet = true;
            this.radarColor = this.gunColor = msgColor.getColor();
        } else if (msg instanceof MsgScan) {
            int i;
            if (!this.allowTeamScans) {
                return;
            }
            MsgScan msgScan = (MsgScan)msg;
            for (i = 0; i < this.events.size(); ++i) {
                if (!(this.events.get(i) instanceof ScannedRobotEvent) || !msgScan.getName().equals(((ScannedRobotEvent)this.events.get(i)).getName())) continue;
                return;
            }
            for (i = 0; i < this.fakes.size(); ++i) {
                if (!(this.fakes.get(i) instanceof ScannedRobotEvent) || !msgScan.getName().equals(((ScannedRobotEvent)this.fakes.get(i)).getName())) continue;
                return;
            }
            double dx = msgScan.getX() - this.getX();
            double dy = msgScan.getY() - this.getY();
            this.fakes.add(new ScannedRobotEvent(msgScan.getName(), msgScan.getEnergy(), CoopRobot.normalizeBearingCoop(Math.atan2(dx, dy) - this.getHeadingRadians()), Math.sqrt(Math.pow(msgScan.getX() - this.getX(), 2.0) + Math.pow(msgScan.getY() - this.getY(), 2.0)), CoopRobot.normalizeBearingCoop(Math.toRadians(msgScan.getHeading())), msgScan.getVelocity()));
        } else if (msg instanceof MsgSelf) {
            MsgSelf msgSelf = (MsgSelf)msg;
            int i = this.getNameIndex(e.getSender());
            if (i < 0) {
                this.printError("Message from unknown source!");
                return;
            }
            if (!this.teammateAlive[i]) {
                return;
            }
            this.teammateX[i] = msgSelf.getX();
            this.teammateY[i] = msgSelf.getY();
            this.teammateHeading[i] = msgSelf.getHeading();
            this.teammateGunHeading[i] = msgSelf.getGunHeading();
            this.teammateRadarHeading[i] = msgSelf.getRadarHeading();
            this.teammateVelocity[i] = msgSelf.getVelocity();
            this.teammateEnergy[i] = msgSelf.getEnergy();
            this.teammateGunHeat[i] = msgSelf.getGunHeat();
            this.teammateTarget[i] = null;
            this.teammateDestinationX[i] = msgSelf.getDestinationX();
            this.teammateDestinationY[i] = msgSelf.getDestinationY();
        }
    }

    private int getNameIndex(String name) {
        int index = -1;
        for (int i = 0; i < this.teammates.length; ++i) {
            if (!name.equals(this.teammates[i])) continue;
            index = i;
        }
        return index;
    }

    private void clearTeammateData() {
        for (int i = 0; i < this.teammates.length; ++i) {
            this.killTeammate(i);
            this.teammateAlive[i] = true;
        }
    }

    private void killTeammate(int i) {
        this.teammateAlive[i] = false;
        this.teammateX[i] = Double.NaN;
        this.teammateY[i] = Double.NaN;
        this.teammateHeading[i] = Double.NaN;
        this.teammateGunHeading[i] = Double.NaN;
        this.teammateRadarHeading[i] = Double.NaN;
        this.teammateVelocity[i] = Double.NaN;
        this.teammateEnergy[i] = Double.NaN;
        this.teammateGunHeat[i] = Double.NaN;
        this.teammateTarget[i] = null;
        this.teammateDestinationX[i] = Double.NaN;
        this.teammateDestinationY[i] = Double.NaN;
    }

    private void printError(String text) {
        System.out.println("[" + this.getTime() + "] CoopRobot Error! " + text);
    }

    private void go() {
        this.init();
        if (this.colorsSet && (!this.isTeam || this.getTime() > 2L)) {
            this.colorsSet = false;
            super.setColors(this.robotColor, this.gunColor, this.radarColor);
        }
        if (this.isTeam) {
            MsgSelf msgSelf = new MsgSelf(this.getX(), this.getY(), this.getHeading(), this.getGunHeading(), this.getRadarHeading(), this.getVelocity(), this.getEnergy(), this.getGunHeat(), this.target, this.destinationX, this.destinationY);
            try {
                this.broadcastMessage(msgSelf);
            }
            catch (IOException e) {
                this.printError("Unable to broadcast data on self!");
            }
        }
        if (this.endRound) {
            if (this.isTeam) {
                this.clearTeammateData();
            }
            this.endRound = false;
        }
    }

    private void sendScan(ScannedRobotEvent e) {
        double enemyBearing = this.getHeading() + e.getBearing();
        double enemyX = this.getX() + e.getDistance() * Math.sin(Math.toRadians(enemyBearing));
        double enemyY = this.getY() + e.getDistance() * Math.cos(Math.toRadians(enemyBearing));
        try {
            this.broadcastMessage(new MsgScan(e.getName(), enemyX, enemyY, e.getHeading(), e.getVelocity(), e.getEnergy()));
        }
        catch (IOException ex) {
            this.printError("Unable to broadcast scan data on: " + e.getName());
        }
    }

    private static final double normalizeBearingCoop(double angle) {
        return Math.atan2(Math.sin(angle), Math.cos(angle));
    }

    public void setAllowTeamScans(boolean allowTeamScans) {
        this.init();
        this.allowTeamScans = allowTeamScans;
    }

    public int getLiveTeammates() {
        if (!this.isTeam) {
            return 0;
        }
        int total = 0;
        for (int i = 0; i < this.teammateAlive.length; ++i) {
            if (!this.teammateAlive[i]) continue;
            ++total;
        }
        return total;
    }

    private double getTeammateData(double[] data, String name) {
        int i = this.getNameIndex(name);
        if (i < 0) {
            return Double.NaN;
        }
        return data[i];
    }

    public double getTeammateX(String name) {
        return this.getTeammateData(this.teammateX, name);
    }

    public double getTeammateY(String name) {
        return this.getTeammateData(this.teammateY, name);
    }

    public double getTeammateHeading(String name) {
        return this.getTeammateData(this.teammateHeading, name);
    }

    public double getTeammateGunHeading(String name) {
        return this.getTeammateData(this.teammateGunHeading, name);
    }

    public double getTeammateRadarHeading(String name) {
        return this.getTeammateData(this.teammateRadarHeading, name);
    }

    public double getTeammateVelocity(String name) {
        return this.getTeammateData(this.teammateVelocity, name);
    }

    public double getTeammateEnergy(String name) {
        return this.getTeammateData(this.teammateEnergy, name);
    }

    public double getTeammateGunHeat(String name) {
        return this.getTeammateData(this.teammateGunHeat, name);
    }

    public double getTeammateDestinationX(String name) {
        return this.getTeammateData(this.teammateDestinationX, name);
    }

    public double getTeammateDestinationY(String name) {
        return this.getTeammateData(this.teammateDestinationY, name);
    }

    public boolean isTeammateAlive(String name) {
        int i = this.getNameIndex(name);
        if (i < 0) {
            return false;
        }
        return this.teammateAlive[i];
    }

    public String getTeammateTarget(String name) {
        int i = this.getNameIndex(name);
        if (i < 0) {
            return null;
        }
        return this.teammateTarget[i];
    }

    public void setColors(Color robotColor, Color gunColor, Color radarColor) {
        this.init();
        this.robotColor = robotColor;
        if (!this.isTeam) {
            this.gunColor = gunColor;
        }
        if (!this.isTeam) {
            this.radarColor = radarColor;
        }
        this.colorsSet = true;
    }

    public Vector getAllEvents() {
        return this.events;
    }

    public int getOthers() {
        if (this.isTeam) {
            return super.getOthers() - this.getLiveTeammates();
        }
        return super.getOthers();
    }

    public Vector getScannedRobotEvents() {
        return this.parseEvents("robocode.ScannedRobotEvent");
    }

    public Vector getRobotDeathEvents() {
        return this.parseEvents("robocode.RobotDeathEvent");
    }

    public Vector getHitRobotEvents() {
        return this.parseEvents("robocode.HitRobotEvent");
    }

    public Vector getHitWallEvents() {
        return this.parseEvents("robocode.Event");
    }

    public Vector getHitByBulletEvents() {
        return this.parseEvents("robocode.HitByBulletEvent");
    }

    public Vector getBulletHitEvents() {
        return this.parseEvents("robocode.Event");
    }

    public Vector getBulletMissedEvents() {
        return this.parseEvents("robocode.Event");
    }

    public Vector getBulletHitBulletEvents() {
        return this.parseEvents("robocode.Event");
    }

    private Vector parseEvents(String type) {
        Vector newevents = new Vector();
        for (int i = 0; i < this.events.size(); ++i) {
            if (this.events.get(i).getClass().getName().equals(type)) {
                newevents.add(this.events.get(i));
            }
            this.out.println(this.events.get(i).getClass().getName());
        }
        this.out.println(newevents.size() + " " + newevents);
        return newevents;
    }

    public void clearAllEvents() {
        this.events.clear();
        this.events = null;
    }

    public void addCustomEvent(Condition condition) {
        this.init();
        super.addCustomEvent(condition);
    }

    public void execute() {
        this.go();
        super.execute();
        this.dump();
    }

    public void doNothing() {
        this.execute();
    }

    public void scan() {
        this.go();
        super.scan();
        this.dump();
    }

    public void fire(double power) {
        this.go();
        super.fire(power);
        this.dump();
    }

    public Bullet fireBullet(double power) {
        this.go();
        Bullet bullet = super.fireBullet(power);
        this.dump();
        return bullet;
    }

    public void ahead(double distance) {
        this.setAhead(distance);
        while (this.getDistanceRemaining() > 0.0) {
            this.scan();
        }
    }

    public void back(double distance) {
        this.ahead(-distance);
    }

    public void turnRightRadians(double angle) {
        this.setTurnLeftRadians(angle);
        while (this.getTurnRemaining() != 0.0) {
            this.scan();
        }
    }

    public void turnLeftRadians(double angle) {
        this.turnRightRadians(-angle);
    }

    public void turnRight(double angle) {
        this.turnRightRadians(Math.toRadians(angle));
    }

    public void turnLeft(double angle) {
        this.turnRight(-angle);
    }

    public void turnGunRightRadians(double angle) {
        this.setTurnGunRightRadians(angle);
        while (this.getGunTurnRemaining() != 0.0) {
            this.scan();
        }
    }

    public void turnGunLeftRadians(double angle) {
        this.turnGunRightRadians(-angle);
    }

    public void turnGunRight(double angle) {
        this.turnGunRightRadians(Math.toRadians(angle));
    }

    public void turnGunLeft(double angle) {
        this.turnGunRight(-angle);
    }

    public void turnRadarRightRadians(double angle) {
        this.setTurnRadarRightRadians(angle);
        while (this.getRadarTurnRemaining() != 0.0) {
            this.scan();
        }
    }

    public void turnRadarLeftRadians(double angle) {
        this.turnRadarRightRadians(-angle);
    }

    public void turnRadarRight(double angle) {
        this.turnRadarRightRadians(Math.toRadians(angle));
    }

    public void turnRadarLeft(double angle) {
        this.turnRadarRight(-angle);
    }
}

