/*
 * Decompiled with CFR 0.152.
 */
package vuen.fractal.gun;

import java.util.ArrayList;
import vuen.fractal.FractalE;
import vuen.fractal.data.Memory;
import vuen.fractal.data.Packet;
import vuen.fractal.gun.Wave;
import vuen.fractal.gun.WaveHandler;

public class Waver {
    FractalE robot;
    Memory memory;
    WaveHandler wh;
    int enemy;
    int target;
    public ArrayList waves;
    private int gunCoolTime;

    public Waver(FractalE robot, Memory memory, WaveHandler wh, int enemy) {
        this.robot = robot;
        this.memory = memory;
        this.wh = wh;
        this.enemy = enemy;
        this.target = enemy > 0 ? 0 : 1;
        this.waves = new ArrayList();
    }

    public void init() {
        this.waves.clear();
    }

    public void go() {
        if (this.enemy == 0) {
            this.target = this.memory.getTarget();
        }
        this.launchWave();
        for (int i = 0; i < this.waves.size(); ++i) {
            Wave wave = (Wave)this.waves.get(i);
            if (wave.isValid() && wave.isWaveDone()) {
                this.wh.doWave(wave);
                wave.destroy();
                this.waves.remove(i--);
                continue;
            }
            if (!FractalE.glwave) continue;
            wave.wavegl.draw();
        }
    }

    public void launchWave() {
        this.gunCoolTime = this.robot.getGunHeat() < 0.01 ? ++this.gunCoolTime : 0;
        if (this.gunCoolTime > 5 || this.robot.getTime() < 15L) {
            return;
        }
        Packet e = this.memory.getPacket(this.enemy);
        if (e == null) {
            return;
        }
        this.createWave(this.target, this.enemy, 20.0 - 3.0 * this.memory.gen.getAvgPower(0), this.robot.getTime());
    }

    public void createWave(int source, int target, double speed, double time) {
        int[] bins = this.wh.getBinVals();
        Wave wave = new Wave(source, target, speed, (long)time, bins, this.memory, FractalE.glwave, FractalE.renderer);
        if (wave.isUsable()) {
            this.waves.add(wave);
        }
    }
}

