/*
 * Decompiled with CFR 0.152.
 */
package starpkg;

import java.util.ArrayList;
import java.util.ListIterator;
import robocode.ScannedRobotEvent;
import starpkg.BattleArea;
import starpkg.EnemyData;
import starpkg.EnemyLog;
import starpkg.EnemyType;
import starpkg.Position;
import starpkg.Rect;
import starpkg.StarViewerZ;

public class EnemyStatus {
    private StarViewerZ robot = null;
    public EnemyData enemyMain = null;
    private BattleArea battleArea = null;
    public EnemyLog enemyLog = null;
    public ArrayList enemyList = new ArrayList();
    public int currEnemyId = -1;
    public int enemyID = 0;
    public boolean savingLog = false;

    public EnemyStatus(StarViewerZ getRobot) {
        this.robot = getRobot;
        this.battleArea = this.robot.battleArea;
        this.enemyLog = new EnemyLog(this.robot);
    }

    public void OnScanned(ScannedRobotEvent e) {
        EnemyData enemy = null;
        boolean enemyExists = false;
        Position cPos = new Position();
        double absRad = (this.robot.getHeadingRadians() + e.getBearingRadians()) % (Math.PI * 2);
        cPos.X = this.robot.getX() + Math.sin(absRad) * e.getDistance();
        cPos.Y = this.robot.getY() + Math.cos(absRad) * e.getDistance();
        if (this.enemyList.isEmpty()) {
            enemy = new EnemyData();
            enemy.Update(e.getName(), this.robot.getTime(), e.getHeading(), e.getHeadingRadians(), e.getVelocity(), e.getDistance(), e.getEnergy(), e.getBearing(), cPos);
            this.currEnemyId = enemy.id = this.enemyID++;
            enemy.CheckErrorLog();
            this.enemyList.add(enemy);
            enemyExists = true;
            this.enemyMain = (EnemyData)this.enemyList.get(this.currEnemyId);
        } else {
            ListIterator enemyListItor = this.enemyList.listIterator(0);
            while (enemyListItor.hasNext()) {
                enemy = (EnemyData)enemyListItor.next();
                if (enemy.name != e.getName()) continue;
                enemyExists = true;
                break;
            }
            if (!enemyExists) {
                enemy = new EnemyData();
                this.enemyList.add(enemy);
                this.robot.out.print("AI : ");
                this.robot.out.println(e.getName());
                enemy.id = this.enemyID++;
                enemy.CheckErrorLog();
            }
            enemy.Update(e.getName(), this.robot.getTime(), e.getHeading(), e.getHeadingRadians(), e.getVelocity(), e.getDistance(), e.getEnergy(), e.getBearing(), cPos);
        }
        if (this.robot.status.totalEnemy > 3) {
            if (e.getName() == this.enemyMain.name || this.enemyMain.life > 20.0 && this.enemyMain.distance > 250.0 && this.robot.battleArea.CheckEnemyInCorner(cPos) && !this.robot.battleArea.CheckEnemyInCorner(this.enemyMain.pos) || this.enemyMain.distance - e.getDistance() > 100.0 && e.getDistance() < 250.0 || this.enemyMain.distance > e.getDistance() && this.enemyMain.distance > 5000.0 || e.getEnergy() <= 0.0 && e.getDistance() < 400.0 || e.getEnergy() <= 10.0 && e.getDistance() < 300.0) {
                if (e.getName() != this.enemyMain.name) {
                    this.robot.predict.Reset();
                    this.robot.out.print("Current Enemy ID : ");
                    this.robot.out.println(this.currEnemyId);
                    this.currEnemyId = enemy.id;
                    this.enemyMain = (EnemyData)this.enemyList.get(this.currEnemyId);
                    this.robot.shootAnalyser.curEnemyEnergy = 1000.0;
                }
                this.robot.predict.Update();
            }
        } else if (e.getName() == this.enemyMain.name || this.enemyMain.distance - e.getDistance() > 200.0 && (this.enemyMain.life > 10.0 || this.enemyMain.distance > 3000.0) || e.getVelocity() <= 0.0 && e.getDistance() < 400.0) {
            if (e.getName() != this.enemyMain.name) {
                this.robot.predict.Reset();
                this.robot.out.print("Current Enemy ID : ");
                this.robot.out.println(this.currEnemyId);
                this.currEnemyId = enemy.id;
                this.enemyMain = (EnemyData)this.enemyList.get(this.currEnemyId);
            }
            if (!this.enemyMain.type.loaded && this.robot.status.totalEnemy <= 1) {
                this.enemyMain.type = new EnemyType(this.enemyLog.ReadEnemyTypeData(e.getName()));
                this.enemyMain.type.loaded = true;
            }
            this.robot.predict.Update();
        }
    }

    public void OnRobotDeath(String cName) {
        if (cName == this.enemyMain.name) {
            if (this.robot.status.totalEnemy <= 1) {
                this.enemyLog.SaveData(this.enemyMain.name, this.enemyMain.type);
            }
            this.enemyMain.distance = 10000.0;
            this.robot.setTurnRadarRight(720.0);
        }
        if (this.savingLog) {
            return;
        }
        if (this.robot.status.totalEnemy > 1) {
            ListIterator enemyListItor = this.enemyList.listIterator(0);
            while (enemyListItor.hasNext()) {
                EnemyData enemy = (EnemyData)enemyListItor.next();
                if (enemy.name != cName) continue;
                this.robot.out.print("AI: Remove ");
                this.robot.out.println(enemy.name);
                enemy.alive = false;
            }
        }
    }

    public void Save1v1Enemy() {
        this.enemyMain.CalTotalHitPercentage();
        this.enemyLog.SaveData(this.enemyMain.name, this.enemyMain.type);
    }

    public void SaveAllEnemyTypeData() {
        this.savingLog = true;
        if (!this.enemyList.isEmpty()) {
            EnemyData enemy = null;
            ListIterator enemyListItor = this.enemyList.listIterator(0);
            int count = 0;
            while (enemyListItor.hasNext()) {
                enemy = (EnemyData)enemyListItor.next();
                enemy.CalTotalHitPercentage();
                this.enemyLog.SaveData(enemy.name, enemy.type);
                if (++count > 20) break;
            }
            this.enemyList.clear();
        }
        this.savingLog = false;
    }

    public int CheckEnemyNearMe(double minDist) {
        EnemyData enemy = null;
        ListIterator enemyListItor = this.enemyList.listIterator(0);
        int count = 0;
        while (enemyListItor.hasNext()) {
            enemy = (EnemyData)enemyListItor.next();
            if (!enemy.alive || !(enemy.distance <= minDist)) continue;
            ++count;
        }
        return count;
    }

    public boolean CheckRectEnemyInside(Rect chkRect) {
        EnemyData enemy = null;
        ListIterator enemyListItor = this.enemyList.listIterator(0);
        while (enemyListItor.hasNext()) {
            enemy = (EnemyData)enemyListItor.next();
            if (!enemy.alive || !chkRect.PointInside(enemy.pos)) continue;
            return true;
        }
        return false;
    }

    public Position GetSafePos(double minDist, Position myPos) {
        EnemyData enemy = null;
        ListIterator enemyListItor = this.enemyList.listIterator(0);
        Position sPos = new Position(myPos);
        boolean inMinDist = true;
        boolean move = false;
        int eID = -1;
        double minEnemyDist = 5000.0;
        double dist = 0.0;
        int count = 0;
        boolean useMinDist = false;
        enemyListItor = this.enemyList.listIterator(0);
        while (enemyListItor.hasNext()) {
            enemy = (EnemyData)enemyListItor.next();
            if (enemy.alive && (dist = myPos.Distance(enemy.pos)) < minDist) {
                if (this.robot.status.totalEnemy > 6) {
                    if (dist < 200.0) {
                        useMinDist = true;
                    }
                    if (useMinDist) {
                        if (dist < minEnemyDist) {
                            minEnemyDist = dist;
                            eID = count;
                        }
                    } else if (dist > minEnemyDist) {
                        minEnemyDist = dist;
                        eID = count;
                    }
                } else if (dist < minEnemyDist) {
                    minEnemyDist = dist;
                    eID = count;
                }
            }
            ++count;
        }
        if (eID != -1) {
            enemy = (EnemyData)this.enemyList.get(eID);
            if (sPos.X < enemy.pos.X) {
                sPos.X = enemy.pos.X - minDist;
                if (sPos.X < this.battleArea.maxArea.pos1.X) {
                    sPos.X = this.battleArea.maxArea.pos1.X;
                }
            } else if (sPos.X > enemy.pos.X) {
                sPos.X = enemy.pos.X + minDist;
                if (sPos.X > this.battleArea.maxArea.pos2.X) {
                    sPos.X = this.battleArea.maxArea.pos2.X;
                }
            }
            if (sPos.Y < enemy.pos.Y) {
                sPos.Y = enemy.pos.Y - minDist;
                if (sPos.Y < this.battleArea.maxArea.pos1.Y) {
                    sPos.Y = this.battleArea.maxArea.pos1.Y;
                }
            } else if (sPos.Y > enemy.pos.Y) {
                sPos.Y = enemy.pos.Y + minDist;
                if (sPos.Y > this.battleArea.maxArea.pos2.Y) {
                    sPos.Y = this.battleArea.maxArea.pos2.Y;
                }
            }
            return sPos;
        }
        return new Position(-1000.0, -1000.0);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void CalPosAreaSp() {
        this.battleArea.CheckPosAreaEnemy();
        int other = 0;
        int i = 0;
        while (i < 16) {
            this.battleArea.PosArea[i].sp = 0.0;
            if (this.battleArea.PosAreaEnemy[i] > 0) {
                this.battleArea.PosArea[i].sp += (double)(this.battleArea.PosAreaEnemy[i] * 10);
            }
            ListIterator relRectListItor = this.battleArea.PosArea[i].relRectId.listIterator(0);
            other = 0;
            while (relRectListItor.hasNext()) {
                Integer relRectId = (Integer)relRectListItor.next();
                if (this.battleArea.PosAreaEnemy[relRectId] <= 0) continue;
                this.battleArea.PosArea[i].sp += (double)this.battleArea.PosAreaEnemy[relRectId];
                ++other;
            }
            if (other > 2) {
                this.battleArea.PosArea[i].sp += (double)(other * 5);
            } else if (other > 0) {
                this.battleArea.PosArea[i].sp += (double)(other * 2);
            }
            if ((i == 0 || i == 3 || i == 12 || i == 15) && this.battleArea.PosAreaEnemy[i] == 0) {
                this.battleArea.PosArea[i].sp -= 0.5;
            }
            ++i;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public int GetBestCornerId(int myAreaId) {
        int bestId = -1;
        double sp = 1000.0;
        this.CalPosAreaSp();
        int i = 0;
        while (i < 16) {
            if ((i == 0 || i == 3 || i == 12 || i == 15) && this.battleArea.PosArea[i].sp < sp) {
                sp = this.battleArea.PosArea[i].sp;
                bestId = i;
            }
            ++i;
        }
        if (bestId >= 0) {
            return bestId;
        }
        return myAreaId;
    }

    public int GetBestAreaId(int myAreaId) {
        ListIterator relRectListItor = this.battleArea.PosArea[myAreaId].relRectId.listIterator(0);
        int bestId = -1;
        double sp = 1000.0;
        this.CalPosAreaSp();
        while (relRectListItor.hasNext()) {
            Integer relRectId = (Integer)relRectListItor.next();
            if (!(this.battleArea.PosArea[relRectId.intValue()].sp < sp)) continue;
            sp = this.battleArea.PosArea[relRectId.intValue()].sp;
            bestId = relRectId;
        }
        if (this.battleArea.PosArea[bestId].sp < this.battleArea.PosArea[myAreaId].sp) {
            return bestId;
        }
        return myAreaId;
    }
}

