/*
 * Decompiled with CFR 0.152.
 */
package starpkg;

import starpkg.Position;

public class HelperTools {
    public double NormalAngle(double angle) {
        if (angle > 0.0) {
            if (angle > 180.0) {
                angle = 360.0 - angle;
            } else if (angle < 180.0) {
                angle *= -1.0;
            }
        } else if (angle < 0.0) {
            angle = angle < -180.0 ? (360.0 + angle) * -1.0 : (angle *= -1.0);
        }
        return angle;
    }

    public double NormalRelativeAngle(double angle) {
        if (angle > -180.0 && angle <= 180.0) {
            return angle;
        }
        double fixedAngle = angle;
        while (fixedAngle <= -180.0) {
            fixedAngle += 360.0;
        }
        while (fixedAngle > 180.0) {
            fixedAngle -= 360.0;
        }
        return fixedAngle;
    }

    public double NormaliseHeading(double ang) {
        if (ang > Math.PI * 2) {
            ang -= Math.PI * 2;
        }
        if (ang < 0.0) {
            ang += Math.PI * 2;
        }
        return ang;
    }

    public double NormaliseBearing(double ang) {
        if (ang > Math.PI) {
            ang -= Math.PI * 2;
        }
        if (ang < -Math.PI) {
            ang += Math.PI * 2;
        }
        return ang;
    }

    public double Absbearing(Position pos1, Position pos2) {
        double posX = pos2.X - pos1.X;
        double posY = pos2.Y - pos1.Y;
        double dist = pos1.Distance(pos2);
        if (posX > 0.0 && posY > 0.0) {
            return Math.asin(posX / dist);
        }
        if (posX > 0.0 && posY < 0.0) {
            return Math.PI - Math.asin(posX / dist);
        }
        if (posX < 0.0 && posY < 0.0) {
            return Math.PI + Math.asin(-posX / dist);
        }
        if (posX < 0.0 && posY > 0.0) {
            return Math.PI * 2 - Math.asin(-posX / dist);
        }
        return 0.0;
    }

    public double GetAngleDifferent(double a1, double a2) {
        double dangle = Math.abs(a1 - a2);
        if (dangle > 180.0) {
            dangle = 360.0 - dangle;
        }
        return dangle;
    }

    public double CalHeadingTurnDifferent(double a1, double a2) {
        double dangle = a1 - a2;
        if (dangle > 0.0) {
            if (dangle > 180.0) {
                dangle = (360.0 - dangle) * -1.0;
            }
        } else if (dangle < -180.0) {
            dangle = 360.0 + dangle;
        }
        return dangle;
    }
}

