/*
 * Decompiled with CFR 0.152.
 */
package rdt199.util;

import rdt199.util.BotFuncs;
import rdt199.util.RobotLog;
import rdt199.util.RobotSnapshot;
import rdt199.util.Storage;
import robocode.RobotDeathEvent;
import robocode.ScannedRobotEvent;

public class RobotLogger {
    protected Storage m_RobotLogs = new Storage(BotFuncs.m_AdvancedRobot.getOthers());
    protected String m_Prefix;

    public RobotLogger(String prefix) {
        this.m_Prefix = prefix;
    }

    public void update(ScannedRobotEvent event) {
        RobotLog Log = this.getRobotLog(event.getName());
        if (Log != null) {
            RobotSnapshot Snap = new RobotSnapshot(event);
            Log.update(Snap);
        } else {
            this.addNewBot(event);
        }
    }

    public RobotLog getRobotLog(String name) {
        if (name == null) {
            return null;
        }
        int iCount = 0;
        while (iCount < this.m_RobotLogs.size()) {
            RobotLog Log = (RobotLog)this.m_RobotLogs.get(iCount);
            if (Log != null && Log.getName().equals(name)) {
                return Log;
            }
            ++iCount;
        }
        return null;
    }

    public void addNewBot(ScannedRobotEvent event) {
        RobotSnapshot Snap = new RobotSnapshot(event);
        RobotLog Log = new RobotLog(event.getName(), this.m_Prefix);
        Log.update(Snap);
        this.m_RobotLogs.add(Log);
    }

    public void killBot(RobotDeathEvent event) {
        RobotLog Log = this.getRobotLog(event.getName());
        if (Log != null) {
            Log.kill();
        }
    }

    public Storage getAllBotStats() {
        return this.m_RobotLogs;
    }

    public void close() {
        int iCount = 0;
        while (iCount < this.m_RobotLogs.size()) {
            RobotLog Log = (RobotLog)this.m_RobotLogs.get(iCount);
            if (Log != null) {
                Log.close();
            }
            ++iCount;
        }
    }
}

