/*
 * Decompiled with CFR 0.152.
 */
package pulsar.gf;

import pulsar.gf.Segmentation;
import pulsar.util.RobotData;

public class VelocitySegmentation
extends Segmentation {
    public VelocitySegmentation() {
        this(1);
    }

    public VelocitySegmentation(int segmentation) {
        switch (segmentation) {
            case 0: {
                this.setLimits(new double[]{2, 5});
                break;
            }
            case 1: {
                this.setLimits(new double[]{2, 4, 6});
                break;
            }
            case 2: {
                this.setLimits(new double[]{1.0, 3, 5, 7});
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid segmentation: " + segmentation);
            }
        }
    }

    protected double getValue(RobotData firedFrom, RobotData firedAt, int stepsBack) {
        return Math.abs(firedAt.getValue(firedAt.velocity, stepsBack));
    }
}

