/*
 * Decompiled with CFR 0.152.
 */
package amc;

import amc.BulletWave;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import robocode.AdvancedRobot;
import robocode.HitByBulletEvent;
import robocode.HitRobotEvent;
import robocode.ScannedRobotEvent;
import robocode.WinEvent;
import robocode.util.Utils;

public class ROBv300
extends AdvancedRobot {
    private final double ROBOT_DISTANCE = 180.0;
    private final int WALL_STICK = 40;
    private static final double BATTLE_FIELD_WIDTH = 800.0;
    private static final double BATTLE_FIELD_HEIGHT = 600.0;
    private Rectangle2D _fieldRect = new Rectangle2D.Double(18.0, 18.0, 764.0, 564.0);
    private int targetX = Integer.MIN_VALUE;
    private int targetY = Integer.MIN_VALUE;
    private int direction = 1;
    private double goalDir;
    private static final int BINS = 25;
    private List<BulletWave> bulletWaves = new ArrayList<BulletWave>();
    private static int[] stats = new int[25];
    private short targetDirection = 1;

    public void run() {
        this.setColors(Color.white, Color.white, Color.white, Color.white, Color.white);
        this.setAdjustGunForRobotTurn(true);
        this.setAdjustRadarForGunTurn(true);
        while (true) {
            this.turnRadarRight(360.0);
        }
    }

    /*
     * Unable to fully structure code
     */
    public void onScannedRobot(ScannedRobotEvent e) {
        absBearing = this.getHeadingRadians() + e.getBearingRadians();
        this.targetX = (int)(this.getX() + Math.sin(absBearing) * e.getDistance());
        this.targetY = (int)(this.getY() + Math.cos(absBearing) * e.getDistance());
        radarTurn = absBearing - this.getRadarHeadingRadians();
        this.setTurnRadarRightRadians(1.9 * Utils.normalRelativeAngle((double)radarTurn));
        BulletWave.setTargetLocation(this.targetX, this.targetY);
        try {
            it = this.bulletWaves.iterator();
            while (true) {
                if (!(wave = it.next()).checkResult(this.getTime())) {
                    continue;
                }
                it.remove();
                this.out.println(Arrays.toString(ROBv300.stats));
            }
        }
        catch (Exception it) {
            bulletPower = 2.0;
            if (e.getVelocity() != 0.0) {
                this.targetDirection = Math.sin(e.getHeadingRadians() - absBearing) * e.getVelocity() < 0.0 ? (short)-1 : 1;
            }
            currentStats = ROBv300.stats;
            newWave = new BulletWave((int)this.getX(), (int)this.getY(), absBearing, bulletPower, this.targetDirection, this.getTime(), currentStats);
            bestIndex = 12;
            i = 0;
            ** while (i < 25)
        }
lbl-1000:
        // 1 sources

        {
            if (currentStats[i] > currentStats[bestIndex]) {
                bestIndex = i;
            }
            ++i;
            continue;
        }
lbl28:
        // 1 sources

        guessFactor = (bestIndex - (ROBv300.stats.length - 1) / 2) / ((ROBv300.stats.length - 1) / 2);
        this.out.println(guessFactor);
        angleOffset = guessFactor * newWave.maxEscapeAngle() * (double)this.targetDirection;
        gunTurn = Utils.normalRelativeAngle((double)(absBearing - this.getGunHeadingRadians() + angleOffset));
        this.setTurnGunRightRadians(gunTurn);
        if (this.getGunHeat() == 0.0 && gunTurn < Math.atan2(9.0, e.getDistance()) && this.setFireBullet(bulletPower) != null) {
            this.bulletWaves.add(newWave);
        }
        distanceOffset = this.distanceCheck(e.getDistance());
        angleDirection = 90.0 - e.getBearing() + distanceOffset;
        this.wallsCheck(Math.toRadians(angleDirection));
        this.setTurnLeft(angleDirection);
        this.setAhead(this.direction * 50);
    }

    private void wallsCheck(double goalDirection) {
        double offset = 0.0;
        if (this.direction < 0) {
            offset = Math.PI;
        }
        double absDir = offset + (this.getHeadingRadians() + goalDirection);
        if (!this._fieldRect.contains(this.getX() + Math.sin(absDir) * 40.0, this.getY() + Math.cos(absDir) * 40.0)) {
            this.direction *= -1;
        }
    }

    private double distanceCheck(double distance) {
        double offset = 25.0;
        offset = distance > 200.0 ? (offset *= (double)(-this.direction)) : (distance < 160.0 ? (offset *= (double)this.direction) : 0.0);
        return offset;
    }

    public void onHitByBullet(HitByBulletEvent e) {
        Math.abs(e.getBearing());
    }

    public void onHitRobot(HitRobotEvent e) {
        this.direction *= -1;
    }

    public void onWin(WinEvent e) {
        this.turnLeft(60.0);
        this.turnRight(120.0);
        this.turnLeft(120.0);
        this.turnRight(120.0);
        this.turnLeft(60.0);
        this.out.println("Yeah, I won this round!");
    }

    public void onPaint(Graphics2D g) {
        g.setColor(new Color(255, 0, 0, 128));
        g.drawLine(this.targetX, this.targetY, (int)this.getX(), (int)this.getY());
        g.fillRect(this.targetX - 20, this.targetY - 20, 40, 40);
        g.setColor(new Color(0, 255, 0));
        g.drawOval((int)this.getX() - 40, (int)this.getY() - 40, 80, 80);
        g.fillOval((int)(this.getX() + Math.sin(this.goalDir) * 40.0) - 2, (int)(this.getY() + Math.cos(this.goalDir) * 40.0) + 2, 5, 5);
        g.setColor(new Color(0, 0, 255));
        g.draw(this._fieldRect);
        g.setColor(Color.yellow);
        try {
            Iterator<BulletWave> it = this.bulletWaves.iterator();
            while (true) {
                BulletWave wave = it.next();
                double radius = wave.getDistanceTraveled(this.getTime());
                Point2D center = wave.getCenter();
                g.drawOval((int)(center.getX() - radius), (int)(center.getY() - radius), (int)(2.0 * radius), (int)(2.0 * radius));
            }
        }
        catch (Exception exception) {
            return;
        }
    }
}

