/*
 * Decompiled with CFR 0.152.
 */
package pedersen.divination;

import java.awt.Graphics2D;
import java.util.Iterator;
import pedersen.core.Combatant;
import pedersen.divination.CombatWave;
import pedersen.divination.FiringAngle;
import pedersen.divination.WaveInboundImpl;
import pedersen.misc.Metrics;
import pedersen.misc.VaultBase;
import pedersen.physics.StaticPosition;

public class WaveInboundBank
extends VaultBase {
    public static final WaveInboundBank singleton = new WaveInboundBank();

    private WaveInboundBank() {
    }

    public void process(long time) {
        Combatant targetPosition = Combatant.getCombatant();
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            CombatWave wave = (CombatWave)iterator.next();
            if (wave.isActive(targetPosition, time)) continue;
            this.remove(iterator);
        }
    }

    public boolean isHit(StaticPosition robotPosition, long time) {
        boolean isHit = false;
        Iterator iterator = this.iterator();
        while (!isHit && iterator.hasNext()) {
            CombatWave wave = (CombatWave)iterator.next();
            isHit = wave.isHit(robotPosition, time);
        }
        return isHit;
    }

    public void cancelAll() {
        Iterator outboundWaveIterator = this.iterator();
        while (outboundWaveIterator.hasNext()) {
            CombatWave wave = (CombatWave)outboundWaveIterator.next();
            Iterator firingAngleIterator = wave.getFiringAngleIterator();
            while (firingAngleIterator.hasNext()) {
                FiringAngle firingAngle = (FiringAngle)firingAngleIterator.next();
                firingAngle.getTargetingStatistics().incrementCancelled();
                firingAngleIterator.remove();
            }
        }
    }

    public void roundTeardown() {
        Iterator outboundWaveIterator = this.iterator();
        while (outboundWaveIterator.hasNext()) {
            CombatWave wave = (CombatWave)outboundWaveIterator.next();
            wave.setInactive();
        }
        this.purge();
    }

    public void onPaint(Graphics2D console) {
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            ((CombatWave)iterator.next()).onPaint(console);
        }
    }

    public void add(WaveInboundImpl wave) {
        super.add(wave);
        Metrics.addInboundWave();
    }
}

