/*
 * Decompiled with CFR 0.152.
 */
package pedersen.opponent;

import java.util.Iterator;
import pedersen.core.Combatant;
import pedersen.core.Constraints;
import pedersen.core.Conversions;
import pedersen.core.Foundation;
import pedersen.core.Snapshot;
import pedersen.core.Targetable;
import pedersen.core.TargetableBase;
import pedersen.debug.Debug;
import pedersen.divination.FiringAngle;
import pedersen.divination.WaveInboundBank;
import pedersen.divination.WaveInboundImpl;
import pedersen.misc.Host;
import pedersen.opponent.OpponentEnergyTracker;
import pedersen.opponent.Target;
import pedersen.physics.StaticPosition;
import pedersen.tactics.targeting.TargetingMethod;

public abstract class TargetBase
extends TargetableBase
implements Target {
    private final String name;
    private long lastUpdate = 0L;
    private OpponentEnergyTracker energyTracker = new OpponentEnergyTracker();
    private double totalBulletDamageReceived = 0.0;
    private double totalBulletDamageDealt = 0.0;

    protected TargetBase(String newName, Foundation robot) {
        this.name = newName;
        this.movementMethods = robot.getMovementMethods();
        this.offensiveTargetingMethods = robot.getOffensiveTargetingMethods();
        this.defensiveTargetingMethods = robot.getDefensiveTargetingMethods();
        this.fireControl = robot.getFireControl();
    }

    public void update(Snapshot newSnapshot) {
        this.activate();
        this.detectShot(newSnapshot.getEnergy());
        this.appendSnapshot(newSnapshot);
        this.energyTracker.set(newSnapshot.getEnergy());
        this.lastUpdate = Host.singleton.getTurn();
    }

    private void detectShot(double newEnergy) {
        long time = Host.singleton.getTurn();
        boolean isGunCool = Host.singleton.isGunCool(this.getLastShotFired(), this.getLastShotFirepower());
        double energyDrop = -this.energyTracker.compare(newEnergy);
        if (!(energyDrop > 0.0) || isGunCool) {
            // empty if block
        }
        if (Constraints.isFirepowerLegal(energyDrop) || this.doubleCheckForCloseEnough(energyDrop)) {
            Combatant combatant = Combatant.getCombatant();
            double velocity = Conversions.getBulletVelocityFromFirepower(energyDrop);
            velocity = Constraints.getClosestLegalBulletVelocity(velocity);
            combatant.setPerformanceStatisticsTracking(true);
            combatant.onEnemyFire();
            TargetBase firingPosition = this;
            WaveInboundImpl inboundWave = new WaveInboundImpl(this, (StaticPosition)firingPosition, velocity, (Targetable)combatant, time - 1L);
            inboundWave.setLiveRound();
            WaveInboundBank.singleton.add(inboundWave);
            Iterator iterator = this.getOffensiveTargetingMethods().iterator();
            while (iterator.hasNext()) {
                TargetingMethod targetingMethod = (TargetingMethod)iterator.next();
                FiringAngle firingAngle = targetingMethod.getFiringAngle(inboundWave, 1L);
                if (firingAngle == null) continue;
                inboundWave.addFiringAngle(firingAngle);
            }
            this.setLastShotFired(time);
            this.setLastShotFirepower(energyDrop);
        }
    }

    private boolean doubleCheckForCloseEnough(double energyDrop) {
        return Constraints.areEqual(energyDrop, 0.1) || Constraints.areEqual(energyDrop, 3.0);
    }

    public boolean equals(Target other) {
        return other != null && this.name.compareTo(other.getName()) == 0;
    }

    public void roundTearDown() {
        this.deactivate();
    }

    public void teardown() {
    }

    public void receiveBulletDamage(double damage) {
        this.energyTracker.add(-damage);
        this.totalBulletDamageReceived += damage;
    }

    public void dealBulletDamage(double firepower) {
        this.energyTracker.add(Conversions.getEnergyRewardFromFirepower(firepower));
        this.totalBulletDamageDealt += Conversions.getBulletDamageFromFirepower(firepower);
    }

    public void debug() {
        Debug.debug("Target: " + this.name);
        super.debug();
    }

    public String getName() {
        return this.name;
    }

    public long getLastUpdate() {
        return this.lastUpdate;
    }
}

