/*
 * Decompiled with CFR 0.152.
 */
package org.la4j.matrix.dense;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Random;
import org.la4j.Matrices;
import org.la4j.Matrix;
import org.la4j.Vector;
import org.la4j.matrix.DenseMatrix;
import org.la4j.matrix.MatrixFactory;
import org.la4j.vector.dense.BasicVector;

public class Basic2DMatrix
extends DenseMatrix {
    private static final byte MATRIX_TAG = 16;
    private double[][] self;

    public static Basic2DMatrix zero(int rows, int columns) {
        return new Basic2DMatrix(rows, columns);
    }

    public static Basic2DMatrix constant(int rows, int columns, double constant) {
        double[][] array = new double[rows][columns];
        for (int i = 0; i < rows; ++i) {
            Arrays.fill(array[i], constant);
        }
        return new Basic2DMatrix(array);
    }

    public static Basic2DMatrix diagonal(int size, double diagonal) {
        double[][] array = new double[size][size];
        for (int i = 0; i < size; ++i) {
            array[i][i] = diagonal;
        }
        return new Basic2DMatrix(array);
    }

    public static Basic2DMatrix unit(int rows, int columns) {
        return Basic2DMatrix.constant(rows, columns, 1.0);
    }

    public static Basic2DMatrix identity(int size) {
        return Basic2DMatrix.diagonal(size, 1.0);
    }

    public static Basic2DMatrix random(int rows, int columns, Random random) {
        double[][] array = new double[rows][columns];
        for (int i = 0; i < rows; ++i) {
            for (int j = 0; j < columns; ++j) {
                array[i][j] = random.nextDouble();
            }
        }
        return new Basic2DMatrix(array);
    }

    public static Basic2DMatrix randomSymmetric(int size, Random random) {
        double[][] array = new double[size][size];
        for (int i = 0; i < size; ++i) {
            for (int j = i; j < size; ++j) {
                double value;
                array[i][j] = value = random.nextDouble();
                array[j][i] = value;
            }
        }
        return new Basic2DMatrix(array);
    }

    public static Basic2DMatrix from1DArray(int rows, int columns, double[] array) {
        double[][] array2D = new double[rows][columns];
        for (int i = 0; i < rows; ++i) {
            System.arraycopy(array, i * columns, array2D[i], 0, columns);
        }
        return new Basic2DMatrix(array2D);
    }

    public static Basic2DMatrix from2DArray(double[][] array) {
        return new Basic2DMatrix(array);
    }

    public static Basic2DMatrix block(Matrix a, Matrix b, Matrix c, Matrix d) {
        if (a.rows() != b.rows() || a.columns() != c.columns() || c.rows() != d.rows() || b.columns() != d.columns()) {
            throw new IllegalArgumentException("Sides of blocks are incompatible!");
        }
        int rows = a.rows() + c.rows();
        int columns = a.columns() + b.columns();
        double[][] array = new double[rows][columns];
        for (int i = 0; i < rows; ++i) {
            for (int j = 0; j < columns; ++j) {
                if (i < a.rows() && j < a.columns()) {
                    array[i][j] = a.get(i, j);
                }
                if (i < a.rows() && j > a.columns()) {
                    array[i][j] = b.get(i, j);
                }
                if (i > a.rows() && j < a.columns()) {
                    array[i][j] = c.get(i, j);
                }
                if (i <= a.rows() || j <= a.columns()) continue;
                array[i][j] = d.get(i, j);
            }
        }
        return new Basic2DMatrix(array);
    }

    public static Basic2DMatrix fromBinary(byte[] array) {
        ByteBuffer buffer = ByteBuffer.wrap(array);
        if (buffer.get() != 16) {
            throw new IllegalArgumentException("Can not decode Basic2DMatrix from the given byte array.");
        }
        int rows = buffer.getInt();
        int columns = buffer.getInt();
        double[][] values2 = new double[rows][columns];
        for (int i = 0; i < rows; ++i) {
            for (int j = 0; j < columns; ++j) {
                values2[i][j] = buffer.getDouble();
            }
        }
        return new Basic2DMatrix(values2);
    }

    public static Basic2DMatrix fromCSV(String csv) {
        return Matrix.fromCSV(csv).to(Matrices.BASIC_2D);
    }

    public static Basic2DMatrix fromMatrixMarket(String mm) {
        return Matrix.fromMatrixMarket(mm).to(Matrices.BASIC_2D);
    }

    public Basic2DMatrix() {
        this(0, 0);
    }

    public Basic2DMatrix(int rows, int columns) {
        this(new double[rows][columns]);
    }

    public Basic2DMatrix(double[][] array) {
        super(array.length, array.length == 0 ? 0 : array[0].length);
        this.self = array;
    }

    @Override
    public double get(int i, int j) {
        return this.self[i][j];
    }

    @Override
    public void set(int i, int j, double value) {
        this.self[i][j] = value;
    }

    @Override
    public void setAll(double value) {
        for (int i = 0; i < this.rows; ++i) {
            Arrays.fill(this.self[i], value);
        }
    }

    @Override
    public void swapRows(int i, int j) {
        if (i != j) {
            double[] tmp = this.self[i];
            this.self[i] = this.self[j];
            this.self[j] = tmp;
        }
    }

    @Override
    public void swapColumns(int i, int j) {
        if (i != j) {
            for (int ii = 0; ii < this.rows; ++ii) {
                double tmp = this.self[ii][i];
                this.self[ii][i] = this.self[ii][j];
                this.self[ii][j] = tmp;
            }
        }
    }

    @Override
    public Vector getRow(int i) {
        double[] result = new double[this.columns];
        System.arraycopy(this.self[i], 0, result, 0, this.columns);
        return new BasicVector(result);
    }

    @Override
    public Matrix copyOfShape(int rows, int columns) {
        this.ensureDimensionsAreCorrect(rows, columns);
        double[][] $self = new double[rows][columns];
        for (int i = 0; i < Math.min(this.rows, rows); ++i) {
            System.arraycopy(this.self[i], 0, $self[i], 0, Math.min(this.columns, columns));
        }
        return new Basic2DMatrix($self);
    }

    @Override
    public double[][] toArray() {
        double[][] result = new double[this.rows][this.columns];
        for (int i = 0; i < this.rows; ++i) {
            System.arraycopy(this.self[i], 0, result[i], 0, this.columns);
        }
        return result;
    }

    @Override
    public <T extends Matrix> T to(MatrixFactory<T> factory) {
        if (factory.outputClass == Basic2DMatrix.class) {
            return (T)((Matrix)factory.outputClass.cast(this));
        }
        return super.to(factory);
    }

    @Override
    public Matrix blankOfShape(int rows, int columns) {
        return Basic2DMatrix.zero(rows, columns);
    }

    @Override
    public byte[] toBinary() {
        int size = 9 + 8 * this.rows * this.columns;
        ByteBuffer buffer = ByteBuffer.allocate(size);
        buffer.put((byte)16);
        buffer.putInt(this.rows);
        buffer.putInt(this.columns);
        for (int i = 0; i < this.rows; ++i) {
            for (double value : this.self[i]) {
                buffer.putDouble(value);
            }
        }
        return buffer.array();
    }
}

