/*
 * Decompiled with CFR 0.152.
 */
package apc;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import robocode.AdvancedRobot;
import robocode.HitByBulletEvent;
import robocode.RobotDeathEvent;
import robocode.ScannedRobotEvent;
import robocode.util.Utils;

public class botM
extends AdvancedRobot {
    Hashtable targets;
    Enemy target;
    final double PI = Math.PI;
    final int change = 2;
    int direction = 1;
    double firePower;
    double midpointstrength = 0.0;
    int midpointcount = 0;
    public static int BINS = 47;
    public static double[] _surfStats = new double[BINS];
    public static Point2D.Double _myLocation;
    public static Point2D.Double _enemyLocation;
    public static ArrayList _enemyWaves;
    public static ArrayList _surfDirections;
    public static ArrayList _surfAbsBearings;
    public static Rectangle2D.Double _fieldRect;
    public static double WALL_STICK;
    public static double _oppEnergy;

    static {
        WALL_STICK = 160.0;
        _oppEnergy = 100.0;
    }

    public void run() {
        _fieldRect = new Rectangle2D.Double(18.0, 18.0, this.getBattleFieldWidth() - 36.0, this.getBattleFieldHeight() - 36.0);
        this.targets = new Hashtable();
        this.target = new Enemy();
        this.target.distance = 1000000.0;
        _enemyWaves = new ArrayList();
        _surfDirections = new ArrayList();
        _surfAbsBearings = new ArrayList();
        this.setColors(Color.MAGENTA, Color.black, Color.black);
        this.setAdjustGunForRobotTurn(true);
        this.setAdjustRadarForGunTurn(true);
        while (true) {
            if (this.getState() == 0) {
                this.antiGravMove();
                this.doFirePower();
                this.doScanner();
                this.doGun();
                this.setFire(this.firePower);
                this.execute();
                continue;
            }
            this.doScanner();
            this.doSurfing();
            this.doFirePower();
            this.doGun();
            this.setFire(this.firePower);
            this.execute();
        }
    }

    void doFirePower() {
        this.firePower = 600.0 / this.target.distance;
        if (this.firePower > 3.0) {
            this.firePower = 3.0;
        }
    }

    int getState() {
        return this.getOthers() <= 2 && this.getOthers() != 0 ? 1 : 0;
    }

    void antiGravMove() {
        double ang;
        double force;
        GravPoint p;
        double xforce = 0.0;
        double yforce = 0.0;
        Enumeration e = this.targets.elements();
        while (e.hasMoreElements()) {
            Enemy en = (Enemy)e.nextElement();
            if (!en.alive) continue;
            p = new GravPoint(en.x, en.y, -1000.0);
            force = p.power / Math.pow(this.getRange(this.getX(), this.getY(), p.x, p.y), 2.0);
            ang = this.normaliseBearing(1.5707963267948966 - Math.atan2(this.getY() - p.y, this.getX() - p.x));
            xforce += Math.sin(ang) * force;
            yforce += Math.cos(ang) * force;
        }
        ++this.midpointcount;
        if (this.midpointcount > 5) {
            this.midpointcount = 0;
            this.midpointstrength = Math.random() * 2000.0 - 1000.0;
        }
        p = new GravPoint(this.getBattleFieldWidth() / 2.0, this.getBattleFieldHeight() / 2.0, this.midpointstrength);
        force = p.power / Math.pow(this.getRange(this.getX(), this.getY(), p.x, p.y), 1.5);
        ang = this.normaliseBearing(1.5707963267948966 - Math.atan2(this.getY() - p.y, this.getX() - p.x));
        xforce += Math.sin(ang) * force;
        yforce += Math.cos(ang) * force;
        xforce += 5000.0 / Math.pow(this.getRange(this.getX(), this.getY(), this.getBattleFieldWidth(), this.getY()), 3.0);
        yforce += 5000.0 / Math.pow(this.getRange(this.getX(), this.getY(), this.getX(), this.getBattleFieldHeight()), 3.0);
        this.goTo(this.getX() - (xforce -= 5000.0 / Math.pow(this.getRange(this.getX(), this.getY(), 0.0, this.getY()), 3.0)), this.getY() - (yforce -= 5000.0 / Math.pow(this.getRange(this.getX(), this.getY(), this.getX(), 0.0), 3.0)));
    }

    void goTo(double x, double y) {
        double dist = 20.0;
        double angle = Math.toDegrees(this.absbearing(this.getX(), this.getY(), x, y));
        double r = this.turnTo(angle);
        this.setAhead(dist * r);
    }

    int turnTo(double angle) {
        int dir;
        double ang = this.normaliseBearing(this.getHeading() - angle);
        if (ang > 90.0) {
            ang -= 180.0;
            dir = -1;
        } else if (ang < -90.0) {
            ang += 180.0;
            dir = -1;
        } else {
            dir = 1;
        }
        this.setTurnLeft(ang);
        return dir;
    }

    void doScanner() {
        this.setTurnRadarLeftRadians(Math.PI * 2);
    }

    void doGun() {
        Point2D.Double p = new Point2D.Double(this.target.x, this.target.y);
        int i = 0;
        while (i < 10) {
            long nextTime = (int)Math.round(this.getRange(this.getX(), this.getY(), p.x, p.y) / (20.0 - 3.0 * this.firePower));
            long time = this.getTime() + nextTime;
            p = this.target.guessPosition(time);
            ++i;
        }
        double gunOffset = this.getGunHeadingRadians() - (1.5707963267948966 - Math.atan2(p.y - this.getY(), p.x - this.getX()));
        this.setTurnGunLeftRadians(this.normaliseBearing(gunOffset));
    }

    double normaliseBearing(double ang) {
        if (ang > Math.PI) {
            ang -= Math.PI * 2;
        }
        if (ang < -Math.PI) {
            ang += Math.PI * 2;
        }
        return ang;
    }

    double normaliseHeading(double ang) {
        if (ang > Math.PI * 2) {
            ang -= Math.PI * 2;
        }
        if (ang < 0.0) {
            ang += Math.PI * 2;
        }
        return ang;
    }

    public double getRange(double x1, double y1, double x2, double y2) {
        double xo = x2 - x1;
        double yo = y2 - y1;
        double h = Math.sqrt(xo * xo + yo * yo);
        return h;
    }

    public double absbearing(double x1, double y1, double x2, double y2) {
        double xo = x2 - x1;
        double yo = y2 - y1;
        double h = this.getRange(x1, y1, x2, y2);
        if (xo > 0.0 && yo > 0.0) {
            return Math.asin(xo / h);
        }
        if (xo > 0.0 && yo < 0.0) {
            return Math.PI - Math.asin(xo / h);
        }
        if (xo < 0.0 && yo < 0.0) {
            return Math.PI + Math.asin(-xo / h);
        }
        if (xo < 0.0 && yo > 0.0) {
            return Math.PI * 2 - Math.asin(-xo / h);
        }
        return 0.0;
    }

    public void onScannedRobot(ScannedRobotEvent e) {
        Enemy en;
        if (this.targets.containsKey(e.getName())) {
            en = (Enemy)this.targets.get(e.getName());
        } else {
            en = new Enemy();
            this.targets.put(e.getName(), en);
        }
        double absbearing_rad = (this.getHeadingRadians() + e.getBearingRadians()) % (Math.PI * 2);
        en.name = e.getName();
        double h = this.normaliseBearing(e.getHeadingRadians() - en.heading);
        en.changehead = h /= (double)(this.getTime() - en.ctime);
        en.x = this.getX() + Math.sin(absbearing_rad) * e.getDistance();
        en.y = this.getY() + Math.cos(absbearing_rad) * e.getDistance();
        en.bearing = e.getBearingRadians();
        en.heading = e.getHeadingRadians();
        en.ctime = this.getTime();
        en.speed = e.getVelocity();
        en.distance = e.getDistance();
        en.energy = e.getEnergy();
        en.alive = true;
        if (en.distance < this.target.distance || !this.target.alive) {
            this.target = en;
        }
        if (this.getState() == 1) {
            _myLocation = new Point2D.Double(this.getX(), this.getY());
            double lateralVelocity = this.getVelocity() * Math.sin(e.getBearingRadians());
            double absBearing = e.getBearingRadians() + this.getHeadingRadians();
            this.setTurnRadarRightRadians(Utils.normalRelativeAngle((double)(absBearing - this.getRadarHeadingRadians())) * 2.0);
            _surfDirections.add(0, new Integer(lateralVelocity >= 0.0 ? 1 : -1));
            _surfAbsBearings.add(0, new Double(absBearing + Math.PI));
            double bulletPower = _oppEnergy - e.getEnergy();
            if (bulletPower < 3.01 && bulletPower > 0.09 && _surfDirections.size() > 2) {
                EnemyWave ew = new EnemyWave();
                ew.fireTime = this.getTime() - 1L;
                ew.bulletVelocity = botM.bulletVelocity(bulletPower);
                ew.distanceTraveled = botM.bulletVelocity(bulletPower);
                ew.direction = (Integer)_surfDirections.get(2);
                ew.directAngle = (Double)_surfAbsBearings.get(2);
                ew.fireLocation = (Point2D.Double)_enemyLocation.clone();
                _enemyWaves.add(ew);
            }
            _oppEnergy = e.getEnergy();
            _enemyLocation = botM.project(_myLocation, absBearing, e.getDistance());
            this.updateWaves();
        }
    }

    public void onRobotDeath(RobotDeathEvent e) {
        try {
            Enemy en = (Enemy)this.targets.get(e.getName());
            en.alive = false;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void updateWaves() {
        int x = 0;
        while (x < _enemyWaves.size()) {
            EnemyWave ew = (EnemyWave)_enemyWaves.get(x);
            ew.distanceTraveled = (double)(this.getTime() - ew.fireTime) * ew.bulletVelocity;
            if (ew.distanceTraveled > _myLocation.distance(ew.fireLocation) + 50.0) {
                _enemyWaves.remove(x);
                --x;
            }
            ++x;
        }
    }

    public EnemyWave getClosestSurfableWave() {
        double closestDistance = 50000.0;
        EnemyWave surfWave = null;
        int x = 0;
        while (x < _enemyWaves.size()) {
            EnemyWave ew = (EnemyWave)_enemyWaves.get(x);
            double distance = _myLocation.distance(ew.fireLocation) - ew.distanceTraveled;
            if (distance > ew.bulletVelocity && distance < closestDistance) {
                surfWave = ew;
                closestDistance = distance;
            }
            ++x;
        }
        return surfWave;
    }

    public static int getFactorIndex(EnemyWave ew, Point2D.Double targetLocation) {
        double offsetAngle = botM.absoluteBearing(ew.fireLocation, targetLocation) - ew.directAngle;
        double factor = Utils.normalRelativeAngle((double)offsetAngle) / botM.maxEscapeAngle(ew.bulletVelocity) * (double)ew.direction;
        return (int)botM.limit(0.0, factor * (double)((BINS - 1) / 2) + (double)((BINS - 1) / 2), BINS - 1);
    }

    public void logHit(EnemyWave ew, Point2D.Double targetLocation) {
        int index = botM.getFactorIndex(ew, targetLocation);
        int x = 0;
        while (x < BINS) {
            int n = x;
            _surfStats[n] = _surfStats[n] + 1.0 / (Math.pow(index - x, 2.0) + 1.0);
            ++x;
        }
    }

    public void onHitByBullet(HitByBulletEvent e) {
        if (this.getState() == 1) {
            try {
                if (!_enemyWaves.isEmpty()) {
                    Point2D.Double hitBulletLocation = new Point2D.Double(e.getBullet().getX(), e.getBullet().getY());
                    EnemyWave hitWave = null;
                    int x = 0;
                    while (x < _enemyWaves.size()) {
                        EnemyWave ew = (EnemyWave)_enemyWaves.get(x);
                        if (Math.abs(ew.distanceTraveled - _myLocation.distance(ew.fireLocation)) < 50.0 && Math.abs(botM.bulletVelocity(e.getBullet().getPower()) - ew.bulletVelocity) < 0.001) {
                            hitWave = ew;
                            break;
                        }
                        ++x;
                    }
                    if (hitWave != null) {
                        this.logHit(hitWave, hitBulletLocation);
                        _enemyWaves.remove(_enemyWaves.lastIndexOf(hitWave));
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public Point2D.Double predictPosition(EnemyWave surfWave, int direction) {
        Point2D.Double predictedPosition = (Point2D.Double)_myLocation.clone();
        double predictedVelocity = this.getVelocity();
        double predictedHeading = this.getHeadingRadians();
        int counter = 0;
        boolean intercepted = false;
        do {
            double moveAngle = this.wallSmoothing(predictedPosition, botM.absoluteBearing(surfWave.fireLocation, predictedPosition) + (double)direction * 1.5707963267948966, direction) - predictedHeading;
            double moveDir = 1.0;
            if (Math.cos(moveAngle) < 0.0) {
                moveAngle += Math.PI;
                moveDir = -1.0;
            }
            moveAngle = Utils.normalRelativeAngle((double)moveAngle);
            double maxTurning = 0.004363323129985824 * (40.0 - 3.0 * Math.abs(predictedVelocity));
            predictedHeading = Utils.normalRelativeAngle((double)(predictedHeading + botM.limit(-maxTurning, moveAngle, maxTurning)));
            predictedVelocity += predictedVelocity * moveDir < 0.0 ? 2.0 * moveDir : moveDir;
            predictedVelocity = botM.limit(-8.0, predictedVelocity, 8.0);
            predictedPosition = botM.project(predictedPosition, predictedHeading, predictedVelocity);
            ++counter;
            if (!(predictedPosition.distance(surfWave.fireLocation) < surfWave.distanceTraveled + (double)counter * surfWave.bulletVelocity + surfWave.bulletVelocity)) continue;
            intercepted = true;
        } while (!intercepted && counter < 500);
        return predictedPosition;
    }

    public double checkDanger(EnemyWave surfWave, int direction) {
        int index = botM.getFactorIndex(surfWave, this.predictPosition(surfWave, direction));
        return _surfStats[index];
    }

    public void doSurfing() {
        EnemyWave surfWave = this.getClosestSurfableWave();
        if (surfWave == null) {
            this.antiGravMove();
            return;
        }
        double dangerLeft = this.checkDanger(surfWave, -1);
        double dangerRight = this.checkDanger(surfWave, 1);
        double goAngle = botM.absoluteBearing(surfWave.fireLocation, _myLocation);
        goAngle = dangerLeft < dangerRight ? this.wallSmoothing(_myLocation, goAngle - 1.5707963267948966, -1) : this.wallSmoothing(_myLocation, goAngle + 1.5707963267948966, 1);
        botM.setBackAsFront(this, goAngle);
    }

    public double wallSmoothing(Point2D.Double botLocation, double angle, int orientation) {
        while (!_fieldRect.contains(botM.project(botLocation, angle, 160.0))) {
            angle += (double)orientation * 0.05;
        }
        return angle;
    }

    public static Point2D.Double project(Point2D.Double sourceLocation, double angle, double length) {
        return new Point2D.Double(sourceLocation.x + Math.sin(angle) * length, sourceLocation.y + Math.cos(angle) * length);
    }

    public static double absoluteBearing(Point2D.Double source, Point2D.Double target) {
        return Math.atan2(target.x - source.x, target.y - source.y);
    }

    public static double limit(double min, double value, double max) {
        return Math.max(min, Math.min(value, max));
    }

    public static double bulletVelocity(double power) {
        return 20.0 - 3.0 * power;
    }

    public static double maxEscapeAngle(double velocity) {
        return Math.asin(8.0 / velocity);
    }

    public static void setBackAsFront(AdvancedRobot robot, double goAngle) {
        double angle = Utils.normalRelativeAngle((double)(goAngle - robot.getHeadingRadians()));
        if (Math.abs(angle) > 1.5707963267948966) {
            if (angle < 0.0) {
                robot.setTurnRightRadians(Math.PI + angle);
            } else {
                robot.setTurnLeftRadians(Math.PI - angle);
            }
            robot.setBack(100.0);
        } else {
            if (angle < 0.0) {
                robot.setTurnLeftRadians(-1.0 * angle);
            } else {
                robot.setTurnRightRadians(angle);
            }
            robot.setAhead(100.0);
        }
    }

    public void onPaint(Graphics2D g) {
        g.setColor(Color.red);
        int i = 0;
        while (i < _enemyWaves.size()) {
            EnemyWave w = (EnemyWave)_enemyWaves.get(i);
            int radius = (int)w.distanceTraveled;
            Point2D.Double center = w.fireLocation;
            if ((double)(radius - 40) < center.distance(_myLocation)) {
                g.drawOval((int)(center.x - (double)radius), (int)(center.y - (double)radius), radius * 2, radius * 2);
            }
            ++i;
        }
    }

    class Enemy {
        String name;
        public double bearing;
        public double heading;
        public double speed;
        public double x;
        public double y;
        public double distance;
        public double changehead;
        public double energy;
        public long ctime;
        public boolean alive;

        Enemy() {
        }

        public Point2D.Double guessPosition(long when) {
            double newX;
            double newY;
            double diff = when - this.ctime;
            if (Math.abs(this.changehead) > 1.0E-5) {
                double radius = this.speed / this.changehead;
                double tothead = diff * this.changehead;
                newY = this.y + Math.sin(this.heading + tothead) * radius - Math.sin(this.heading) * radius;
                newX = this.x + Math.cos(this.heading) * radius - Math.cos(this.heading + tothead) * radius;
            } else {
                newY = this.y + Math.cos(this.heading) * this.speed * diff;
                newX = this.x + Math.sin(this.heading) * this.speed * diff;
            }
            return new Point2D.Double(newX, newY);
        }
    }

    class EnemyWave {
        Point2D.Double fireLocation;
        long fireTime;
        double bulletVelocity;
        double directAngle;
        double distanceTraveled;
        int direction;
    }

    class GravPoint {
        public double x;
        public double y;
        public double power;

        public GravPoint(double pX, double pY, double pPower) {
            this.x = pX;
            this.y = pY;
            this.power = pPower;
        }
    }
}

