/*
 * Decompiled with CFR 0.152.
 */
package kano.gamma;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import kano.gamma.Enemy;
import kano.gamma.KanoGamma;
import kano.gamma.Zone;
import robocode.RobotDeathEvent;
import robocode.ScannedRobotEvent;

public class EnemyMgr {
    Hashtable enemies = new Hashtable();
    Hashtable backUp = new Hashtable();
    private KanoGamma bot;
    Enemy currentTarget = null;

    public EnemyMgr(KanoGamma bot) {
        this.bot = bot;
        this.currentTarget = null;
    }

    public void addEnemy(ScannedRobotEvent e) {
        String name = e.getName();
        Enemy enemy = (Enemy)this.enemies.get(name);
        if (enemy == null) {
            enemy = new Enemy();
            this.enemies.put(name, enemy);
            enemy.name = name;
        }
        double absbearing_rad = (this.bot.getHeadingRadians() + e.getBearingRadians()) % (Math.PI * 2);
        enemy.x = this.bot.getX() + Math.sin(absbearing_rad) * e.getDistance();
        enemy.y = this.bot.getY() + Math.cos(absbearing_rad) * e.getDistance();
        enemy.bearing = e.getBearingRadians();
        enemy.head = e.getHeadingRadians();
        enemy.ctime = this.bot.getTime();
        enemy.oldspeed = enemy.speed;
        enemy.speed = e.getVelocity();
        if (this.bot.getOthers() == 1) {
            if (enemy.oldspeed * enemy.speed < 0.0) {
                if (enemy.isOscilating) {
                    enemy.avgOscilTime = enemy.avgOscilTime == 0.0 ? (double)this.bot.getTime() - enemy.oscilTime : (enemy.avgOscilTime + ((double)this.bot.getTime() - enemy.oscilTime)) / 2.0;
                } else {
                    enemy.isOscilating = true;
                    enemy.avgOscilTime = 0.0;
                }
                enemy.oscilTime = this.bot.getTime();
            } else if ((double)this.bot.getTime() - enemy.oscilTime > 100.0) {
                enemy.isOscilating = false;
            }
            enemy.avgspeed = enemy.avgspeed == 0.0 ? Math.abs(enemy.speed) : (enemy.avgspeed + Math.abs(enemy.speed)) / 2.0;
        }
        enemy.distance = e.getDistance();
        enemy.energy = e.getEnergy();
        if (this.currentTarget == null) {
            this.currentTarget = enemy;
        }
    }

    public void killEnemy(RobotDeathEvent e) {
        Enemy enemy = (Enemy)this.enemies.get(e.getName());
        if (enemy != null) {
            enemy.distance = 100000.0;
            enemy.energy = -1.0;
            this.backUp.put(enemy.name, enemy);
            this.enemies.remove(enemy);
        }
        if (enemy == this.currentTarget) {
            this.currentTarget = null;
        }
    }

    public void refresh() {
        Enumeration e = this.enemies.elements();
        while (e.hasMoreElements()) {
            Enemy enemy = (Enemy)e.nextElement();
            ++enemy.danger;
            this.backUp.put(enemy.name, enemy);
        }
        this.enemies = this.backUp;
        this.backUp = new Hashtable();
    }

    public void selectNearestTarget() {
        Enumeration e = this.enemies.elements();
        Enemy target = this.currentTarget;
        while (e.hasMoreElements()) {
            Enemy enemy = (Enemy)e.nextElement();
            if (target != null && !(enemy.distance < target.distance)) continue;
            target = enemy;
        }
        this.currentTarget = target;
    }

    public void selectPowerestTarget() {
    }

    public void selectPowerLessTarget() {
    }

    public void selectTargetInNearestCorner() {
    }

    public int getNumEnemies(double x1, double y1, double x2, double y2) {
        double aux;
        int num = 0;
        if (x1 > x2) {
            aux = x1;
            x1 = x2;
            x2 = aux;
        }
        if (y1 > y2) {
            aux = y1;
            y1 = y2;
            y2 = aux;
        }
        Enumeration e = this.enemies.elements();
        while (e.hasMoreElements()) {
            Enemy enemy = (Enemy)e.nextElement();
            if (!(enemy.energy > -1.0) || !(enemy.x > x1) || !(enemy.x < x2) || !(enemy.y > y1) || !(enemy.y < y2)) continue;
            ++num;
        }
        return num;
    }

    public void calculateZonesStatistics(Vector zones) {
        int l = zones.size();
        Enumeration e = this.enemies.elements();
        while (e.hasMoreElements()) {
            Enemy enemy = (Enemy)e.nextElement();
            if (!(enemy.energy > -1.0)) continue;
            int i = 0;
            while (i < l) {
                Zone z = (Zone)zones.elementAt(i);
                if (z.isInZone(enemy.x, enemy.y)) {
                    z.bots.addElement(enemy);
                    z.energy += enemy.energy;
                }
                ++i;
            }
        }
    }
}

