/*
 * Decompiled with CFR 0.152.
 */
package xander.cat.group.mirror;

import xander.cat.group.mirror.AntiMirrorDrive;
import xander.cat.group.mirror.AntiMirrorTargeter;
import xander.cat.group.mirror.MirrorDetector;
import xander.cat.group.mirror.MirrorPlan;
import xander.cat.group.mirror.MirrorScenario;
import xander.core.ComponentChain;
import xander.core.Resources;
import xander.core.drive.OrbitalDrivePredictor;
import xander.core.gun.XanderGun;
import xander.core.gun.power.FixedPowerSelector;
import xander.paint.Paintables;

public class MirrorFactory {
    public static void addAntiMirrorComponents(ComponentChain componentChain, int scanDepth, int scannedTicks, int reversalTickRange) {
        MirrorPlan mirrorPlan = new MirrorPlan(Resources.getRobotEvents(), reversalTickRange);
        OrbitalDrivePredictor orbitalDrivePredictor = new OrbitalDrivePredictor();
        MirrorDetector mirrorDetector = new MirrorDetector(scanDepth, scannedTicks);
        MirrorScenario mirrorScenario = new MirrorScenario(mirrorDetector);
        AntiMirrorDrive antiMirrorDrive = new AntiMirrorDrive(mirrorPlan, orbitalDrivePredictor);
        FixedPowerSelector powerSelector = new FixedPowerSelector(1.95);
        powerSelector.setAllowAutoAdjust(false);
        AntiMirrorTargeter targeter = new AntiMirrorTargeter(mirrorPlan, mirrorDetector, orbitalDrivePredictor);
        XanderGun antiMirrorGun = new XanderGun(targeter, powerSelector);
        componentChain.addComponents(mirrorScenario, antiMirrorDrive, antiMirrorGun);
        Paintables.addPaintable(mirrorDetector);
    }
}

