/*
 * Decompiled with CFR 0.152.
 */
package xander.cat.group.ram;

import xander.core.Resources;
import xander.core.RobotProxy;
import xander.core.drive.Drive;
import xander.core.drive.DriveController;
import xander.core.math.Linear;
import xander.core.math.LinearIntercept;
import xander.core.math.RCMath;
import xander.core.track.Snapshot;

public class RamDrive
implements Drive {
    private RobotProxy robotProxy = Resources.getRobotProxy();

    @Override
    public String getName() {
        return "Ram Drive";
    }

    @Override
    public void onRoundBegin() {
    }

    @Override
    public void driveTo(Snapshot opponentSnapshot, DriveController driveController) {
        double directlyAtOpponent = RCMath.getRobocodeAngle(this.robotProxy.getX(), this.robotProxy.getY(), opponentSnapshot.getX(), opponentSnapshot.getY());
        LinearIntercept intercept = Linear.calculateTrajectory(opponentSnapshot, this.robotProxy.getX(), this.robotProxy.getY(), 8.1, this.robotProxy.getBattleFieldSize(), this.robotProxy.getTime());
        if (opponentSnapshot.getDistance() > 250.0 || intercept == null) {
            driveController.drive(directlyAtOpponent, 8.0);
        } else if (opponentSnapshot.getDistance() > 75.0) {
            double halfDiff = RCMath.getTurnAngle(directlyAtOpponent, intercept.getVelocityVector().getRoboAngle()) / 2.0;
            double blended = RCMath.normalizeDegrees(directlyAtOpponent + halfDiff);
            driveController.drive(blended, 8.0);
        } else {
            driveController.drive(intercept.getVelocityVector().getRoboAngle(), 8.0);
        }
    }

    @Override
    public void drive(DriveController driveController) {
    }
}

