/*
 * Decompiled with CFR 0.152.
 */
package xander.core.track;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import robocode.BulletHitBulletEvent;
import robocode.BulletHitEvent;
import robocode.BulletMissedEvent;
import robocode.HitByBulletEvent;
import robocode.HitRobotEvent;
import robocode.HitWallEvent;
import robocode.ScannedRobotEvent;
import xander.core.Configuration;
import xander.core.Resources;
import xander.core.RobotEvents;
import xander.core.event.BulletHitListener;
import xander.core.event.CollisionListener;
import xander.core.event.OpponentGunFiredEvent;
import xander.core.event.OpponentGunListener;
import xander.core.event.RoundBeginListener;
import xander.core.event.ScannedRobotListener;
import xander.core.log.Log;
import xander.core.log.Logger;
import xander.core.math.RCPhysics;
import xander.core.track.Snapshot;
import xander.core.track.SnapshotHistory;

public class OpponentGunWatcher
implements RoundBeginListener,
ScannedRobotListener,
BulletHitListener,
CollisionListener {
    private static final Log log = Logger.getLog(OpponentGunWatcher.class);
    private Map<String, Double> opponentEnergyMap = new HashMap<String, Double>();
    private Map<String, Long> opponentScanTimeMap = new HashMap<String, Long>();
    private String lastScannedOpponent = null;
    private List<OpponentGunListener> opponentGunListeners = new ArrayList<OpponentGunListener>();
    private SnapshotHistory snapshotHistory;
    private boolean logEnemyBulletFiredStats;
    private double previousAssumedGunEnergyDrop;
    private long previousAssumedGunEnergyDropDetectedTime;
    private ScannedRobotEvent previousEvent;
    private boolean collisionOnLastAssumedGunFire;

    public OpponentGunWatcher(SnapshotHistory snapshotHistory, Configuration configuration) {
        this.snapshotHistory = snapshotHistory;
        RobotEvents robotEvents = Resources.getRobotEvents();
        robotEvents.addCollisionListener(this);
        robotEvents.addScannedRobotListener(this);
        robotEvents.addBulletHitListener(this);
        robotEvents.addRoundBeginListener(this);
        this.logEnemyBulletFiredStats = configuration.isLogEnemyBulletFiredStats();
    }

    public void addOpponentGunListener(OpponentGunListener listener) {
        this.opponentGunListeners.add(listener);
    }

    @Override
    public void onRoundBegin() {
        this.opponentEnergyMap.clear();
        this.opponentScanTimeMap.clear();
        this.previousEvent = null;
        this.previousAssumedGunEnergyDrop = 0.0;
        this.previousAssumedGunEnergyDropDetectedTime = 0L;
    }

    @Override
    public void onScannedRobot(ScannedRobotEvent event) {
        String opponentName = event.getName();
        Double opponentEnergy = this.opponentEnergyMap.get(opponentName);
        Long lastOpponentScanTime = this.opponentScanTimeMap.get(opponentName);
        this.opponentScanTimeMap.put(opponentName, event.getTime());
        if (opponentEnergy == null || !opponentName.equals(this.lastScannedOpponent)) {
            this.opponentEnergyMap.put(opponentName, event.getEnergy());
        } else {
            double energyDrop = opponentEnergy - event.getEnergy();
            if (energyDrop != 0.0) {
                boolean collision;
                this.opponentEnergyMap.put(opponentName, event.getEnergy());
                long tslf = 0L;
                int tfc = 0;
                if (this.previousAssumedGunEnergyDrop > 0.0) {
                    tslf = event.getTime() - this.previousAssumedGunEnergyDropDetectedTime;
                    tfc = RCPhysics.getTimeUntilGunCool(this.previousAssumedGunEnergyDrop);
                }
                double decelRate = 0.0;
                if (this.previousEvent != null) {
                    decelRate = Math.abs(event.getVelocity() - this.previousEvent.getVelocity()) / (double)(event.getTime() - this.previousEvent.getTime());
                }
                boolean bl = collision = decelRate > 2.0;
                if ((tslf >= (long)tfc || this.collisionOnLastAssumedGunFire) && energyDrop > 0.0 && (energyDrop <= 3.0 || collision) && (energyDrop > 0.15 || tslf < 200L && tslf > 2L)) {
                    Snapshot mySnapshot;
                    if (collision && this.previousAssumedGunEnergyDrop > 0.0) {
                        energyDrop = this.previousAssumedGunEnergyDrop;
                    }
                    this.collisionOnLastAssumedGunFire = collision;
                    Snapshot snapshot = this.snapshotHistory.getSnapshot(opponentName, event.getTime() - 1L, false);
                    if (snapshot == null) {
                        snapshot = this.snapshotHistory.getSnapshot(opponentName);
                        log.warn("Desired enemy snapshot not available; using alternate snapshot from time " + snapshot.getTime());
                    }
                    if ((mySnapshot = this.snapshotHistory.getMySnapshot(event.getTime() - 2L, false)) == null) {
                        mySnapshot = this.snapshotHistory.getMySnapshot();
                        log.warn("My desired snapshot not available; using alternate snapshot from time " + mySnapshot.getTime());
                    }
                    OpponentGunFiredEvent ogfEvent = new OpponentGunFiredEvent(energyDrop, mySnapshot, snapshot, event.getTime(), event.getTime() - lastOpponentScanTime > 1L);
                    for (OpponentGunListener listener : this.opponentGunListeners) {
                        listener.opponentGunFired(ogfEvent);
                    }
                    if (this.logEnemyBulletFiredStats) {
                        log.stat("Enemy fired bullet at time " + snapshot.getTime() + " from position " + Logger.formatPosition(snapshot.getX(), snapshot.getY()));
                        log.stat("Enemy presumed to have scanned me at time " + mySnapshot.getTime());
                    }
                    this.previousAssumedGunEnergyDrop = energyDrop;
                    this.previousAssumedGunEnergyDropDetectedTime = event.getTime();
                }
            }
        }
        this.previousEvent = event;
        this.lastScannedOpponent = opponentName;
    }

    @Override
    public void onBulletHit(BulletHitEvent event) {
        String opponentName = event.getName();
        Double oppEnergy = this.opponentEnergyMap.get(opponentName);
        if (oppEnergy != null) {
            double bulletDamage = RCPhysics.getBulletDamage(event.getBullet().getPower());
            this.opponentEnergyMap.put(opponentName, oppEnergy - bulletDamage);
        } else {
            this.opponentEnergyMap.put(opponentName, event.getEnergy());
        }
    }

    @Override
    public void onBulletHitBullet(BulletHitBulletEvent event) {
    }

    @Override
    public void onBulletMissed(BulletMissedEvent event) {
    }

    @Override
    public void onHitByBullet(HitByBulletEvent event) {
        String opponentName = event.getName();
        Double opponentEnergy = this.opponentEnergyMap.get(opponentName);
        if (opponentEnergy != null) {
            double updatedEnergy = opponentEnergy + RCPhysics.getEnergyRegained(event.getPower());
            this.opponentEnergyMap.put(opponentName, updatedEnergy);
        }
    }

    @Override
    public void onHitRobot(HitRobotEvent event) {
        this.opponentEnergyMap.put(event.getName(), event.getEnergy());
    }

    @Override
    public void onHitWall(HitWallEvent event) {
    }
}

