/*
 * Decompiled with CFR 0.152.
 */
package catcat20.atom.move.surf;

import catcat20.atom.move.NonWaveMove;
import catcat20.atom.move.surf.models.quick.QuickModel;
import catcat20.atom.move.surf.path.Path;
import catcat20.atom.move.surf.path.PathPos;
import catcat20.atom.move.surf.plan.DuelPlan;
import catcat20.atom.move.surf.plan.MeleePlan;
import catcat20.atom.move.surf.plan.RamEscapePlan;
import catcat20.atom.move.surf.plan.SurfPlan;
import catcat20.atom.move.surf.plan.TronPlan;
import catcat20.atom.rader.AtomRader;
import catcat20.atom.robot.Bot;
import catcat20.atom.utils.HConstants;
import catcat20.atom.utils.HUtils;
import catcat20.atom.utils.Intersection;
import catcat20.atom.utils.MovementPredictor;
import catcat20.atom.utils.PreciseWallSmooth;
import catcat20.atom.utils.Wave;
import catcat20.atom.utils.knn.GFData;
import catcat20.atom.utils.knn.TreeGFData;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import robocode.AdvancedRobot;
import robocode.BulletHitBulletEvent;
import robocode.HitByBulletEvent;
import robocode.Rules;
import robocode.TeamRobot;
import robocode.util.Utils;

public class Surfing {
    public static boolean FLATTENER_ENABLE = true;
    public static boolean FLATTENER_ONLY_MODE = false;
    public static boolean GO_TO_MODE = true;
    public static double duelHitCount = 0.0;
    public static double duelFiredCount = 0.0;
    public static double meleeHitCount = 0.0;
    public static double meleeFiredCount = 0.0;
    public long pathTime;
    public long dangerTime;
    public int dangerCalled = 0;
    public int treeNodes = 0;
    public int cutNodes = 0;
    public double waveDangerSum = 0.0;
    public double waveDangerCount = 1.0;
    public double averageWaveDanger = 0.0;
    public double posDangerSum = 2.0;
    public double posDangerCount = 1.0;
    public double averagePosDanger = 0.0;
    public TeamRobot _robot;
    public int _others;
    public String _myName;
    public double _myEnergy;
    Point2D.Double _centerPos;
    public Point2D.Double _myPos;
    public long _time;
    public ArrayList<Wave> _waves;
    public ArrayList<Wave> _tickWaves;
    public static int WALL_STICK = 160;
    public static int MAX_SURF = 3;
    public static final int BACK_AMOUNT_LOG = 1;
    public boolean paint = false;
    public boolean oldPaint = false;
    public TronPlan tronPlan = new TronPlan();
    public DuelPlan duelPlan = new DuelPlan();
    public MeleePlan meleePlan = new MeleePlan();
    public RamEscapePlan ramEscapePlan = new RamEscapePlan();
    public SurfPlan currentPlanner;
    public NonWaveMove nonWaveMove;
    public static Point2D.Double nextLocation;
    public int waveCount = 0;
    public final Color[] colors = new Color[]{Color.red, Color.orange, Color.yellow, Color.green, Color.cyan, Color.blue, Color.magenta, Color.pink};
    BasicStroke bs = new BasicStroke(1.5f);

    public Surfing(TeamRobot robot) {
        this._robot = robot;
        this.nonWaveMove = new NonWaveMove(robot);
    }

    public Color waveColor() {
        ++this.waveCount;
        if (this.waveCount >= this.colors.length) {
            this.waveCount = 0;
        }
        return this.colors[this.waveCount];
    }

    public void init() {
        this._waves = new ArrayList();
        this._tickWaves = new ArrayList();
    }

    public void onTick() {
        this.pathTime = 0L;
        this.dangerTime = 0L;
        this.dangerCalled = 0;
        this.treeNodes = 0;
        this.cutNodes = 0;
        nextLocation = new Point2D.Double(this._robot.getX(), this._robot.getY());
        this._others = this._robot.getOthers();
        this._centerPos = new Point2D.Double(HConstants.fieldWidth / 2.0, HConstants.fieldHeight / 2.0);
        this.averageWaveDanger = this.waveDangerSum / this.waveDangerCount;
        this.averagePosDanger = this.posDangerSum / this.posDangerCount;
        this.waveDangerSum = 0.0;
        this.waveDangerCount = 0.0;
        this.posDangerSum = 0.0;
        this.posDangerCount = 0.0;
        this._time = this._robot.getTime();
        this._myName = this._robot.getName();
        this._myEnergy = this._robot.getEnergy();
        this._myPos = new Point2D.Double(this._robot.getX(), this._robot.getY());
        if (this._robot.getOthers() <= 1) {
            this.currentPlanner = this.duelPlan;
            if (AtomRader.nearestBot != null && AtomRader.nearestBot.currentState != null && AtomRader.nearestBot.currentState.getEnergy() > 0.0 && (this._waves.isEmpty() || AtomRader.nearestBot.currentState.getPosition().distance(this._myPos) <= 200.0)) {
                this.currentPlanner = this.ramEscapePlan;
            }
            MAX_SURF = 2;
            GO_TO_MODE = false;
        } else {
            this.currentPlanner = this.meleePlan;
            MAX_SURF = 3;
            GO_TO_MODE = false;
        }
        long time = this._robot.getTime();
        int others = this._robot.getOthers();
        for (Bot bot : AtomRader.enemies.values()) {
            Wave w;
            double energyDrop;
            if (this._robot.isTeammate(bot.name) || !bot.alive || bot.botStateLogs.size() < 2) continue;
            Wave tickWave = this.makeWave(bot, bot.predictNextPower(this._robot, 1.95), (long)((double)(bot.lastScanTime + time) / 2.0) - 2L);
            if (bot.lastSurfTickWave != null) {
                bot.lastSurfTickWave.tickNext = tickWave;
                tickWave.tickBack = bot.lastSurfTickWave;
            }
            bot.lastSurfTickWave = tickWave;
            if (this._others <= 1) {
                this._tickWaves.add(tickWave);
            }
            if ((energyDrop = bot.botStateLogs.get(1).getEnergy() - bot.currentState.getEnergy()) > 0.0 && energyDrop <= 3.01 && bot.gunHeat <= 0.2) {
                bot.gunHeat = Rules.getGunHeat((double)energyDrop) - HConstants.GUN_COOLING_RATE * 2.0;
                if (others > 1 && !bot.canFire) continue;
                if (others <= 1) {
                    duelFiredCount += 1.0;
                } else {
                    meleeFiredCount += 1.0;
                }
                bot.duelFireCount += 1.0;
                bot.canFire = false;
                w = this.makeWave(bot, energyDrop, (long)((double)(bot.lastScanTime + time) / 2.0) - 2L);
                if (tickWave != null && tickWave.tickBack != null) {
                    w.tickBack = tickWave.tickBack;
                    w.thisTickWave = tickWave;
                }
                if (bot.lastSurfWave != null) {
                    bot.lastSurfWave.next = w;
                    w.back = bot.lastSurfWave;
                }
                bot.lastSurfWave = w;
                this._waves.add(w);
                continue;
            }
            if (!((double)this._time > 2.7 / HConstants.GUN_COOLING_RATE) || !(bot.currentState.getPosition().distance(this._myPos) < 200.0) || !(bot.currentState.getEnergy() > 0.0)) continue;
            w = this.makeWave(bot, HUtils.bulletPowerFromVelocity(8.0), (long)((double)(bot.lastScanTime + time) / 2.0) - 2L);
            w.rammerWave = true;
            this._waves.add(w);
        }
        this.updateTickWaves();
        this.updateWaves();
        this.doSurfing();
        this.paint = true;
    }

    public Wave makeWave(Bot bot, double bulletPower, long fireTime) {
        Wave w = new Wave(bot.botStateLogs.get(1).getPosition());
        w.fireTime = fireTime;
        w.bulletPower = bulletPower;
        w.directAngle = HUtils.absoluteBearing(bot.botStateLogs.get(1).getPosition(), AtomRader.oldMyStates.get(1).getPosition());
        w.enName = bot.name;
        w.isMeleeWave = this._others > 1;
        w.enState = bot.botStateLogs.get(1);
        w.myState = AtomRader.oldMyStates.get(1);
        w.prevMyState = AtomRader.oldMyStates.get(2);
        w.direction = HUtils.sign(bot.botStateLogs.get((int)1).myLatVel);
        w.myLatVel = bot.botStateLogs.get((int)1).myLatVel;
        w.myDirChangeTime = bot.myDirChangeTime;
        w.myDist10 = AtomRader.oldMyStates.get(1).getPosition().distance(AtomRader.oldMyStates.get(Math.min(11, AtomRader.oldMyStates.size() - 1)).getPosition());
        w.myDist16 = AtomRader.oldMyStates.get(1).getPosition().distance(AtomRader.oldMyStates.get(Math.min(17, AtomRader.oldMyStates.size() - 1)).getPosition());
        w.myDist30 = AtomRader.oldMyStates.get(1).getPosition().distance(AtomRader.oldMyStates.get(Math.min(31, AtomRader.oldMyStates.size() - 1)).getPosition());
        w.myDist60 = AtomRader.oldMyStates.get(1).getPosition().distance(AtomRader.oldMyStates.get(Math.min(61, AtomRader.oldMyStates.size() - 1)).getPosition());
        w.myDist120 = AtomRader.oldMyStates.get(1).getPosition().distance(AtomRader.oldMyStates.get(Math.min(121, AtomRader.oldMyStates.size() - 1)).getPosition());
        w.currentGF = bot.currentGF;
        w.color = this.waveColor();
        return w;
    }

    public void doSurfing() {
        Graphics2D g = this._robot.getGraphics();
        Wave surfWave = this.getClosestSurfableWave(this._waves, this._myPos);
        if (surfWave == null) {
            this.nonWaveMove.onTick();
        } else {
            RiskSet bestRiskSet = null;
            Path bestPath = null;
            PathPos bestPathPos = null;
            double bestRisk = Double.POSITIVE_INFINITY;
            ArrayList<Path> paths = null;
            MovementPredictor.PredictionStatus status = new MovementPredictor.PredictionStatus(this._myPos.x, this._myPos.y, this._robot.getHeadingRadians(), this._robot.getVelocity(), this._robot.getTime());
            long then = System.nanoTime();
            paths = this.currentPlanner.generatePath(status, surfWave);
            long millis = TimeUnit.NANOSECONDS.toMicros(System.nanoTime() - then);
            this.pathTime += millis;
            int depth = Math.min(MAX_SURF, this._waves.size());
            ArrayList<Wave> surfWaves = new ArrayList<Wave>();
            ArrayList wavesBin = (ArrayList)this._waves.clone();
            for (int i = 0; i < depth; ++i) {
                Wave w = this.getClosestSurfableWave(wavesBin, this._myPos);
                wavesBin.remove(w);
                surfWaves.add((Wave)w.clone());
            }
            double beforeMin = Double.POSITIVE_INFINITY;
            ArrayList<RiskSet> riskSetList = new ArrayList<RiskSet>();
            for (Path path : paths) {
                double risk = 0.0;
                if (GO_TO_MODE) {
                    for (PathPos dest : path.path) {
                        Path destPath;
                        int index = path.path.indexOf(dest);
                        if (index == 0) continue;
                        RiskSet result = this.dangerTree(surfWave, dest.status, surfWaves, -1, Double.POSITIVE_INFINITY);
                        risk = result.risk;
                        result.path = destPath = new Path(new ArrayList<PathPos>(path.path.subList(0, index)));
                        riskSetList.add(result);
                    }
                    continue;
                }
                PathPos dest = path.path.get(Math.max(0, path.path.size() - 1));
                RiskSet result = this.dangerTree(surfWave, dest.status, surfWaves, -1, Double.POSITIVE_INFINITY);
                risk = result.risk;
                result.path = path;
                riskSetList.add(result);
            }
            Collections.sort(riskSetList);
            Collections.reverse(riskSetList);
            for (RiskSet riskSet : riskSetList) {
                PathPos dest;
                Path path = riskSet.path;
                if (bestPath != null && bestRisk < riskSet.risk) {
                    ++this.cutNodes;
                    continue;
                }
                double risk = 0.0;
                dest = path.path.get(Math.max(0, path.path.size() - 1));
                RiskSet result = this.dangerTree(surfWave, dest.status, surfWaves, depth, Double.POSITIVE_INFINITY);
                risk = result.risk;
                if (risk < bestRisk) {
                    bestRiskSet = result;
                    bestPath = path;
                    bestRisk = risk;
                    bestPathPos = dest;
                }
                if (!this.paint) continue;
                g.setColor(Color.white);
                g.drawRect((int)(dest.x - 2.0), (int)(dest.y - 2.0), 4, 4);
                for (int i = 0; i < path.path.size(); ++i) {
                    PathPos pos = path.path.get(i);
                    g.setColor(Color.white);
                    g.drawRect((int)(pos.x - 2.0), (int)(pos.y - 2.0), 4, 4);
                }
            }
            if (this.paint && bestRiskSet != null) {
                int rectSize = 9;
                Stroke cache = g.getStroke();
                g.setStroke(this.bs);
                Point2D.Double lastPos = this._myPos;
                PathPos dest = bestPath.path.get(Math.max(0, bestPath.path.size() - 1));
                for (PathPos pos : bestPath.path) {
                    g.setColor(Color.cyan);
                    if (pos.pathColor != null) {
                        g.setColor(pos.pathColor);
                    }
                    g.drawLine((int)lastPos.x, (int)lastPos.y, (int)pos.x, (int)pos.y);
                    lastPos = pos;
                }
                if (this._others <= 1) {
                    g.drawRect((int)(dest.x - (double)rectSize), (int)(dest.y - (double)rectSize), rectSize * 2, rectSize * 2);
                }
                RiskSet riskSet = bestRiskSet;
                while (riskSet.deeper != null) {
                    for (PathPos pos : riskSet.path.path) {
                        g.setColor(Color.white);
                        if (pos.pathColor != null) {
                            g.setColor(pos.pathColor);
                        }
                        g.drawLine((int)lastPos.x, (int)lastPos.y, (int)pos.x, (int)pos.y);
                        lastPos = pos;
                    }
                    dest = riskSet.path.path.get(Math.max(0, riskSet.path.path.size() - 1));
                    if (this._others <= 1) {
                        g.drawRect((int)(dest.x - (double)rectSize), (int)(dest.y - (double)rectSize), rectSize * 2, rectSize * 2);
                    }
                    riskSet = riskSet.deeper;
                }
                g.setStroke(cache);
            }
            if (bestPathPos != null) {
                double ran = Math.random() / 1.0E12;
                bestPathPos = bestPath.path.get(Math.min(0, bestPath.path.size() - 1));
                if (bestPathPos.maxVelocity > 7.9) {
                    this._robot.setMaxVelocity(8.0 - ran);
                } else if (bestPathPos.maxVelocity < 1.0) {
                    this._robot.setMaxVelocity(ran);
                } else {
                    this._robot.setMaxVelocity(bestPathPos.maxVelocity - ran);
                }
                double absBearing = 0.0;
                if (this.currentPlanner instanceof DuelPlan || this.currentPlanner instanceof RamEscapePlan) {
                    absBearing = bestPath.path.get((int)Math.min((int)(bestPath.path.size() - 1), (int)1)).goHeading;
                    absBearing = this.wallSmoothing(this._myPos.x, this._myPos.y, absBearing, bestPathPos.status.direction, 1);
                    absBearing = this.wallSmoothing(this._myPos, absBearing, bestPathPos.status.direction);
                } else {
                    absBearing = HUtils.absoluteBearing(this._myPos, bestPath.path.get((int)Math.max((int)0, (int)(bestPath.path.size() - 1))).status);
                    absBearing = this.meleeWallSmoothing(this._myPos, absBearing, 1);
                    PreciseWallSmooth.Trig trig = new PreciseWallSmooth.Trig();
                    trig.sin = Math.sin(this._robot.getHeadingRadians());
                    trig.cos = Math.cos(this._robot.getHeadingRadians());
                    absBearing = HConstants.preciseWallSmooth.smoothHeading(absBearing, trig, this._myPos.x, this._myPos.y, HUtils.sign(this._robot.getVelocity()));
                }
                Surfing.setBackAsFront((AdvancedRobot)this._robot, absBearing);
                nextLocation.setLocation(HUtils.project(this._myPos, absBearing, HUtils.limit(0.0, bestPathPos.status.velocity, bestPathPos.maxVelocity)));
                Point2D.Double drawPos = HUtils.project(this._myPos, absBearing, 100.0);
                g.setColor(Color.magenta);
                g.drawLine((int)this._myPos.x, (int)this._myPos.y, (int)drawPos.x, (int)drawPos.y);
                if (bestPathPos.maxVelocity < 1.0) {
                    this._robot.setAhead((double)(100 * HUtils.sign(Math.random() - 0.5)));
                }
            }
        }
    }

    public double wallSmoothing(Point2D.Double botLocation, double angle, int orientation) {
        while (!HConstants.safeField.contains(HUtils.project(botLocation, angle, WALL_STICK))) {
            angle += (double)orientation * 0.05 * 2.0;
        }
        return angle;
    }

    private void goTo(double x, double y) {
        double angleToTarget = Math.atan2(x -= this._robot.getX(), y -= this._robot.getY());
        double targetAngle = Utils.normalRelativeAngle((double)(angleToTarget - this._robot.getHeadingRadians()));
        double distance = Math.hypot(x, y);
        double turnAngle = Math.atan(Math.tan(targetAngle));
        this._robot.setTurnRightRadians(turnAngle);
        if (targetAngle == turnAngle) {
            this._robot.setAhead(distance);
        } else {
            this._robot.setBack(distance);
        }
    }

    public double meleeWallSmoothing(Point2D.Double botLocation, double angle, int orientation) {
        double count = 1.0;
        double step = 0.0;
        double v = Math.toRadians(2.5);
        while (!HConstants.safeField.contains(HUtils.project(botLocation, angle, 200.0))) {
            count = -Math.signum(count) * (step += v);
            angle += (double)orientation * count;
        }
        return angle;
    }

    public double wallSmoothing(double x, double y, double startAngle, int orientation, int smoothTowardEnemy) {
        double angle = startAngle;
        double testX = x + Math.sin(angle += Math.PI * 4) * (double)WALL_STICK;
        double testY = y + Math.cos(angle) * (double)WALL_STICK;
        double extra = 18.5;
        double wallDistanceX = Math.min(x - extra, HConstants.fieldWidth - x - extra);
        double wallDistanceY = Math.min(y - extra, HConstants.fieldHeight - y - extra);
        double testDistanceX = Math.min(testX - extra, HConstants.fieldWidth - testX - extra);
        double testDistanceY = Math.min(testY - extra, HConstants.fieldHeight - testY - extra);
        double adjacent = 0.0;
        int g = 0;
        while (!HConstants.safeField.contains(testX, testY) && g++ < 25) {
            if (testDistanceY < 0.0 && testDistanceY < testDistanceX) {
                angle = (double)((int)((angle + 1.5707963267948966) / Math.PI)) * Math.PI;
                adjacent = Math.abs(wallDistanceY);
            } else if (testDistanceX < 0.0 && testDistanceX <= testDistanceY) {
                angle = (double)((int)(angle / Math.PI)) * Math.PI + 1.5707963267948966;
                adjacent = Math.abs(wallDistanceX);
            }
            testX = x + Math.sin(angle += (double)(smoothTowardEnemy * orientation) * (Math.abs(Math.acos(adjacent / (double)WALL_STICK)) + 0.005)) * (double)WALL_STICK;
            testY = y + Math.cos(angle) * (double)WALL_STICK;
            testDistanceX = Math.min(testX - extra, HConstants.fieldWidth - testX - extra);
            testDistanceY = Math.min(testY - extra, HConstants.fieldHeight - testY - extra);
            if (smoothTowardEnemy != -1) continue;
        }
        return angle;
    }

    public static void setBackAsFront(AdvancedRobot robot, double goAngle) {
        double angle = Utils.normalRelativeAngle((double)(goAngle - robot.getHeadingRadians()));
        if (Math.abs(angle) > 1.5707963267948966) {
            if (angle < 0.0) {
                robot.setTurnRightRadians(Math.PI + angle);
            } else {
                robot.setTurnLeftRadians(Math.PI - angle);
            }
            robot.setBack(100.0);
        } else {
            if (angle < 0.0) {
                robot.setTurnLeftRadians(-1.0 * angle);
            } else {
                robot.setTurnRightRadians(angle);
            }
            robot.setAhead(100.0);
        }
    }

    public RiskSet dangerTree(Wave surfWave, MovementPredictor.PredictionStatus status, ArrayList<Wave> waves, int depth, double min) {
        ++this.treeNodes;
        double bandwidth = 36.0 / status.distance(surfWave);
        Intersection intersection = new Intersection(HUtils.absoluteBearing(surfWave, status), bandwidth);
        intersection.status = status;
        double risk = 0.0;
        double waveRisk = this.getDangerScore(surfWave, intersection);
        if (AtomRader.getBot((String)surfWave.enName).nearestBotName.equals(this._myName)) {
            waveRisk *= 3.0;
        }
        this.waveDangerSum += waveRisk;
        this.waveDangerCount += 1.0;
        double posRisk = this.getBotRisk(status);
        this.posDangerCount += 1.0;
        this.posDangerSum += posRisk;
        if (!surfWave.isMeleeWave) {
            posRisk /= 5.0;
            if (Double.isNaN(posRisk *= 0.0)) {
                posRisk = 0.0;
            }
            risk += posRisk / this.averagePosDanger + waveRisk / this.averageWaveDanger;
        } else {
            double posWeight = HUtils.limit(1.0E-5, (double)(this._others - 1), 5.0);
            double waveWeight = this._others * 2 + 1;
            risk += posWeight * posRisk / this.averagePosDanger + waveWeight * waveRisk / this.averageWaveDanger;
        }
        double currentDistanceToWaveSource = status.distance(surfWave);
        double currentDistanceToWave = currentDistanceToWaveSource - surfWave.distanceTraveled;
        double timeToImpact = Math.max(1.0, currentDistanceToWave / surfWave.bulletVelocity());
        risk /= timeToImpact;
        RiskSet bestSecondRiskSet = null;
        Path bestSecondPath = null;
        if (depth > 0 && waves.size() > 1) {
            double addDistance = status.distance(surfWave) - surfWave.distanceTraveled + surfWave.bulletVelocity();
            waves.remove(surfWave);
            for (Wave w : waves) {
                w.distanceTraveled += addDistance;
            }
            Wave secondWave = this.getClosestSurfableWave(waves, status);
            if (secondWave != null) {
                long then = System.nanoTime();
                ArrayList<Path> paths = this.currentPlanner.generatePath(status, secondWave);
                long millis = TimeUnit.NANOSECONDS.toMicros(System.nanoTime() - then);
                this.pathTime += millis;
                double bestSecondRisk = Double.POSITIVE_INFINITY;
                if (depth > 0) {
                    ArrayList<RiskSet> riskSetList = new ArrayList<RiskSet>();
                    for (Path path : paths) {
                        PathPos dest = path.path.get(Math.max(0, path.path.size() - 1));
                        RiskSet result = this.dangerTree(secondWave, dest.status, waves, -1, Double.POSITIVE_INFINITY);
                        result.path = path;
                        riskSetList.add(result);
                    }
                    Collections.sort(riskSetList);
                    Collections.reverse(riskSetList);
                    for (RiskSet riskSet : riskSetList) {
                        Path path = riskSet.path;
                        if (bestSecondPath != null && risk + bestSecondRisk < risk + riskSet.risk) {
                            ++this.cutNodes;
                            continue;
                        }
                        PathPos dest = path.path.get(Math.max(0, path.path.size() - 1));
                        RiskSet res = this.dangerTree(secondWave, dest.status, waves, depth - 1, min);
                        double secondRisk = res.risk;
                        min = Math.min(min, risk);
                        if (!(secondRisk < bestSecondRisk)) continue;
                        bestSecondPath = path;
                        bestSecondRisk = secondRisk;
                        bestSecondRiskSet = res;
                    }
                } else {
                    for (Path path : paths) {
                        PathPos dest = path.path.get(Math.max(0, path.path.size() - 1));
                        RiskSet res = this.dangerTree(secondWave, dest.status, waves, depth - 1, min);
                        double secondRisk = res.risk;
                        min = Math.min(min, risk);
                        if (!(secondRisk < bestSecondRisk)) continue;
                        bestSecondPath = path;
                        bestSecondRisk = secondRisk;
                        bestSecondRiskSet = res;
                    }
                }
                risk += bestSecondRisk;
            }
            for (Wave w : waves) {
                w.distanceTraveled -= addDistance;
            }
            waves.add(surfWave);
        }
        RiskSet riskSet = new RiskSet(bestSecondPath, risk);
        riskSet.deeper = bestSecondRiskSet;
        return riskSet;
    }

    double getBotRisk(MovementPredictor.PredictionStatus status) {
        double risk = 0.0;
        for (Bot bot : AtomRader.enemies.values()) {
            if (!bot.alive) continue;
            double energyRatio = Math.min((bot.currentState.getEnergy() - 1.0) / this._myEnergy, 2.0);
            double distance = bot.currentState.getPosition().distance(status);
            double p = 1.0 + Math.abs(Math.cos(status.heading - HUtils.absoluteBearing(bot.currentState.getPosition(), status)));
            if (this._others > 1) {
                risk += energyRatio / (distance * distance);
                continue;
            }
            risk += energyRatio / distance * distance;
        }
        return risk;
    }

    double getDangerScore(Wave w, Intersection intersection) {
        long then = System.nanoTime();
        double dangerAngle = intersection.angle;
        double bandwidth = intersection.bandwidth;
        double totalDanger = 0.0;
        double totalScanWeight = 0.0;
        int enabledSize = 0;
        for (TreeGFData nearestNeighbors : w.nearestNeighbors) {
            enabledSize += nearestNeighbors.nearestNeighbors.size();
            double density = 0.0;
            double viewScanWeight = 0.0;
            for (GFData gfData : nearestNeighbors.nearestNeighbors) {
                double decayWeight = 1.0 / Math.pow(gfData.decayRate, w.fireTime - gfData.time);
                double scanWeight = gfData.weight * gfData.treeWeight * decayWeight / Math.sqrt(gfData.distance + 1.0);
                double xFiringAngle = HUtils.normalizeAngle(w.firingAngle(gfData.guessFactor), dangerAngle);
                double ux = (xFiringAngle - dangerAngle) / bandwidth;
                density += scanWeight * Math.exp(-0.5 * (ux * ux));
                viewScanWeight += scanWeight;
            }
            totalScanWeight += viewScanWeight;
            totalDanger += density;
        }
        long millis = TimeUnit.NANOSECONDS.toMicros(System.nanoTime() - then);
        this.dangerTime += millis;
        ++this.dangerCalled;
        if (enabledSize == 0) {
            return Rules.getBulletDamage((double)w.bulletPower) * Surfing.defaultDanger(w, intersection);
        }
        return Rules.getBulletDamage((double)w.bulletPower) * totalDanger / totalScanWeight;
    }

    private static double defaultDanger(Wave w, Intersection intersection) {
        double danger = 0.0;
        Bot bot = AtomRader.getBot(w.enName);
        for (int i = 0; i < w.quickOffsets.size(); ++i) {
            double gf = w.quickOffsets.get(i) / HUtils.maxEscapeAngle(w.bulletVelocity());
            double firingAngle = w.directAngle + gf * HUtils.maxEscapeAngle(w.bulletVelocity());
            double ux = (firingAngle - HUtils.normalizeAngle(intersection.angle, firingAngle)) / intersection.bandwidth;
            danger += w.quickWeights.get(i) * Math.pow(w.quickPows.get(i), -Math.abs(ux));
        }
        return danger;
    }

    public void updateWaves() {
        long time = this._robot.getTime();
        int others = this._robot.getOthers();
        for (int x = 0; x < this._waves.size(); ++x) {
            Wave ew = this._waves.get(x);
            Bot bot = AtomRader.enemies.get(ew.enName);
            ++ew.ramTimeCount;
            ew.distanceTraveled = (double)(time - ew.fireTime) * ew.bulletVelocity();
            if (ew.distanceTraveled > this._myPos.distance(ew) + ew.bulletVelocity() * 3.0) {
                if (ew.isMeleeWave) {
                    // empty if block
                }
                AtomRader.currentMyState.currentGF = ew.guessFactor(AtomRader.currentMyState.getPosition());
                this._waves.remove(x);
                --x;
                continue;
            }
            if (ew.rammerWave && ew.ramTimeCount > 1) {
                this._waves.remove(x);
                --x;
                continue;
            }
            boolean empty = true;
            if (ew.nearestNeighbors != null) {
                for (TreeGFData gfData : ew.nearestNeighbors) {
                    if (gfData.nearestNeighbors.isEmpty()) continue;
                    empty = false;
                    break;
                }
            }
            if (ew.nearestNeighbors != null && !ew.nearestNeighbors.isEmpty() && !empty) continue;
            this.updateNearestNeighbors(ew);
        }
    }

    public void updateNearestNeighbors(Wave ew) {
        Bot bot = AtomRader.getBot(ew.enName);
        if (this._others <= 1) {
            if (FLATTENER_ONLY_MODE) {
                ew.nearestNeighbors = bot.getNearestNeighborsList(ew, bot.surfFlattenerModels);
            } else {
                ew.nearestNeighbors = bot.getNearestNeighborsList(ew, bot.surfModels);
                if (FLATTENER_ENABLE && bot.flattenerEnable) {
                    ew.nearestNeighbors.addAll(bot.getNearestNeighborsList(ew, bot.surfFlattenerModels));
                }
            }
        } else {
            ew.nearestNeighbors = bot.getNearestNeighborsList(ew, bot.meleeSurfModels);
        }
        ew.quickOffsets = new ArrayList();
        ew.quickWeights = new ArrayList();
        ew.quickPows = new ArrayList();
        for (QuickModel model : bot.quickModels) {
            ew.quickOffsets.add(model.offset(ew, ew.myState.getPosition(), ew.myState.getVelocity(), ew.myState.getHeading()));
            ew.quickWeights.add(model.weight);
            ew.quickPows.add(model.pow);
        }
    }

    public void updateTickWaves() {
        long time = this._robot.getTime();
        int others = this._robot.getOthers();
        for (int x = 0; x < this._tickWaves.size(); ++x) {
            Wave ew = this._tickWaves.get(x);
            Bot bot = AtomRader.enemies.get(ew.enName);
            ++ew.ramTimeCount;
            ew.distanceTraveled = (double)(time - ew.fireTime) * ew.bulletVelocity();
            if (ew.distanceTraveled > this._myPos.distance(ew) + ew.bulletVelocity() * 2.0) {
                bot.currentGF = ew.guessFactor(this._myPos);
                if (!ew.isMeleeWave) {
                    GFData data = new GFData();
                    data.guessFactor = ew.guessFactor(this._myPos);
                    data.weight = 1.0;
                    data.treeWeight = 1.0;
                    data.time = time;
                    if (!ew.isMeleeWave) {
                        bot.addData(ew, data, bot.surfFlattenerModels);
                    }
                }
                AtomRader.currentMyState.currentGF = ew.guessFactor(AtomRader.currentMyState.getPosition());
                this._tickWaves.remove(x);
                --x;
                continue;
            }
            if (!ew.rammerWave || ew.ramTimeCount <= 1) continue;
            this._tickWaves.remove(x);
            --x;
        }
    }

    public Wave getClosestSurfableWave(ArrayList<Wave> waves, Point2D.Double pos) {
        double closestDistance = Double.POSITIVE_INFINITY;
        Wave surfWave = null;
        if (waves.isEmpty()) {
            return null;
        }
        if (waves.size() == 1) {
            return waves.get(0);
        }
        for (Wave ew : waves) {
            double distance;
            if (surfWave == null) {
                surfWave = ew;
            }
            if (!((distance = (pos.distance(ew) - ew.distanceTraveled) / ew.bulletVelocity()) > -ew.bulletVelocity()) || !(distance < closestDistance)) continue;
            surfWave = ew;
            closestDistance = distance;
        }
        return surfWave;
    }

    public void logHit(Wave ew, Point2D.Double targetLocation) {
        long time = this._robot.getTime();
        Bot bot = AtomRader.getBot(ew.enName);
        GFData data = new GFData();
        data.guessFactor = ew.guessFactor(targetLocation);
        data.weight = 1.0;
        data.treeWeight = 1.0;
        data.time = time;
        if (ew.isMeleeWave) {
            bot.addData(ew, data, bot.meleeSurfModels);
        } else {
            bot.addData(ew, data, bot.surfModels);
            bot.addData(ew, data, bot.surfFlattenerModels);
        }
        if (this._others <= 1) {
            for (Wave w : this._waves) {
                w.nearestNeighbors = null;
                this.updateNearestNeighbors(w);
            }
        }
    }

    public void onRoundEnded() {
        System.out.println();
        System.out.println("***** surfing *****");
        System.out.println("duel hit rate: " + 100.0 * (duelHitCount / duelFiredCount) + "%");
        System.out.println("melee hit rate: " + 100.0 * (meleeHitCount / meleeFiredCount) + "%");
        System.out.println();
    }

    public void onHitByBullet(HitByBulletEvent e) {
        Bot bot = AtomRader.getBot(e.getName());
        if (bot != null && bot.alive && bot.botStateLogs.size() > 2) {
            bot.botStateLogs.get(0).setEnergy(bot.botStateLogs.get(0).getEnergy() + Rules.getBulletHitBonus((double)e.getBullet().getPower()));
            bot.botStateLogs.get(1).setEnergy(bot.botStateLogs.get(1).getEnergy() + Rules.getBulletHitBonus((double)e.getBullet().getPower()));
            if (this._robot.getOthers() <= 1) {
                bot.myDuelHitCount += 1.0;
            }
        }
        if (this._robot.getOthers() <= 1) {
            duelHitCount += 1.0;
        } else {
            meleeHitCount += 1.0;
        }
        if (!this._waves.isEmpty()) {
            Point2D.Double hitBulletLocation = new Point2D.Double(e.getBullet().getX(), e.getBullet().getY());
            Wave hitWave = null;
            Wave nearestWave = null;
            double bestDist = Double.POSITIVE_INFINITY;
            for (int x = 0; x < this._waves.size(); ++x) {
                Wave ew = this._waves.get(x);
                if (Math.abs(ew.distanceTraveled - hitBulletLocation.distance(ew)) < 50.0 && Math.abs(Rules.getBulletSpeed((double)e.getBullet().getPower()) - ew.bulletVelocity()) < 0.001 && Objects.equals(e.getBullet().getName(), ew.enName)) {
                    hitWave = ew;
                    break;
                }
                if (!(this._myPos.distance(ew) - ew.distanceTraveled < bestDist)) continue;
                nearestWave = ew;
                bestDist = this._myPos.distance(ew) - ew.distanceTraveled;
            }
            if (hitWave != null) {
                this.logHit(hitWave, hitBulletLocation);
            } else if (nearestWave != null) {
                this.logHit(nearestWave, hitBulletLocation);
                System.out.println("\"onHitByBullet\" to log the nearest Wave instead.");
            }
        }
    }

    public void onBulletHitBullet(BulletHitBulletEvent e) {
        if (!this._waves.isEmpty()) {
            Point2D.Double hitBulletLocation = new Point2D.Double(e.getBullet().getX(), e.getBullet().getY());
            Wave hitWave = null;
            Wave nearestWave = null;
            double bestDist = Double.POSITIVE_INFINITY;
            double bestScore = Double.POSITIVE_INFINITY;
            for (int x = 0; x < this._waves.size(); ++x) {
                Wave ew = this._waves.get(x);
                if (Math.abs(ew.distanceTraveled - hitBulletLocation.distance(ew)) < bestScore && e.getHitBullet().getName().equals(ew.enName)) {
                    hitWave = ew;
                    bestScore = Math.abs(ew.distanceTraveled - hitBulletLocation.distance(ew));
                }
                if (!(this._myPos.distance(ew) - ew.distanceTraveled < bestDist)) continue;
                nearestWave = ew;
                bestDist = this._myPos.distance(ew) - ew.distanceTraveled;
            }
            if (hitWave != null) {
                this.logHit(hitWave, hitBulletLocation);
            } else if (nearestWave != null) {
                this.logHit(nearestWave, hitBulletLocation);
                System.out.println("\"onBulletHitBullet\" to log the nearest Wave instead.");
            }
        }
    }

    public void onPaint(Graphics2D g) {
        this.oldPaint = this.paint;
        this.paint = true;
        g.setColor(Color.white);
        if (AtomRader.nearestBot != null && AtomRader.nearestBot.currentState != null) {
            g.drawString("distance:" + AtomRader.nearestBot.currentState.getPosition().distance(this._myPos), 30, 30);
        }
        g.drawString("path time:" + this.pathTime + " us", 30, 50);
        g.drawString("danger time:" + this.dangerTime + " us", 30, 70);
        g.drawString("danger called:" + this.dangerCalled, 30, 90);
        g.drawString("nodes:" + this.treeNodes, 30, 110);
        g.drawString("cutNodes:" + this.cutNodes, 30, 130);
        int numBins = 51;
        if (this._robot.getOthers() <= 1) {
            numBins = 101;
        }
        double halfBins = (double)(numBins - 1) / 2.0;
        double[] gfDangers = new double[numBins];
        double[] gfShadowed = new double[numBins];
        double vel = this._robot.getVelocity();
        double heading = this._robot.getHeadingRadians();
        Point2D.Double dangerLocation = new Point2D.Double();
        Point2D.Double oldDrawLocation = new Point2D.Double();
        Point2D.Double drawLocation = new Point2D.Double();
        Point2D.Double lengthLocation = new Point2D.Double();
        Point2D.Double drawLocationBuffer = null;
        for (Wave enemyWave : this._waves) {
            double bearingOffset;
            double gf;
            int x;
            g.setColor(Color.red);
            if (enemyWave.color != null) {
                g.setColor(enemyWave.color);
            }
            int radius = (int)enemyWave.distanceTraveled;
            g.drawOval((int)(enemyWave.x - (double)radius), (int)(enemyWave.y - (double)radius), radius * 2, radius * 2);
            Point2D.Double dirPos = HUtils.project(enemyWave, enemyWave.directAngle + (double)enemyWave.direction * HUtils.maxEscapeAngle(enemyWave.bulletVelocity()), radius);
            g.drawLine((int)enemyWave.x, (int)enemyWave.y, (int)dirPos.x, (int)dirPos.y);
            double minDanger = Double.POSITIVE_INFINITY;
            double maxDanger = Double.NEGATIVE_INFINITY;
            double maxPointDanger = Double.NEGATIVE_INFINITY;
            Point2D.Double maxDangerPos = null;
            for (x = 0; x <= numBins - 1; ++x) {
                gf = ((double)x - halfBins) / halfBins;
                bearingOffset = gf * HUtils.maxEscapeAngle(enemyWave.bulletVelocity());
                double absFiringAngle = enemyWave.directAngle + bearingOffset;
                HUtils.projectWithCache(enemyWave, absFiringAngle, enemyWave.distanceTraveled + enemyWave.bulletVelocity(), dangerLocation);
                Intersection intersection = new Intersection(HUtils.absoluteBearing(enemyWave, dangerLocation), 36.0 / enemyWave.distance(dangerLocation));
                intersection.status = new MovementPredictor.PredictionStatus(this._myPos.x, this._myPos.y, heading, vel, this._time);
                if (enemyWave.nearestNeighbors != null) {
                    gfDangers[x] = this.getDangerScore(enemyWave, intersection);
                }
                if (gfDangers[x] < minDanger) {
                    minDanger = gfDangers[x];
                }
                if (!(gfDangers[x] > maxDanger)) continue;
                maxDanger = gfDangers[x];
                maxDangerPos = dangerLocation;
            }
            for (x = 0; x <= numBins - 1; ++x) {
                gf = ((double)x - halfBins) / halfBins;
                bearingOffset = gf * HUtils.maxEscapeAngle(enemyWave.bulletVelocity());
                HUtils.projectWithCache(enemyWave, enemyWave.directAngle + bearingOffset, enemyWave.distanceTraveled - 10.0 + enemyWave.bulletVelocity(), drawLocation);
                if (maxPointDanger < gfDangers[x]) {
                    maxPointDanger = gfDangers[x];
                    maxDangerPos = new Point2D.Double(drawLocation.x, drawLocation.y);
                }
                Color binColor = this.getColorForHitRate(gfDangers[x] / maxDanger);
                g.setColor(binColor);
                Stroke cache = g.getStroke();
                g.setStroke(this.bs);
                double length = 15.0 * (gfDangers[x] / maxDanger);
                HUtils.projectWithCache(enemyWave, enemyWave.directAngle + bearingOffset, enemyWave.distanceTraveled - 10.0 + enemyWave.bulletVelocity() + length, lengthLocation);
                g.drawLine((int)drawLocation.x, (int)drawLocation.y, (int)lengthLocation.x, (int)lengthLocation.y);
                g.setStroke(cache);
                drawLocationBuffer = oldDrawLocation;
                oldDrawLocation = drawLocation;
                drawLocation = drawLocationBuffer;
            }
            g.setColor(new Color(1.0f, 0.0f, 1.0f, 0.33f));
            for (TreeGFData nearestNeighbors : enemyWave.nearestNeighbors) {
                for (GFData data : nearestNeighbors.nearestNeighbors) {
                    double bearingOffset2 = (double)enemyWave.direction * (data.guessFactor * HUtils.maxEscapeAngle(enemyWave.bulletVelocity()));
                    Point2D.Double pos = HUtils.project(enemyWave, enemyWave.directAngle + bearingOffset2, enemyWave.distanceTraveled - enemyWave.bulletVelocity());
                    int size = 2;
                    g.drawOval((int)pos.x - size, (int)pos.y - size, size * 2, size * 2);
                }
            }
        }
    }

    public Color getColorForHitRate(double d) {
        return new Color((float)d, (float)(1.0 - d), 1.0f);
    }

    public static class RiskSet
    implements Comparable<RiskSet> {
        public Path path;
        public double risk;
        public RiskSet deeper;

        public RiskSet(Path path, double risk) {
            this.path = path;
            this.risk = risk;
        }

        @Override
        public int compareTo(RiskSet o) {
            return (int)Math.signum(this.risk - o.risk);
        }
    }
}

