/*
 * Decompiled with CFR 0.152.
 */
package jwirde;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import jwirde.Ghost;
import jwirde.Gun;
import robocode.Bullet;

public class GunStats {
    private Map<Bullet, BulletInfo> bulletsInFlight = new HashMap<Bullet, BulletInfo>();
    private Map<String, Map<String, StatLet>> ghostStats = new HashMap<String, Map<String, StatLet>>();

    public void shotFired(Ghost target, Gun gunUsed, Bullet bullet) {
        this.bulletsInFlight.put(bullet, new BulletInfo(target, gunUsed.getName()));
    }

    public void recordHit(Bullet bullet) {
        this.fetchStatLet(bullet).shotHit();
    }

    public void recordMiss(Bullet bullet) {
        this.fetchStatLet(bullet).shotMiss();
    }

    private StatLet fetchStatLet(Bullet bullet) {
        StatLet statLet;
        BulletInfo bulletInfo = this.bulletsInFlight.remove(bullet);
        Map<String, StatLet> stats = this.ghostStats.get(bulletInfo.target.name);
        if (stats == null) {
            stats = new HashMap<String, StatLet>();
            this.ghostStats.put(bulletInfo.target.name, stats);
        }
        if ((statLet = stats.get(bulletInfo.gunUsed)) == null) {
            statLet = new StatLet();
            stats.put(bulletInfo.gunUsed, statLet);
        }
        return statLet;
    }

    public void recordBulletHitBullet(Bullet bullet) {
        this.bulletsInFlight.remove(bullet);
    }

    public String bestTarget(Collection<Ghost> availableGhosts, double range) {
        String result = null;
        double bestRatio = 0.0;
        for (Ghost availableGhost : availableGhosts) {
            Map<String, StatLet> ghostStat = this.ghostStats.get(availableGhost.name);
            if (ghostStat == null || availableGhost.distance > range) continue;
            for (Map.Entry<String, StatLet> statEntry : ghostStat.entrySet()) {
                double ratio = statEntry.getValue().calcRatio();
                if (!(ratio > bestRatio)) continue;
                bestRatio = ratio;
                result = availableGhost.name;
            }
        }
        return result;
    }

    public String bestGun(Ghost target) {
        return null;
    }

    public String toString() {
        String result = "Bullets in flight: " + this.bulletsInFlight.size() + "\n";
        for (Map.Entry<String, Map<String, StatLet>> entry : this.ghostStats.entrySet()) {
            result = String.valueOf(result) + entry.getKey() + "\n";
            for (Map.Entry<String, StatLet> gunStat : entry.getValue().entrySet()) {
                StatLet statLet = gunStat.getValue();
                result = String.valueOf(result) + "\t" + gunStat.getKey() + " hits: " + statLet.hits + " misses: " + statLet.misses + " ratio: " + statLet.calcRatio() + "\n";
            }
        }
        return result;
    }

    private static class BulletInfo {
        final Ghost target;
        final String gunUsed;

        public BulletInfo(Ghost target, String gunUsed) {
            this.target = target;
            this.gunUsed = gunUsed;
        }
    }

    private static class StatLet {
        private int misses;
        private int hits;

        private StatLet() {
        }

        public void shotHit() {
            ++this.hits;
        }

        public void shotMiss() {
            ++this.misses;
        }

        public double calcRatio() {
            return (double)this.hits / (double)(this.hits + this.misses);
        }
    }
}

