/*
 * Decompiled with CFR 0.152.
 */
package KiraNL;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import robocode.AdvancedRobot;
import robocode.BulletHitEvent;
import robocode.HitByBulletEvent;
import robocode.HitRobotEvent;
import robocode.ScannedRobotEvent;
import robocode.util.Utils;

public class Chupacabra
extends AdvancedRobot {
    double previousEnergy = 100.0;
    double changeInEnergy;
    double scannedRobotX;
    double scannedRobotY;
    long lastTime;
    ArrayList<VirtualBullet> bullets = new ArrayList();
    VirtualBullet newBullet;
    VirtualBullet bullet;
    static double direction = 1.0;
    static final double angleScale = 24.0;
    static final double velocityScale = 1.0;
    static double lastEnemyHeading;
    static double lastEnemyEnergy;
    static boolean flat;
    static int hits;
    static StringBuilder data;
    static double bulletVelocity;
    private static long _firetime;

    static {
        data = new StringBuilder();
    }

    public void run() {
        this.scannedRobotX = -1.0;
        this.scannedRobotY = -1.0;
        this.setBodyColor(Color.red);
        this.setGunColor(Color.darkGray);
        this.setRadarColor(Color.red.darker());
        this.setBulletColor(Color.red);
        this.lastTime = 0L;
        this.setAdjustGunForRobotTurn(true);
        this.setAdjustRadarForGunTurn(true);
        this.setAdjustRadarForRobotTurn(true);
        while (true) {
            this.turnRadarRightRadians(Double.POSITIVE_INFINITY);
        }
    }

    public void onScannedRobot(ScannedRobotEvent e) {
        double eHeadingRadians;
        double d;
        double absoluteBearing = e.getBearingRadians() + this.getHeadingRadians();
        this.scannedRobotX = this.getX() + Math.sin(absoluteBearing) * e.getDistance();
        this.scannedRobotY = this.getY() + Math.cos(absoluteBearing) * e.getDistance();
        this.previousEnergy = e.getEnergy();
        this.changeInEnergy = this.previousEnergy - this.previousEnergy;
        if (d > 0.0 && this.changeInEnergy <= 3.0) {
            this.newBullet = new VirtualBullet(this.scannedRobotX, this.scannedRobotY, 20.0 - 3.0 * this.changeInEnergy, Utils.normalRelativeAngle((double)(absoluteBearing + Math.PI + Math.asin(Math.sin(e.getBearingRadians()) * this.getVelocity() / (20.0 - 3.0 * this.changeInEnergy)))));
            this.bullets.add(this.newBullet);
        }
        int i = 0;
        while (i < this.bullets.size()) {
            this.bullet = this.bullets.get(i);
            this.bullet.tick(this.getTime() - this.lastTime);
            this.bullets.set(i, this.bullet);
            if (this.bullets.get(i).checkCollide(this.getX(), this.getY())) {
                this.bullets.remove(i);
                --i;
            }
            ++i;
        }
        double xForce = 0.0;
        double yForce = 0.0;
        int i2 = 0;
        while (i2 < this.bullets.size()) {
            this.bullet = this.bullets.get(i2);
            double absBearing = Utils.normalAbsoluteAngle((double)Math.atan2(this.bullet.x - this.getX(), this.bullet.y - this.getY()));
            double distance = this.bullet.getDistance(this.getX(), this.getY());
            xForce += Math.sin(absBearing) / (distance * distance);
            yForce += Math.cos(absBearing) / (distance * distance);
            ++i2;
        }
        double absBearing = Utils.normalAbsoluteAngle((double)Math.atan2(this.scannedRobotX - this.getX(), this.scannedRobotY - this.getY()));
        double distance = this.getRange(this.scannedRobotX, this.scannedRobotY, this.getX(), this.getY());
        xForce += Math.sin(absBearing) / (distance * distance);
        yForce += Math.cos(absBearing) / (distance * distance);
        xForce += 250.0 / Math.pow(this.getRange(this.getX(), this.getY(), this.getBattleFieldWidth(), this.getY()), 3.0);
        yForce += 250.0 / Math.pow(this.getRange(this.getX(), this.getY(), this.getX(), this.getBattleFieldHeight()), 3.0);
        this.goTo(this.getX() - (xForce -= 250.0 / Math.pow(this.getRange(this.getX(), this.getY(), 0.0, this.getY()), 3.0)), this.getY() - (yForce -= 250.0 / Math.pow(this.getRange(this.getX(), this.getY(), this.getX(), 0.0), 3.0)));
        double headingRadians = this.getHeadingRadians();
        double absbearing = e.getBearingRadians() + headingRadians;
        double eDistance = e.getDistance();
        boolean rammer = eDistance < 70.0 || this.getTime() < 20L;
        double d2 = lastEnemyHeading;
        lastEnemyHeading = eHeadingRadians = e.getHeadingRadians();
        data.insert(0, (char)((d2 - eHeadingRadians) * 24.0)).insert(0, (char)(e.getVelocity() * 1.0));
        Rectangle2D.Double field = new Rectangle2D.Double(17.0, 17.0, 766.0, 566.0);
        int keyLength = Math.min(data.length(), 256);
        int index = -1;
        while ((index = data.indexOf(data.substring(0, keyLength /= 2), (int)(eDistance / 14.0))) < 0 && keyLength > 1) {
        }
        double bulletPower = 400.0 / e.getDistance();
        if (bulletPower < 2.0) {
            bulletPower = 2.0;
        } else if (bulletPower > 3.0) {
            bulletPower = 3.0;
        }
        if (_firetime == this.getTime() && this.getGunTurnRemaining() == 0.0) {
            this.setFire(bulletPower);
        }
        index /= 2;
        double eX = eDistance * Math.sin(absbearing);
        double eY = eDistance * Math.cos(absbearing);
        double db = 0.0;
        double ww = eHeadingRadians;
        double speed = e.getVelocity();
        do {
            db += 20.0 - 3.0 * bulletPower;
            if (index * 2 <= 0) continue;
            speed = (double)((short)data.charAt(index * 2)) / 1.0;
            ww -= (double)((short)data.charAt(index-- * 2 - 1)) / 24.0;
        } while (db < Point2D.distance(0.0, 0.0, eX += speed * Math.sin(ww), eY += speed * Math.cos(ww)) && field.contains(eX + this.getX(), eY + this.getY()));
        this.setTurnGunRightRadians(Utils.normalRelativeAngle((double)(Math.atan2(eX, eY) - this.getGunHeadingRadians())));
        this.setTurnRadarRightRadians(Math.sin(absbearing - this.getRadarHeadingRadians()) * 2.0);
        _firetime = this.getTime() + 1L;
        this.setTurnRadarRightRadians(2.0 * Utils.normalRelativeAngle((double)(absoluteBearing - this.getRadarHeadingRadians())));
        this.lastTime = this.getTime();
    }

    private void goTo(double x, double y) {
        double dist = 20.0;
        double angle = Math.toDegrees(this.absbearing(this.getX(), this.getY(), x, y));
        double r = this.turnTo(angle);
        this.setAhead(dist * r);
    }

    private int turnTo(double angle) {
        int dir;
        double ang = this.normaliseBearing(this.getHeading() - angle);
        if (ang > 90.0) {
            ang -= 180.0;
            dir = -1;
        } else if (ang < -90.0) {
            ang += 180.0;
            dir = -1;
        } else {
            dir = 1;
        }
        this.setTurnLeft(ang);
        return dir;
    }

    private double normaliseBearing(double ang) {
        if (ang > Math.PI) {
            ang -= Math.PI * 2;
        }
        if (ang < -Math.PI) {
            ang += Math.PI * 2;
        }
        return ang;
    }

    private double getRange(double x1, double y1, double x2, double y2) {
        double xo = x2 - x1;
        double yo = y2 - y1;
        double h = Math.sqrt(xo * xo + yo * yo);
        return h;
    }

    private double absbearing(double x1, double y1, double x2, double y2) {
        double xo = x2 - x1;
        double yo = y2 - y1;
        double h = this.getRange(x1, y1, x2, y2);
        if (xo > 0.0 && yo > 0.0) {
            return Math.asin(xo / h);
        }
        if (xo > 0.0 && yo < 0.0) {
            return Math.PI - Math.asin(xo / h);
        }
        if (xo < 0.0 && yo < 0.0) {
            return Math.PI + Math.asin(-xo / h);
        }
        if (xo < 0.0 && yo > 0.0) {
            return Math.PI * 2 - Math.asin(-xo / h);
        }
        return 0.0;
    }

    public void onPaint(Graphics2D g) {
        g.setColor(new Color(255, 0, 0));
        int i = 0;
        while (i < this.bullets.size()) {
            this.bullet = this.bullets.get(i);
            g.fillOval((int)this.bullet.getX() - 3, (int)this.bullet.getY() - 3, 6, 6);
            ++i;
        }
    }

    public void onHitByBullet(HitByBulletEvent e) {
        this.previousEnergy += 3.0 * e.getBullet().getPower();
    }

    public void onBulletHit(BulletHitEvent e) {
        this.previousEnergy -= 4.0 * e.getBullet().getPower() + Math.max(0.0, 2.0 * (e.getBullet().getPower() - 1.0));
    }

    public void onHitRobot(HitRobotEvent e) {
        this.previousEnergy -= 0.6;
    }

    public class VirtualBullet {
        double x;
        double y;
        double speed;
        double angle;

        VirtualBullet(double startX, double startY, double velocity, double trajectory) {
            this.x = startX;
            this.y = startY;
            this.speed = velocity;
            this.angle = trajectory;
        }

        public void tick(long ticks) {
            while (ticks > 0L) {
                this.x += Math.sin(this.angle) * this.speed;
                this.y += Math.cos(this.angle) * this.speed;
                --ticks;
            }
        }

        public double getX() {
            return this.x;
        }

        public double getY() {
            return this.y;
        }

        public double getDistance(double botX, double botY) {
            return Math.sqrt(Math.pow(botX - this.x, 2.0) + Math.pow(botY - this.y, 2.0));
        }

        public boolean checkCollide(double botX, double botY) {
            if (this.x < 0.0 || this.y < 0.0 || this.x > Chupacabra.this.getBattleFieldWidth() || this.y > Chupacabra.this.getBattleFieldHeight()) {
                return true;
            }
            return botX - 18.0 < this.x && botX + 18.0 > this.x && botY - 18.0 < this.y && botY + 18.0 > this.y;
        }
    }
}

