/*
 * Decompiled with CFR 0.152.
 */
package mbh;

import robocode.AdvancedRobot;
import robocode.BulletHitBulletEvent;
import robocode.BulletHitEvent;
import robocode.BulletMissedEvent;
import robocode.Condition;
import robocode.GunTurnCompleteCondition;
import robocode.HitByBulletEvent;
import robocode.HitRobotEvent;
import robocode.HitWallEvent;
import robocode.RobotDeathEvent;
import robocode.ScannedRobotEvent;
import robocode.WinEvent;

public class Mbh
extends AdvancedRobot {
    private String enemy = null;
    private double energy = 1000.0;
    private double enemyDistance = 1000.0;
    private int count = 0;
    private int dist = 100;
    private boolean lastBulletHit = false;

    public void run() {
        this.setAdjustGunForRobotTurn(true);
        while (true) {
            this.setTurnRadarRight(360.0);
            ++this.count;
            if (this.count > 20) {
                this.out.println("No encuentro enemigo, buscando nuevo objetivo");
                this.enemy = null;
            }
            this.execute();
        }
    }

    public void onScannedRobot(ScannedRobotEvent e) {
        double gunTurnAmt;
        if (this.enemy == null) {
            this.enemy = e.getName();
        }
        if (this.enemyDistance > 200.0 && this.energy > 20.0 && e.getEnergy() < 20.0 && e.getDistance() < 200.0 && this.getGunHeat() == 0.0) {
            this.out.println("Ir por el bonus " + e.getName() + " distancia " + e.getDistance() + "energy : " + e.getEnergy());
            gunTurnAmt = this.normalRelativeAngle(e.getBearing() + this.getHeading() - this.getGunHeading());
            this.setTurnGunRight(gunTurnAmt);
            this.waitFor((Condition)new GunTurnCompleteCondition((AdvancedRobot)this));
            this.fire(3.0);
        }
        if (this.enemyDistance > e.getDistance() && !e.getName().equals(this.enemy)) {
            this.out.println("Mi enemigo " + this.enemy + " esta muy lejos, fijando nuevo objetivo: " + e.getName());
            this.enemy = e.getName();
            this.enemyDistance = e.getDistance();
        }
        if (!e.getName().equals(this.enemy)) {
            return;
        }
        this.enemy = e.getName();
        this.energy = e.getEnergy();
        this.enemyDistance = e.getDistance();
        this.count = 0;
        gunTurnAmt = this.normalRelativeAngle(e.getBearing() + this.getHeading() - this.getGunHeading());
        this.setTurnGunRight(gunTurnAmt);
        if (e.getDistance() < 200.0) {
            this.setTurnRight(gunTurnAmt);
        } else {
            this.setTurnRight(e.getBearing());
        }
        this.setAhead(this.dist);
        this.waitFor((Condition)new GunTurnCompleteCondition((AdvancedRobot)this));
        if (e.getDistance() > 500.0 && this.getGunHeat() > 0.0 && !this.lastBulletHit) {
            return;
        }
        if (e.getDistance() < 200.0 && this.lastBulletHit) {
            this.fire(3.0);
        } else {
            this.fire(1.0);
        }
    }

    public void onBulletHit(BulletHitEvent event) {
        this.out.println("I hit " + event.getName() + "!");
        this.lastBulletHit = true;
    }

    public void onBulletHitBullet(BulletHitBulletEvent event) {
        this.lastBulletHit = true;
    }

    public void onBulletHit(BulletMissedEvent event) {
        this.lastBulletHit = false;
    }

    public void onHitByBullet(HitByBulletEvent e) {
        if (this.energy < 20.0 && this.count < 20) {
            return;
        }
        this.enemy = null;
        this.count = 0;
        this.setTurnRight(90.0 - e.getBearing());
        this.setAhead(2 * this.dist);
        this.execute();
    }

    public void onHitWall(HitWallEvent e) {
        this.setTurnRight(e.getBearing());
        this.dist *= -1;
        this.setAhead(this.dist);
    }

    public void onRobotDeath(RobotDeathEvent e) {
        if (this.enemy != null && this.enemy.equals(e.getName())) {
            this.enemy = null;
            this.count = 0;
            this.out.println("Mi enemigo ha muerto");
        }
    }

    public void onHitRobot(HitRobotEvent e) {
        if (this.getGunHeat() == 0.0 && e.getBearing() > -10.0 && e.getBearing() < 10.0) {
            this.fire(3.0);
        }
        this.enemy = null;
        this.count = 0;
        this.enemy = e.getName();
        this.setTurnLeft(90.0 - e.getBearing());
        this.setBack(this.dist);
        this.execute();
    }

    public double normalRelativeAngle(double angle) {
        if (angle > -180.0 && angle <= 180.0) {
            return angle;
        }
        double fixedAngle = angle;
        while (fixedAngle <= -180.0) {
            fixedAngle += 360.0;
        }
        while (fixedAngle > 180.0) {
            fixedAngle -= 360.0;
        }
        return fixedAngle;
    }

    public void onWin(WinEvent e) {
        int i = 0;
        while (i < 50) {
            this.turnRight(30.0);
            this.turnLeft(30.0);
            ++i;
        }
    }
}

