/*
 * Decompiled with CFR 0.152.
 */
package math;

import org.apache.commons.math3.analysis.function.Acos;
import org.apache.commons.math3.analysis.function.Asin;
import org.apache.commons.math3.analysis.function.Atan;
import org.apache.commons.math3.analysis.function.Atan2;
import org.apache.commons.math3.analysis.function.Cos;
import org.apache.commons.math3.analysis.function.Sin;
import org.apache.commons.math3.analysis.function.Tan;

public final class Fath {
    public static final double PI = Math.PI;
    public static final double TWO_PI = Math.PI * 2;
    public static final double HALF_PI = 1.5707963267948966;
    public static final double QUARTER_PI = 0.7853981633974483;
    public static final double THREE_OVER_TWO_PI = Math.PI;
    private static final int BIG_ENOUGH_INT = -16;
    private static final double BIG_ENOUGH_DOUBLE = -16.0;
    private static Sin _sin = new Sin();
    private static Cos _cos = new Cos();
    private static Tan _tan = new Tan();
    private static Asin _asin = new Asin();
    private static Acos _acos = new Acos();
    private static Atan _atan = new Atan();
    private static Atan2 _atan2 = new Atan2();

    public static final double sin(double radians) {
        return _sin.value(radians);
    }

    public static final double cos(double rad) {
        return _cos.value(rad);
    }

    public static final double asin(double ratio) {
        return _asin.value(ratio);
    }

    public static final double acos(double radians) {
        return _acos.value(radians);
    }

    public static final double tan(double radians) {
        return _tan.value(radians);
    }

    public static final double atan(double ratio) {
        return _atan.value(ratio);
    }

    public static final double atan2(double y, double x) {
        return _atan2.value(y, x);
    }

    public static final int floor(double value) {
        return (int)(value + -16.0) - -16;
    }

    public static final int floor(float value) {
        return (int)((double)value + -16.0) - -16;
    }

    public static long signBit(double value) {
        return Double.doubleToLongBits(value) >>> 63;
    }

    public static long signFromSignBit(long signBit) {
        return 1L - (signBit << 1);
    }

    public static long sign(double value) {
        return 1L - (Fath.signBit(value) << 1);
    }
}

