/*
 * Decompiled with CFR 0.152.
 */
package sim;

import java.awt.geom.Point2D;
import java.util.EnumSet;
import java.util.HashMap;
import math.Fath;
import math.Vect2d;
import sim.Data;
import sim.Stat;
import util.Bounds;
import util.CircularArray;
import util.ColorX;

public final class Bot {
    public String Name;
    public long LastUpdated;
    public boolean Alive = true;
    private HashMap<Stat, Double> _stats;
    private HashMap<Stat, CircularArray> _history;
    public ColorX color;
    public Point2D.Double Position;
    public Bounds HitBox;
    public Vect2d Heading;
    public Vect2d Velocity;

    public Bot(String name) {
        this.Name = name;
        this.color = ColorX.GetRobotColor(name);
        this.Position = new Point2D.Double(0.0, 0.0);
        this.HitBox = new Bounds(Data.Battle.RobotWidth, Data.Battle.RobotWidth);
        this.Velocity = new Vect2d(0.0, 0.0);
        this._stats = new HashMap();
        for (Stat stat : EnumSet.allOf(Stat.class)) {
            this._stats.put(stat, 0.0);
        }
        this._history = new HashMap();
        double initialGunHeat = Math.max(0.0, Data.Battle.InitialGunHeat - Data.Battle.GunCoolingRate * (double)Data.Battle.Time);
        this.Set(Stat.GUN_HEAT, initialGunHeat);
    }

    public Double Get(Stat stat) {
        return this._stats.get((Object)stat);
    }

    public void Set(Stat stat, double value) {
        this._stats.put(stat, value);
    }

    public void Add(Stat stat, double value) {
        this.Set(stat, this.Get(stat) + value);
    }

    public void HistAdd(Stat stat, double value) {
        this._history.get((Object)stat).Add(value);
    }

    public double HistGet(Stat stat) {
        return this._history.get((Object)stat).Latest();
    }

    public double HistGetPrevious(Stat stat) {
        return this._history.get((Object)stat).Previous();
    }

    public double HistGetAvg(Stat stat) {
        double[] items;
        double sum = 0.0;
        for (double item : items = this._history.get((Object)stat).All()) {
            sum += item;
        }
        return sum / (double)items.length;
    }

    public double MaximumEscapeAngle(double bulletVelocity) {
        double lateralVelocity = this.Get(Stat.LATERAL_VELOCITY);
        return Fath.asin(lateralVelocity / bulletVelocity);
    }

    public boolean IsThreat() {
        return this.Get(Stat.ENERGY) > 0.1 || Data.EnemyWaves.byBotName(this).size() > 0;
    }

    public static enum Type {
        Standard,
        Droid,
        Leader,
        DroidLeader;

    }
}

