/*
 * Decompiled with CFR 0.152.
 */
package drm.common3;

import drm.common3.Coordinate;
import drm.common3.Mech;
import drm.common3.Utils;
import robocode.AdvancedRobot;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class Motor
extends Mech {
    Coordinate targetPoint;
    Coordinate aheadPoint;
    double speed;
    boolean targetAimTurnEndFlg;
    boolean aheadTurnEndFlg;
    double customTurn;

    public void initialize() {
    }

    public void setTargetPoint(double x, double y) {
        this.targetPoint.x = x;
        this.targetPoint.y = y;
        this.targetAimTurnEndFlg = false;
    }

    public void setAheadPoint(double x, double y) {
        this.aheadPoint.x = x;
        this.aheadPoint.y = y;
        this.aheadTurnEndFlg = false;
    }

    public Coordinate getTargetPoint() {
        return this.targetPoint;
    }

    public Coordinate getAheadPoint() {
        return this.aheadPoint;
    }

    public void resetTargetPoint() {
        this.targetPoint.x = 0.0;
        this.targetPoint.y = 0.0;
        this.targetAimTurnEndFlg = true;
    }

    public void resetAheadPoint() {
        this.aheadPoint.x = 0.0;
        this.aheadPoint.y = 0.0;
        this.aheadTurnEndFlg = true;
    }

    public boolean isFinishedTurningTargetPoint() {
        return this.targetAimTurnEndFlg;
    }

    public boolean isFinishedTurningAheadPoint() {
        return this.aheadTurnEndFlg;
    }

    public void move() {
        this.turn();
        this.accel();
    }

    void turn() {
        double turnAngle = 0.0;
        turnAngle += this.aimedTurn();
        turnAngle += this.avoidTurn();
        turnAngle += this.customTurn();
        if (Math.abs(turnAngle = Utils.normalRelativeAngle(turnAngle)) > Utils.getRobotMaxTurning(this.robot.getVelocity())) {
            turnAngle = turnAngle / Math.abs(turnAngle) * Utils.getRobotMaxTurning(this.robot.getVelocity());
        }
        this.robot.setTurnRight(turnAngle);
        this.clearCustomTurn();
    }

    double aimedTurn() {
        double turnAngle = 0.0;
        if (!this.targetAimTurnEndFlg) {
            double absB = Utils.calcAbsoluteBearing(this.robot.getX(), this.robot.getY(), this.targetPoint.x, this.targetPoint.y);
            double headerR = this.robot.getHeading() + 90.0;
            double headerL = this.robot.getHeading() - 90.0;
            double dr = Utils.normalRelativeAngle(absB - headerR);
            double dl = Utils.normalRelativeAngle(absB - headerL);
            turnAngle = Math.abs(dr) < Math.abs(dl) ? dr : dl;
            if (Math.abs(turnAngle) < 1.0) {
                this.targetAimTurnEndFlg = true;
            }
        }
        return turnAngle;
    }

    double avoidTurn() {
        double header;
        double absB;
        double turnAngle = 0.0;
        if (!this.aheadTurnEndFlg && Math.abs(turnAngle = Utils.normalRelativeAngle((absB = Utils.calcAbsoluteBearing(this.robot.getX(), this.robot.getY(), this.aheadPoint.x, this.aheadPoint.y)) - (header = this.robot.getHeading()))) < 1.0) {
            this.aheadTurnEndFlg = true;
        }
        return turnAngle;
    }

    double customTurn() {
        return this.customTurn;
    }

    void clearCustomTurn() {
        this.customTurn = 0.0;
    }

    void accel() {
        double acc = Utils.getDistanceToKeepVelocity(this.speed);
        this.robot.setAhead(acc);
    }

    public void setSpeed(double s) {
        this.speed = s;
        this.robot.setMaxVelocity(s);
    }

    public double getSpeed() {
        return this.speed;
    }

    public void setTurn(double t) {
        this.customTurn = t;
    }

    private final /* synthetic */ void this() {
        this.targetPoint = new Coordinate();
        this.aheadPoint = new Coordinate();
        this.speed = 0.0;
        this.targetAimTurnEndFlg = true;
        this.aheadTurnEndFlg = true;
        this.customTurn = 0.0;
    }

    public Motor() {
        this.this();
    }

    public Motor(AdvancedRobot r) {
        super(r);
        this.this();
    }
}

