/*
 * Decompiled with CFR 0.152.
 */
package pa3k;

import java.awt.Color;
import java.awt.Graphics2D;
import java.util.ArrayList;
import pa3k.Arc;
import pa3k.Circle;
import pa3k.FilledCircle;
import pa3k.Line;
import pa3k.Paintable;
import pa3k.Point;
import pa3k.Position;

public class Log {
    public static ArrayList<Paintable> list = null;
    public static final int logLevel = 0;

    public static void onPaint(Graphics2D g) {
        if (list != null) {
            int i = 0;
            while (i < list.size()) {
                Paintable a = list.get(i);
                if (!a.shouldLast()) {
                    list.remove(a);
                    --i;
                }
                a.paint(g);
                ++i;
            }
        }
    }

    public static void paintArc(int level, Position source, double angle, double size, double length, Color c) {
        Log.paintArc(level, source, angle, size, length, c, 9);
    }

    public static void paintArc(int level, Position source, double angle, double size, double length, Color c, int delay) {
        if (level > 0) {
            return;
        }
        Position p1 = new Position(source);
        Position p2 = new Position(source);
        p1.modify(1L, length, angle);
        p2.modify(1L, length, angle + size);
        if (list == null) {
            list = new ArrayList();
        }
        list.add(new Arc(new Position[]{source, p1, p2}, c, delay));
    }

    public static void paintLine(int level, Position source, double angle, Color c, int d) {
        if (level > 0) {
            return;
        }
        Position p1 = new Position(source);
        Position p2 = new Position(source);
        p2.modify(1L, 1000.0, angle);
        if (list == null) {
            list = new ArrayList();
        }
        list.add(new Line(new Position[]{p1, p2}, c, d));
    }

    public static void paintLine(int level, Position source, Position target, Color c, int delay) {
        if (level > 0) {
            return;
        }
        Position p1 = new Position(source);
        Position p2 = new Position(target);
        if (list == null) {
            list = new ArrayList();
        }
        list.add(new Line(new Position[]{p1, p2}, c, delay));
    }

    public static void paintPoint(int level, Position p) {
        Log.paintPoint(level, p, Color.WHITE);
    }

    public static void paintPoint(int level, Position p, Color c) {
        Log.paintPoint(level, p, c, 0);
    }

    public static void paintPoint(int level, Position p, Color c, int delay) {
        if (level > 0) {
            return;
        }
        if (list == null) {
            list = new ArrayList();
        }
        list.add(new Point(new Position(p), c, delay));
    }

    public static void paintFilledCircle(int level, Position p, int radius, Color c, int delay) {
        if (level > 0) {
            return;
        }
        if (list == null) {
            list = new ArrayList();
        }
        list.add(new FilledCircle(p, radius, c, delay));
    }

    public static void paintCircle(int level, Position p, int radius, Color c, int delay) {
        if (level > 0) {
            return;
        }
        if (list == null) {
            list = new ArrayList();
        }
        list.add(new Circle(p, radius, c, delay));
    }

    public static void log(int level, String s) {
        if (level > 0) {
            return;
        }
        StackTraceElement[] stackTraceElements = Thread.currentThread().getStackTrace();
        StackTraceElement module = stackTraceElements[2];
        String[] cls = module.getClassName().split("\\.");
        System.out.println(String.valueOf(cls[cls.length - 1]) + "." + stackTraceElements[2].getMethodName() + "(): " + s);
    }
}

