/*
 * Decompiled with CFR 0.152.
 */
package dk.predict;

import dk.Base;
import dk.Enemy;
import dk.Histogram;
import dk.predict.Buckets;
import dk.predict.EnemyPositionPredictor;
import dk.predict.Factors;
import dk.predict.Predictor;
import dk.predict.Tracer;
import dk.predict.TracerController;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class PredictionController {
    protected List predictorFactories = new ArrayList();
    protected List bucketsFactories = new ArrayList();
    protected TracerController tracerController = new TracerController();

    public void doTurn(Base robot, boolean fire) {
        this.tracerController.doTurn();
        if (fire) {
            Iterator enemyIter = robot.getEnemyController().getEnemies().iterator();
            long now = robot.getTime();
            while (enemyIter.hasNext()) {
                Enemy e = (Enemy)enemyIter.next();
                if (now - e.getLastSeen() > (long)robot.config.PREDICT_TRACER_MAX_AGE) continue;
                double power = robot.config.fireController.getGunPower(robot, e);
                Tracer t = new Tracer(robot, e, power, new Factors(robot, e, power));
                this.tracerController.addTracer(t);
            }
        }
        Iterator tracerIter = this.tracerController.getHitTracers().iterator();
        while (tracerIter.hasNext()) {
            Tracer t = (Tracer)tracerIter.next();
            this.tracerDidHit(robot, t);
        }
        tracerIter = this.tracerController.getMissedTracers().iterator();
        while (tracerIter.hasNext()) {
            Tracer t = (Tracer)tracerIter.next();
            this.tracerDidMiss(t);
        }
    }

    public void tracerDidHit(Base robot, Tracer t) {
        EnemyPositionPredictor epp = t.getTarget().getPositionPredictor();
        if (epp == null) {
            this.initializeBuckets(t.getTarget());
            epp = t.getTarget().getPositionPredictor();
        }
        List buckets = epp.getPredictionBuckets();
        Iterator bucketsIter = buckets.iterator();
        while (bucketsIter.hasNext()) {
            Buckets b = (Buckets)bucketsIter.next();
            Histogram h = b.getHistogram(t.getFactors());
            Iterator predictorIterator = h.getObjectIterator();
            while (predictorIterator.hasNext()) {
                Predictor p = (Predictor)predictorIterator.next();
                p.tracerDidHit(robot, t, h);
            }
        }
    }

    public void tracerDidMiss(Tracer t) {
    }

    public void setTarget(Enemy target) {
    }

    public void addPredictorFactory(Predictor.Factory p) {
        this.predictorFactories.add(p);
    }

    public void addBucketsFactory(Buckets.Factory b) {
        this.bucketsFactories.add(b);
    }

    protected void initializeBuckets(Enemy e) {
        ArrayList<Buckets> buckets = new ArrayList<Buckets>(this.bucketsFactories.size());
        Iterator iter = this.bucketsFactories.iterator();
        while (iter.hasNext()) {
            Buckets.Factory factory = (Buckets.Factory)iter.next();
            buckets.add(factory.newInstance(e, this.predictorFactories));
        }
        EnemyPositionPredictor pp = new EnemyPositionPredictor(buckets);
        e.setPositionPredictor(pp);
    }

    public void printStats(PrintStream out) {
        out.println("TRACER STATS");
        this.tracerController.printStats(out);
    }
}

