/*
 * Decompiled with CFR 0.152.
 */
package shrub;

import shrub.Bearing;
import shrub.Heading;
import shrub.RobotDataStore;
import shrub.TurretInstruction;
import shrub.TurretModeAPI;

public class TurretModeRTH
implements TurretModeAPI {
    private Heading mTargetHdng = Heading.ZERO;
    private final double mRotateSpeed;
    private final RobotDataStore mDataStore = RobotDataStore.getInstance();

    public TurretModeRTH(double rotateSpeed) {
        this.mRotateSpeed = rotateSpeed;
    }

    public void setTargetHdng(Heading targetHdng) {
        this.mTargetHdng = targetHdng;
    }

    public TurretInstruction generateInstruction() {
        Heading turretHdng = this.mDataStore.getMyGunHdng();
        Bearing targetBearing = Bearing.valueOfFromTo(turretHdng, this.mTargetHdng);
        double amount = targetBearing.GetAbs();
        if (this.mRotateSpeed < amount) {
            amount = this.mRotateSpeed;
        }
        TurretInstruction instruct = null;
        instruct = targetBearing.IsAligned() ? TurretInstruction.valueOf(TurretInstruction.NONE, amount) : (targetBearing.IsLeftward() ? TurretInstruction.valueOf(TurretInstruction.LEFT, amount) : TurretInstruction.valueOf(TurretInstruction.RIGHT, amount));
        return instruct;
    }
}

