/*
 * Decompiled with CFR 0.152.
 */
package gf.Centaur;

import gf.Centaur.abstracts.Module;
import gf.Centaur.movement.Move;
import gf.Centaur.radar.Radar;
import gf.Centaur.targeting.Gun;
import gf.Centaur.targeting.GunControll;
import gf.Centaur.targeting.HeadOnGun;
import gf.Centaur.targeting.LinearGun;
import gf.Centaur.targeting.PoseidonsTrident;
import gf.Centaur.targeting.VirtualGun;
import gf.Centaur.targeting.ZeusLightning;
import gf.Centaur.utils.ExecutingRobot;
import gf.Centaur.utils.KdTree;
import gf.Centaur.utils.VirtualRobot;
import gf.Centaur.utils.Wave;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import robocode.AdvancedRobot;
import robocode.Bullet;
import robocode.BulletHitBulletEvent;
import robocode.BulletHitEvent;
import robocode.BulletMissedEvent;
import robocode.Condition;
import robocode.CustomEvent;
import robocode.HitByBulletEvent;
import robocode.RobotDeathEvent;
import robocode.Rules;
import robocode.ScannedRobotEvent;
import robocode.StatusEvent;

public class Data
extends Module {
    private AdvancedRobot robot;
    private Move move;
    private Gun gun;
    private Radar radar;
    public Condition NobodyScannedCondition = new Condition("NobodyScannedCondition"){

        public boolean test() {
            return Data.this.robot.getTime() - Data.this.lastTimeScanned >= 10L;
        }
    };
    public Condition WaveBreakCondition = new Condition("WaveBreakCondition"){

        public boolean test() {
            for (Wave wave : Data.this.waves) {
                Point2D.Double double_ = new Point2D.Double(Data.this.robot.getX(), Data.this.robot.getY());
                if (!(double_.distance(wave.getPoint()) < wave.getRadius(Data.this.robot.getTime()))) continue;
                Data.this.lastBreakedWave = wave;
                return true;
            }
            return false;
        }
    };
    private static final double[] guessFactorWeights = new double[]{60.0, 2.5, 6.25, 0.02, 40.019999999999996, 200.0};
    private static final double[] enemieGuessFactorWeights = new double[]{60.0, 2.5, 6.25, 0.02, 40.019999999999996};
    private String victimName = "no victim";
    private HashMap<String, VirtualRobot> enemies = new HashMap(3, 2.0f);
    private double lastDistance = Double.POSITIVE_INFINITY;
    private long lastTimeScanned;
    private HashMap<Shape, Paint> shapes = new HashMap();
    private Vector<Wave> waves = new Vector();
    private Vector<Wave> ownWaves = new Vector();
    private Vector<Bullet> bullets = new Vector();
    private HashMap<String, HashMap<Long, Bullet>> lastHits = new HashMap();
    private Wave lastBreakedWave = null;
    private static HashMap<String, KdTree.WeightedSqrEuclid<Double>> guessFactors = new HashMap();
    private static HashMap<String, KdTree.WeightedSqrEuclid<Double>> enemieGuessFactors = new HashMap();

    public Data(Move move, Gun gun, Radar radar, AdvancedRobot robot) {
        this.move = move;
        this.gun = gun;
        this.radar = radar;
        this.robot = robot;
    }

    @Override
    public void start() {
        this.robot.addCustomEvent(this.NobodyScannedCondition);
        this.robot.addCustomEvent(this.WaveBreakCondition);
    }

    public VirtualRobot getEnemie(String name) {
        return this.enemies.get(name);
    }

    public HashMap<String, KdTree.WeightedSqrEuclid<Double>> getGuessFactors() {
        return guessFactors;
    }

    public HashMap<String, KdTree.WeightedSqrEuclid<Double>> getEnemieGuessFactors() {
        return enemieGuessFactors;
    }

    public double getLastDistance() {
        return this.lastDistance;
    }

    public String getVictimName() {
        return this.victimName;
    }

    public VirtualRobot getVictim() {
        return this.enemies.get(this.victimName);
    }

    public HashMap<String, VirtualRobot> getEnemies() {
        return this.enemies;
    }

    public Vector<Wave> getWaves() {
        return this.waves;
    }

    public Vector<Wave> getOwnWaves() {
        return this.ownWaves;
    }

    public Wave getLastBreakedWave() {
        return this.lastBreakedWave;
    }

    public GunControll[] getGunArray() {
        GunControll[] array = new GunControll[]{new LinearGun(), new HeadOnGun(), new PoseidonsTrident(), new ZeusLightning()};
        return array;
    }

    public VirtualGun[] getVirtualGunArray() {
        VirtualGun[] array = new VirtualGun[]{new LinearGun(), new HeadOnGun()};
        return array;
    }

    public void addBullet(Bullet bullet) {
        this.bullets.add(bullet);
    }

    public Wave getNearWave(String name, double x, double y) {
        double bestDist = 50.0;
        Wave bestWave = null;
        for (Wave wave : this.waves) {
            if (name != wave.getExecName()) continue;
            double dist = new Point2D.Double(x, y).distance(wave.getPoint());
            if (!((dist = Math.abs(dist - wave.getRadius(this.robot.getTime()))) < bestDist)) continue;
            bestDist = dist;
            bestWave = wave;
        }
        return bestWave;
    }

    @Override
    public void draw(Graphics2D g2d) {
        for (Map.Entry<String, VirtualRobot> entry : this.enemies.entrySet()) {
            if (entry.getKey() == this.victimName) {
                g2d.setPaint(new Color(255, 0, 0));
            } else {
                g2d.setPaint(new Color(0, 255, 0));
            }
            g2d.draw(new Rectangle2D.Double(entry.getValue().getX() - 20.0, entry.getValue().getY() - 20.0, 40.0, 40.0));
        }
        for (Map.Entry<Object, Object> entry : this.shapes.entrySet()) {
            g2d.setPaint((Paint)entry.getValue());
            g2d.draw((Shape)entry.getKey());
        }
        if (this.robot.getOthers() == 1) {
            for (Wave wave : this.waves) {
                wave.draw(g2d, this.robot.getTime(), this.getEnemieGuessFactors().get(wave.getExecName()));
            }
        }
    }

    @Override
    public void onHitByBullet(HitByBulletEvent e) {
        Bullet bullet = e.getBullet();
        Wave wave = this.getNearWave(bullet.getName(), bullet.getX(), bullet.getY());
        if (wave != null) {
            double[] location = wave.getSegmentationLocation();
            enemieGuessFactors.get(e.getName()).addPoint(location, wave.getGuessFactor(bullet.getX(), bullet.getY()));
        }
    }

    @Override
    public void onBulletHitBullet(BulletHitBulletEvent e) {
        Bullet hitBullet = e.getHitBullet();
        Wave wave = this.getNearWave(hitBullet.getName(), hitBullet.getX(), hitBullet.getY());
        if (wave != null) {
            enemieGuessFactors.get(hitBullet.getName()).addPoint(wave.getSegmentationLocation(), wave.getGuessFactor(hitBullet.getX(), hitBullet.getY()));
            this.waves.remove(wave);
        }
        this.bullets.remove(e.getBullet());
    }

    @Override
    public void onBulletHit(BulletHitEvent e) {
        if (!this.lastHits.containsKey(e.getName())) {
            this.lastHits.put(e.getName(), new HashMap());
        }
        this.lastHits.get(e.getName()).put(this.robot.getTime(), e.getBullet());
        this.bullets.remove(e.getBullet());
    }

    @Override
    public void onBulletMissed(BulletMissedEvent e) {
        this.bullets.remove(e.getBullet());
    }

    @Override
    public void onScannedRobot(ScannedRobotEvent e) {
        this.lastTimeScanned = this.robot.getTime();
        String scannedName = e.getName();
        if (!this.enemies.containsKey(scannedName)) {
            this.enemies.put(scannedName, new VirtualRobot(e, this.robot));
            if (this.robot.getRoundNum() == 0) {
                KdTree.WeightedSqrEuclid tree = new KdTree.WeightedSqrEuclid(6, 10000);
                tree.setWeights(guessFactorWeights);
                this.getGuessFactors().put(scannedName, tree);
                KdTree.WeightedSqrEuclid enemieTree = new KdTree.WeightedSqrEuclid(5, 2000);
                enemieTree.setWeights(enemieGuessFactorWeights);
                this.getEnemieGuessFactors().put(scannedName, enemieTree);
            }
            System.out.println(String.valueOf(scannedName) + " hinzugef\u00fcgt");
        }
        VirtualRobot enemie = this.enemies.get(scannedName);
        if (e.getEnergy() < enemie.getEnergy()) {
            double difference = enemie.getEnergy() - e.getEnergy();
            if (this.lastHits.containsKey(scannedName)) {
                for (Map.Entry<Long, Bullet> entry : this.lastHits.get(scannedName).entrySet()) {
                    if (enemie.getTime() >= entry.getKey()) continue;
                    difference -= Rules.getBulletDamage((double)entry.getValue().getPower());
                }
            }
            if (difference > 0.1) {
                double bulletPower = difference;
                if (bulletPower > 3.0) {
                    bulletPower /= Math.ceil(bulletPower / 3.0);
                }
                ExecutingRobot execRobot = new ExecutingRobot(enemie, this.robot.getTime(), this.robot.getBattleFieldWidth(), this.robot.getBattleFieldHeight());
                this.waves.add(new Wave(execRobot, this.getVirtualGunArray(), null, bulletPower, new VirtualRobot(this.robot, execRobot), true, false));
            }
        }
        enemie.set(e, this.robot);
        if (!this.enemies.containsKey(this.victimName) || e.getDistance() < this.lastDistance && scannedName != this.victimName) {
            System.out.println("Neues Ziel: " + scannedName);
            this.victimName = scannedName;
        }
        if (this.victimName == this.getVictimName()) {
            this.lastDistance = e.getDistance();
        }
    }

    @Override
    public void onRobotDeath(RobotDeathEvent e) {
        this.enemies.remove(e.getName());
        if (e.getName() == this.victimName) {
            System.out.println("Ziel tot");
            this.victimName = "no victim";
        }
        Vector<Wave> remove = new Vector<Wave>();
        for (Wave wave : this.waves) {
            if (wave.getExecName() != e.getName()) continue;
            remove.add(wave);
        }
        this.waves.removeAll(remove);
    }

    @Override
    public void onCustomEvent(CustomEvent e) {
        if (e.getCondition() == this.WaveBreakCondition) {
            Vector<Wave> remove = new Vector<Wave>();
            for (Wave wave : this.waves) {
                Point2D.Double double_ = new Point2D.Double(this.robot.getX(), this.robot.getY());
                if (!(double_.distance(wave.getPoint()) < wave.getRadius(this.robot.getTime()))) continue;
                remove.add(wave);
            }
            this.waves.removeAll(remove);
        }
    }

    @Override
    public void onStatus(StatusEvent e) {
        for (HashMap<Long, Bullet> times : this.lastHits.values()) {
            Vector<Long> remove = new Vector<Long>();
            for (long time : times.keySet()) {
                if (e.getStatus().getTime() - time <= 5L) continue;
                remove.add(time);
            }
            for (Long time : remove) {
                times.remove(time);
            }
        }
        for (VirtualRobot target : this.enemies.values()) {
            this.ownWaves.add(new Wave(new ExecutingRobot(this.robot), this.getGunArray(), this.getGuessFactors().get(this.getVictimName()), this.gun.getNewBulletPower(target), target, false, true));
        }
        Vector<Wave> remove = new Vector<Wave>();
        for (Wave wave : this.ownWaves) {
            if (this.getEnemie(wave.getTargetName()) != null && !(wave.getRadius(e.getStatus().getTime()) >= wave.getPoint().distance(this.getEnemie(wave.getTargetName()).getPosition()))) continue;
            this.getGuessFactors().get(wave.getTargetName()).addPoint(wave.getSegmentationLocation(), wave.getGuessFactor());
            for (Wave.GoodGun gun : wave.getGoodGuns()) {
                gun.getGun().hasHit(wave.getTargetName());
            }
            remove.add(wave);
        }
        this.ownWaves.removeAll(remove);
    }
}

