/*
 * Decompiled with CFR 0.152.
 */
package pla;

import java.awt.Color;
import pla.EnemyBullet;
import pla.EnemyBulletsManager;
import pla.TargetInfo;
import pla.Trig;
import robocode.AdvancedRobot;
import robocode.HitRobotEvent;
import robocode.HitWallEvent;
import robocode.ScannedRobotEvent;

public class Memnoch
extends AdvancedRobot {
    double BFH;
    double BFW;
    int direction = 1;
    double HALF_PI = 1.5707963267948966;
    double ONE_PI = Math.PI;
    double SCAN_ARC = 0.39269908169872414;
    TargetInfo target;
    double TWO_PI = Math.PI * 2;
    EnemyBulletsManager bulletManager;
    boolean doRegularMove = true;

    public void run() {
        this.bulletManager = new EnemyBulletsManager();
        this.target = new TargetInfo();
        this.setColors(new Color(141, 16, 8), new Color(141, 16, 8), new Color(235, 238, 0));
        this.setAdjustRadarForGunTurn(true);
        this.BFH = this.getBattleFieldHeight();
        this.BFW = this.getBattleFieldWidth();
        while (this.getOthers() > 0) {
            this.scanForTarget();
            this.targetGun();
            this.moveRobot();
            this.clearBullets();
        }
        while (true) {
            this.doRegularMove = false;
            this.scanForTarget();
            this.moveRobot();
            this.execute();
            this.clearBullets();
        }
    }

    public void clearBullets() {
        this.bulletManager.clearOldBullets(this.getTime());
    }

    public void moveRobot() {
        long timeOnImpact = this.bulletManager.getFirstTimeOnImpact(this.getTime());
        long timeToImpact = timeOnImpact - this.getTime();
        if (timeToImpact == 5L) {
            if (Math.random() < 0.2) {
                this.direction *= -1;
                this.setMaxVelocity(8.0);
                this.setAhead(this.direction * 100);
            } else {
                if (Math.random() < 0.7) {
                    this.direction *= -1;
                }
                this.setMaxVelocity(4.0 + Math.random() * 4.0);
                this.setAhead(this.direction * 100);
            }
        } else if (this.doRegularMove) {
            double maxVelo = 4.0 + Math.random() * 4.0;
            this.setMaxVelocity(maxVelo);
            this.setAhead(this.direction * 100);
        }
        double turnAngleRad = this.target.distance > 300.0 ? this.target.bearingRad + this.HALF_PI - (double)this.direction * 0.5 : this.target.bearingRad + this.HALF_PI;
        this.setTurnRightRadians(turnAngleRad);
    }

    public void onHitRobot(HitRobotEvent e) {
        this.setAhead(this.direction * -30);
        this.setTurnRight(70.0 - e.getBearing());
        this.execute();
    }

    public void onHitWall(HitWallEvent e) {
        this.direction *= -1;
        this.setAhead(this.direction * 73);
    }

    public void onScannedRobot(ScannedRobotEvent e) {
        this.target.name = e.getName();
        this.target.bearing = e.getBearing();
        this.target.bearingRad = e.getBearingRadians();
        this.target.heading = e.getHeading();
        this.target.headingRad = e.getHeadingRadians();
        this.target.ctime = this.getTime();
        this.target.velocity = e.getVelocity();
        this.target.distance = e.getDistance();
        this.target.setEnergy(e.getEnergy());
        double absbearing_rad = (this.getHeadingRadians() + e.getBearingRadians()) % this.TWO_PI;
        this.target.x = this.getX() + Math.sin(absbearing_rad) * e.getDistance();
        this.target.y = this.getY() + Math.cos(absbearing_rad) * e.getDistance();
        if (this.target.bulletEnergy() > 0.0 && this.target.bulletEnergy() <= 3.0) {
            EnemyBullet bullet = new EnemyBullet();
            bullet.setDistance(this.target.distance);
            bullet.setFireTime(this.target.ctime);
            bullet.setPower(this.target.bulletEnergy());
            bullet.setOrigin(this.target.x, this.target.y);
            this.bulletManager.addEnemyBullet(bullet);
        }
    }

    public void scanForTarget() {
        double radarOffset;
        double theTime = this.getTime();
        if (theTime - (double)this.target.ctime > 4.0) {
            radarOffset = this.TWO_PI;
        } else {
            radarOffset = this.getRadarHeadingRadians() - Trig.absbearing(this.getX(), this.getY(), this.target.x, this.target.y);
            radarOffset = radarOffset < 0.0 ? (radarOffset -= this.SCAN_ARC) : (radarOffset += this.SCAN_ARC);
            radarOffset = Trig.NormaliseBearing(radarOffset);
        }
        this.setTurnRadarLeftRadians(radarOffset);
    }

    public void targetGun() {
        boolean RANDOM_TARGETING = true;
        boolean USE_PREDICT = true;
        double bulletPower = this.target.distance < 100.0 ? 3.0 : 2.0;
        double bulletVelo = 20.0 - 3.0 * bulletPower;
        long time = this.getTime() + (long)((int)(this.target.distance / bulletVelo));
        double absoluteBearing = USE_PREDICT ? Trig.absbearing(this.getX(), this.getY(), this.target.guessX(time), this.target.guessY(time)) : Trig.absbearing(this.getX(), this.getY(), this.target.x, this.target.x);
        double gunOffset = this.getGunHeadingRadians() - absoluteBearing;
        double normalBearing = Trig.NormaliseBearing(gunOffset);
        if (RANDOM_TARGETING) {
            double angleRandomRange = Math.toRadians(Math.asin(this.target.velocity / bulletVelo));
            angleRandomRange *= Math.random();
            if (Math.random() > 0.5) {
                angleRandomRange *= -1.0;
            }
            normalBearing += angleRandomRange;
        }
        this.setTurnGunLeftRadians(normalBearing);
        this.fire(bulletPower);
    }
}

