/*
 * Decompiled with CFR 0.152.
 */
package agd.util;

import agd.util.Compass;
import agd.util.Coord;
import agd.util.FastGoto;
import agd.util.GotoMethod;
import agd.util.Navigation;
import agd.util.NavigationStrategy;
import agd.util.Navigator;
import agd.util.RobotInformation;
import robocode.AdvancedRobot;
import robocode.HitRobotEvent;
import robocode.HitWallEvent;

public class CollisionBackoff
extends GotoMethod
implements NavigationStrategy {
    Navigator navigator = null;
    NavigationStrategy nextStrategy = null;
    Navigator after = null;
    HitRobotEvent hre = null;
    Coord backoffPoint = null;
    NavigationStrategy gotoStrategy = null;
    double hitbearing;
    long hittime;

    public CollisionBackoff(RobotInformation r, HitRobotEvent hre, Navigator after, NavigationStrategy nextStrategy) {
        super(r, null);
        this.navigator = after;
        this.nextStrategy = nextStrategy;
        this.after = after;
        this.hittime = hre.getTime();
        this.hitbearing = hre.getBearing();
        AdvancedRobot ar = this.robot.getAdvancedRobot();
        Navigation navinfo = new Navigation();
        this.robot.addListener(this);
        Compass ourHeading = new Compass(ar.getHeading());
        Compass crashHeading = new Compass(ourHeading.getDegrees() - hre.getBearing());
        Coord ourPosition = this.robot.getPosition();
        this.backoffPoint = ourPosition.applyVector(new Compass(crashHeading.getDegrees() + 180.0), 75.0);
        this.gotoStrategy = new FastGoto(this.robot, this.backoffPoint);
        this.setDestination(this.backoffPoint);
    }

    public String toString() {
        return "CollisionBackoff to " + this.backoffPoint;
    }

    public void discard() {
    }

    public void onHitRobot(HitRobotEvent hre) {
        this.setDone(true);
        System.out.println("Hit a robot while in collision backoff - reverting to " + this.nextStrategy);
    }

    public void onHitWall(HitWallEvent hre) {
        this.setDone(true);
        System.out.println("Hit a wall while in collision backoff - reverting to " + this.nextStrategy);
    }

    public Navigation navigate() {
        Navigation navinfo = null;
        if (this.isDone() || this.gotoStrategy.isDone()) {
            this.gotoStrategy.discard();
            this.discard();
            this.after.setNavigationStrategy(this.nextStrategy);
            navinfo = this.nextStrategy.navigate();
        } else {
            navinfo = this.gotoStrategy.navigate();
        }
        return navinfo;
    }
}

