/*
 * Decompiled with CFR 0.152.
 */
package agd.util;

import agd.util.Compass;
import agd.util.Coord;
import agd.util.GotoMethod;
import agd.util.Navigation;
import agd.util.NavigationStrategy;
import agd.util.Navigator;
import agd.util.RobotInformation;

public class FastGoto
extends GotoMethod
implements NavigationStrategy {
    NavigationStrategy nextStrategy = null;
    Navigator navigator = null;

    public FastGoto(RobotInformation r, Coord destination) {
        super(r, destination);
    }

    public FastGoto(RobotInformation r, Coord destination, Navigator n, NavigationStrategy strat) {
        super(r, destination);
        this.navigator = n;
        this.nextStrategy = strat;
    }

    public void discard() {
    }

    public String toString() {
        return "FastGoto { within " + this.acceptableRange + " of " + this.destination + "}";
    }

    public Navigation navigate() {
        Navigation navinfo = new Navigation();
        Coord ourPos = this.robot.getPosition();
        if (!this.finished && ourPos.distanceTo(this.destination) < this.acceptableRange) {
            this.finished = true;
        }
        if (!this.finished) {
            Compass ourHeading = new Compass(this.robot.getAdvancedRobot().getHeading());
            Compass requiredHeading = ourPos.headingTo(this.destination);
            double bearing = ourHeading.bearingTo(requiredHeading);
            double direction = 1.0;
            if (bearing > 90.0) {
                direction = -1.0;
                bearing -= 180.0;
            } else if (bearing < -90.0) {
                direction = -1.0;
                bearing += 180.0;
            }
            double distance = ourPos.distanceTo(this.destination);
            navinfo = new Navigation(new Double(direction * distance), new Double(bearing));
            if (distance < 200.0 && Math.abs(bearing) > 45.0) {
                navinfo.setMaxVelocity(1.0 + distance / 28.0);
            } else {
                navinfo.setMaxVelocity(8.0);
            }
        } else if (this.navigator != null && this.nextStrategy != null) {
            this.navigator.setNavigationStrategy(this.nextStrategy);
            navinfo = this.nextStrategy.navigate();
        }
        return navinfo;
    }
}

