/*
 * Decompiled with CFR 0.152.
 */
package gjr;

import gjr.Enemy;
import gjr.MovementStrategy;
import gjr.StrategyRobot;
import java.awt.geom.Point2D;
import java.util.Iterator;

public class AntigravityMovementStrategy
implements MovementStrategy {
    public void doMovement(StrategyRobot robot) {
        Iterator keys = robot.getEnemies().keySet().iterator();
        double xForce = 0.0;
        double yForce = 0.0;
        double totalDanger = 0.0;
        double myX = robot.getX();
        double myY = robot.getY();
        while (keys.hasNext()) {
            Enemy enemy = (Enemy)robot.getEnemies().get(keys.next());
            double enemyX = enemy.getX();
            double enemyY = enemy.getY();
            double distance = Point2D.Double.distance(myX, myY, enemyX, enemyY);
            double force = enemy.getDanger() / Math.pow(distance, 2.0);
            double angle = Math.atan2(enemyX - myX, enemyY - myY);
            xForce -= force * Math.sin(angle);
            yForce -= force * Math.cos(angle);
            totalDanger += enemy.getDanger();
        }
        robot.setTurnRightRadians(Math.atan2(xForce += totalDanger / Math.pow(myX, 2.0) - 1.0 / Math.pow(robot.getBattleFieldWidth() - myX, 2.0), yForce += totalDanger / Math.pow(myY, 2.0) - 1.0 / Math.pow(robot.getBattleFieldHeight() - myY, 2.0)) - robot.getHeadingRadians());
        robot.setAhead(100.0);
        robot.execute();
    }
}

