/*
 * Decompiled with CFR 0.152.
 */
package gtf.robocode.opponent;

import gtf.robocode.Point;
import gtf.robocode.Reading;
import gtf.robocode.opponent.Opponent;

class LinearOpponent
extends Opponent {
    Reading lastReading;

    LinearOpponent(String name) {
        super(name);
    }

    public Point getLastPosition() {
        return new Point(this.lastReading.getTime(), this.lastReading.getX(), this.lastReading.getY());
    }

    public Point getPredictedPosition(double time) {
        double speed = this.lastReading.getSpeed();
        double heading = this.lastReading.getHeadingRadians();
        double dt = time - (double)this.lastReading.getTime();
        return new Point(time, this.lastReading.getX() + speed * dt * Math.sin(heading), this.lastReading.getY() + speed * dt * Math.cos(heading));
    }

    void addReading(Reading reading) {
        this.lastReading = reading;
    }
}

