/*
 * Decompiled with CFR 0.152.
 */
package bing2;

import bing2.Enemy;
import bing2.EnemyTracker;
import bing2.GFGun;
import bing2.Gun;
import bing2.MathUtils;
import bing2.Move;
import bing2.MyRobot;
import bing2.Surfer;
import bing2.VirtualGun;
import bing2.Wave;
import bing2.WaveTracker;
import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;
import robocode.BulletHitBulletEvent;
import robocode.BulletHitEvent;
import robocode.CustomEvent;
import robocode.DeathEvent;
import robocode.HitByBulletEvent;
import robocode.HitWallEvent;
import robocode.ScannedRobotEvent;
import robocode.SkippedTurnEvent;
import robocode.WinEvent;

public class Melody
extends MyRobot {
    static long maxHistorySize = 2000L;
    static HashMap<String, EnemyTracker> enemyTrackers = new HashMap();
    static VirtualGun vGun = new VirtualGun();
    static int skippedTurns = 0;
    static double VGUN_POWER = 2.0;
    Gun gun;
    Move move;
    String currentEnemy;

    void initRobot() {
        this.debug = false;
        this.outputLevel = 6;
        this.gun = new GFGun(this);
        this.move = new Surfer(this);
        this.setColors(Color.PINK, Color.lightGray, Color.lightGray);
        for (String string : enemyTrackers.keySet()) {
            EnemyTracker enemyTracker = enemyTrackers.get(string);
            if (enemyTracker == null) continue;
            enemyTracker.onRoundStart();
        }
        vGun.onRoundStart(this);
    }

    public void run() {
        this.initRobot();
        this.setAdjustGunForRobotTurn(true);
        this.setAdjustRadarForGunTurn(true);
        while (true) {
            this.doScanner();
            this.doMove();
            this.doGun();
            this.doLog("Execute", 1);
            this.execute();
        }
    }

    public void onScannedRobot(ScannedRobotEvent scannedRobotEvent) {
        super.onScannedRobot(scannedRobotEvent);
        EnemyTracker enemyTracker = this.getTracker(scannedRobotEvent.getName());
        Enemy enemy = enemyTracker.addObservation(this.getTime(), scannedRobotEvent, this);
        this.currentEnemy = scannedRobotEvent.getName();
    }

    void doGun() {
        if (this.currentEnemy == null) {
            return;
        }
        EnemyTracker enemyTracker = this.getTracker(this.currentEnemy);
        int n = MathUtils.sign(Math.sin(enemyTracker.latest.heading - enemyTracker.latest.bearing));
        vGun.fire(VGUN_POWER, enemyTracker.latest.bearing, n);
        vGun.updateWaves(enemyTracker.latest.getPosition());
        this.gun.aim(enemyTracker);
    }

    void doMove() {
        EnemyTracker enemyTracker;
        EnemyTracker enemyTracker2 = enemyTracker = this.currentEnemy == null ? null : this.getTracker(this.currentEnemy);
        if (enemyTracker != null) {
            enemyTracker.waves.updateWaves(this.getTime(), this.getPosition());
        }
        int n = this.getOthers();
        switch (n) {
            case 1: {
                this.move.oneOnOneMove(enemyTracker);
                break;
            }
            case 0: {
                this.move.winningDance();
                break;
            }
            default: {
                this.move.oneOnOneMove(enemyTracker);
            }
        }
    }

    public void onCustomEvent(CustomEvent customEvent) {
    }

    public void onHitWall(HitWallEvent hitWallEvent) {
        this.doLog("++++++++++++++++++++ Hit Wall ++++++++++++++++++++", 5);
        this.doLog("Bearing = " + hitWallEvent.getBearing(), 5);
    }

    public EnemyTracker getCurrentEnemyTracker() {
        return this.getTracker(this.currentEnemy);
    }

    EnemyTracker getTracker(String string) {
        if (!enemyTrackers.containsKey(string)) {
            enemyTrackers.put(string, new EnemyTracker(maxHistorySize, string));
        }
        return enemyTrackers.get(string);
    }

    public void onHitByBullet(HitByBulletEvent hitByBulletEvent) {
        EnemyTracker enemyTracker = this.getTracker(hitByBulletEvent.getName());
        if (enemyTracker.waves == null) {
            return;
        }
        if (this.debug) {
            WaveTracker waveTracker = enemyTracker.waves;
            waveTracker.updateWaves(this.getTime(), this.getPosition());
            ArrayList<Wave> arrayList = waveTracker.hitWaves;
            int n = 5;
            boolean bl = false;
            for (int i = arrayList.size() - 1; i >= 0; --i) {
                long l = arrayList.get((int)i).hitTime - this.getTime();
                if (Math.abs(l) > 2L) continue;
                this.doLog("Wave prediction matches HitByBullet, time error = " + l + ", total waves = " + waveTracker.waveCount + ", current & approaching waves = " + waveTracker.waves.size(), n);
                this.doLog("Time for approaching waves hit robot if standing still:", n);
                for (Wave wave : waveTracker.waves) {
                    if (wave.hitTime != 0L) continue;
                    this.doLog(wave, n);
                    this.doLog("Time = " + wave.timeToHitRobot(this.getPosition()), n);
                }
                bl = true;
                break;
            }
            if (!bl) {
                this.doLog(">>>> No wave predicts this HitByBullet event" + arrayList.size(), n);
                this.doLog("H = " + hitByBulletEvent.getHeading() + ", P = " + this.getPosition(), n);
                this.doLog("Last hitWave:", n);
                if (arrayList.size() > 0) {
                    this.doLog(arrayList.get(arrayList.size() - 1), n);
                }
            }
        }
        enemyTracker.waves.onHitByBullet(hitByBulletEvent);
    }

    public void onSkippedTurn(SkippedTurnEvent skippedTurnEvent) {
        this.doLog(">>>>>>>>>>> SKIPPED TURN : " + ++skippedTurns, 10);
    }

    public void onBulletHitBullet(BulletHitBulletEvent bulletHitBulletEvent) {
        EnemyTracker enemyTracker = this.getTracker(bulletHitBulletEvent.getHitBullet().getName());
        enemyTracker.waves.onBulletHitBullet(bulletHitBulletEvent);
    }

    public void onBulletHit(BulletHitEvent bulletHitEvent) {
        this.gun.onBulletHit(bulletHitEvent);
    }

    public void onWin(WinEvent winEvent) {
        if (this.debug) {
            EnemyTracker enemyTracker = this.getCurrentEnemyTracker();
            enemyTracker.waves.reportStatistics(this.out);
            GFGun cfr_ignored_0 = (GFGun)this.gun;
            GFGun.selfWaves.reportStatistics(this.out);
        }
    }

    public void onDeath(DeathEvent deathEvent) {
        if (this.debug) {
            EnemyTracker enemyTracker = this.getCurrentEnemyTracker();
            enemyTracker.waves.reportStatistics(this.out);
            GFGun cfr_ignored_0 = (GFGun)this.gun;
            GFGun.selfWaves.reportStatistics(this.out);
        }
    }
}

