/*
 * Decompiled with CFR 0.152.
 */
package rjw.pluggablerobot;

import java.awt.Graphics2D;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import rjw.pluggablerobot.Component;
import rjw.pluggablerobot.EventListener;
import rjw.pluggablerobot.Hud;
import rjw.pluggablerobot.ListenerDelegate;
import robocode.AdvancedRobot;
import robocode.BattleEndedEvent;
import robocode.BulletHitBulletEvent;
import robocode.BulletHitEvent;
import robocode.BulletMissedEvent;
import robocode.Condition;
import robocode.CustomEvent;
import robocode.DeathEvent;
import robocode.HitByBulletEvent;
import robocode.HitRobotEvent;
import robocode.HitWallEvent;
import robocode.PaintEvent;
import robocode.RobotDeathEvent;
import robocode.ScannedRobotEvent;
import robocode.SkippedTurnEvent;
import robocode.StatusEvent;
import robocode.WinEvent;

public abstract class PluggableRobot
extends AdvancedRobot {
    private static boolean _battleInitialized = false;
    private static Point2D.Double _center;
    private ListenerDelegate _listenerDelegate;
    private ArrayList<Component> _components = new ArrayList();
    private Hud _hud;

    public PluggableRobot() {
        this._listenerDelegate = new ListenerDelegate();
    }

    public final void run() {
        if (!_battleInitialized) {
            _center = new Point2D.Double(this.getWidth() / 2.0, this.getHeight() / 2.0);
            this.initBattle();
            _battleInitialized = true;
        }
        this.addCustomEvent(new Condition("eventManager"){

            public boolean test() {
                PluggableRobot.this.handleEvents();
                return false;
            }
        });
        this._hud = new Hud(this);
        this.registerListener(this._hud);
        this.initRound();
        while (true) {
            for (Component component : this._components) {
                component.go();
            }
            PaintEvent pe = this._listenerDelegate.getLastPaintEvent();
            if (pe != null && pe.getTime() == this.getTime()) {
                this._hud.paint(this.getTime());
            }
            this.execute();
        }
    }

    public Point2D.Double getCenter() {
        return _center;
    }

    protected abstract void initBattle();

    protected abstract void initRound();

    protected final void registerListener(EventListener listener) {
        this._listenerDelegate.register(listener);
    }

    protected void registerComponent(Component component) {
        this._components.add(component);
    }

    protected void createLayer(int key, String name, boolean enabled) {
        this._hud.createLayer(key, name, enabled);
    }

    protected void registerPainter(int key, Hud.Painter painter) {
        this._hud.registerPainter(key, painter);
    }

    private void handleEvents() {
        this._listenerDelegate.processEvents(this.getAllEvents());
        this.clearAllEvents();
    }

    public final void onBattleEnded(BattleEndedEvent event) {
    }

    public final void onBulletHit(BulletHitEvent event) {
    }

    public final void onBulletHitBullet(BulletHitBulletEvent event) {
    }

    public final void onBulletMissed(BulletMissedEvent event) {
    }

    public final void onCustomEvent(CustomEvent event) {
    }

    public final void onDeath(DeathEvent event) {
    }

    public final void onHitByBullet(HitByBulletEvent event) {
    }

    public final void onHitRobot(HitRobotEvent event) {
    }

    public final void onHitWall(HitWallEvent event) {
    }

    public final void onKeyPressed(KeyEvent e) {
    }

    public final void onKeyReleased(KeyEvent e) {
    }

    public final void onKeyTyped(KeyEvent e) {
    }

    public final void onMouseClicked(MouseEvent e) {
    }

    public final void onMouseDragged(MouseEvent e) {
    }

    public final void onMouseEntered(MouseEvent e) {
    }

    public final void onMouseExited(MouseEvent e) {
    }

    public final void onMouseMoved(MouseEvent e) {
    }

    public final void onMousePressed(MouseEvent e) {
    }

    public final void onMouseReleased(MouseEvent e) {
    }

    public final void onMouseWheelMoved(MouseWheelEvent e) {
    }

    public final void onPaint(Graphics2D g) {
    }

    public final void onRobotDeath(RobotDeathEvent event) {
    }

    public final void onScannedRobot(ScannedRobotEvent event) {
    }

    public final void onSkippedTurn(SkippedTurnEvent event) {
    }

    public final void onStatus(StatusEvent e) {
    }

    public final void onWin(WinEvent event) {
    }
}

