/*
 * Decompiled with CFR 0.152.
 */
package mb;

import mb.core.BattleStatistics;
import mb.core.Coordinates;
import mb.guns.Gun;
import mb.movement.MovementHandler;
import mb.radar.Radar;
import mb.utils.MathUtils;
import mb.utils.PaintUtils;
import robocode.AdvancedRobot;
import robocode.BattleEndedEvent;
import robocode.BulletHitBulletEvent;
import robocode.BulletHitEvent;
import robocode.BulletMissedEvent;
import robocode.CustomEvent;
import robocode.DeathEvent;
import robocode.HitByBulletEvent;
import robocode.RobotDeathEvent;
import robocode.RoundEndedEvent;
import robocode.Rules;
import robocode.ScannedRobotEvent;

public abstract class MBRobot
extends AdvancedRobot {
    protected double enemyEnergy = 100.0;
    protected Gun gun;
    protected Radar radar;
    protected MovementHandler movements;
    protected PaintUtils paintUtils;
    protected static BattleStatistics statistics = new BattleStatistics();

    public void run() {
        this.movements = new MovementHandler(this);
        this.init();
        this.turnRadarRightRadians(Double.POSITIVE_INFINITY);
        while (true) {
            this.setAdjustGunForRobotTurn(true);
            this.setAdjustRadarForRobotTurn(true);
            this.setAdjustRadarForRobotTurn(true);
            this.radar.run();
            this.scan();
        }
    }

    public void onBulletHit(BulletHitEvent event) {
        ++MBRobot.statistics.hits;
        this.enemyEnergy -= Rules.getBulletDamage((double)event.getBullet().getPower());
        super.onBulletHit(event);
    }

    public void onHitByBullet(HitByBulletEvent event) {
        ++MBRobot.statistics.hitByBullet;
        this.enemyEnergy += Rules.getBulletHitBonus((double)event.getPower());
        this.movements.onHitByBullet(event);
        super.onHitByBullet(event);
    }

    public void onDeath(DeathEvent event) {
        ++MBRobot.statistics.losses;
        this.movements.onDeath(event);
        super.onDeath(event);
    }

    public void onRobotDeath(RobotDeathEvent event) {
        ++MBRobot.statistics.wins;
        this.movements.onRobotDeath(event);
        super.onRobotDeath(event);
    }

    public void onCustomEvent(CustomEvent event) {
        this.gun.onCustomEvent(event);
        this.radar.onCustomEvent(event);
        this.movements.onCustomEvent(event);
        super.onCustomEvent(event);
    }

    public void onBattleEnded(BattleEndedEvent event) {
        statistics.printStatistics();
        super.onBattleEnded(event);
    }

    public void onBulletHitBullet(BulletHitBulletEvent event) {
        ++MBRobot.statistics.hitOtherBullet;
        super.onBulletHitBullet(event);
    }

    public void onRoundEnded(RoundEndedEvent event) {
        ++MBRobot.statistics.rounds;
        statistics.printStatistics();
        super.onRoundEnded(event);
    }

    public void onBulletMissed(BulletMissedEvent event) {
        ++MBRobot.statistics.missed;
        super.onBulletMissed(event);
    }

    public Coordinates getMyCoordinates() {
        return new Coordinates(this.getX(), this.getY());
    }

    public BattleStatistics getBattleStatistics() {
        return statistics;
    }

    protected boolean hasEnemyFired(ScannedRobotEvent event) {
        return this.enemyEnergy - event.getEnergy() <= 3.0 && this.enemyEnergy - event.getEnergy() >= 0.1;
    }

    protected double getEnemyFirePower(ScannedRobotEvent event) {
        return this.enemyEnergy - event.getEnergy();
    }

    protected abstract void init();

    protected void paintVectors(ScannedRobotEvent event) {
        Coordinates enemy = MathUtils.getEnemyCoordinates(this.getMyCoordinates(), this.getHeading(), event.getBearing(), event.getDistance());
        this.paintUtils.paintVector(this.getMyCoordinates(), (this.getHeading() + event.getBearing()) % 360.0);
        this.paintUtils.paintVector(this.getMyCoordinates(), this.getHeading());
        this.paintUtils.paintVector(enemy, event.getHeading());
    }
}

